/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked_programs.cccbridge.common.computercraft;

import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TweakedPeripheral<BE extends BlockEntity>
extends IPeripheral {
    public static final List<IComputerAccess> computers = new LinkedList<IComputerAccess>();

    default public void sendEvent(@Nonnull String event, Object ... arguments) {
        for (IComputerAccess pc : computers) {
            pc.queueEvent(event, new Object[]{pc.getAttachmentName(), arguments});
        }
    }

    default public void attach(@Nonnull IComputerAccess computer) {
        computers.add(computer);
    }

    default public void detach(@Nonnull IComputerAccess computer) {
        computers.removeIf(p -> p.getID() == computer.getID());
    }

    @NotNull
    public String getType();

    @Nullable
    public BE getTarget();

    public static double getVersion() {
        return 0.0;
    }

    default public boolean equals(@Nullable IPeripheral other) {
        return other == this && other.getType().equals(this.getType()) && other.getTarget() == this.getTarget();
    }
}

