/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.mixin.entity;

import com.copycatsplus.copycats.CCBlocks;
import com.copycatsplus.copycats.CCCatVariants;
import com.simibubi.create.AllTags;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Cat.class})
public abstract class CatMixin
extends TamableAnimal {
    @Unique
    private static final EntityDataAccessor<CatVariant> DATA_NATURAL_VARIANT_ID = SynchedEntityData.m_135353_(Cat.class, (EntityDataSerializer)EntityDataSerializers.f_238114_);

    @Shadow
    public abstract CatVariant m_28554_();

    @Shadow
    public abstract void m_28464_(CatVariant var1);

    @Shadow
    protected abstract void m_142075_(Player var1, InteractionHand var2, ItemStack var3);

    protected CatMixin(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Unique
    public CatVariant getNaturalVariant() {
        return (CatVariant)this.f_19804_.m_135370_(DATA_NATURAL_VARIANT_ID);
    }

    @Unique
    public void setNaturalVariant(CatVariant pVariant) {
        this.f_19804_.m_135381_(DATA_NATURAL_VARIANT_ID, (Object)pVariant);
    }

    @Inject(at={@At(value="RETURN")}, method={"defineSynchedData()V"})
    private void defineNaturalVariant(CallbackInfo ci) {
        this.f_19804_.m_135372_(DATA_NATURAL_VARIANT_ID, (Object)((CatVariant)BuiltInRegistries.f_256754_.m_123013_(CatVariant.f_218150_)));
    }

    @Inject(at={@At(value="RETURN")}, method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"})
    private void addNaturalVariantData(CompoundTag pCompound, CallbackInfo ci) {
        pCompound.m_128359_("NaturalVariant", Objects.requireNonNull(BuiltInRegistries.f_256754_.m_7981_((Object)this.getNaturalVariant())).toString());
    }

    @Inject(at={@At(value="RETURN")}, method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"})
    private void readNaturalVariantData(CompoundTag pCompound, CallbackInfo ci) {
        CatVariant catvariant = (CatVariant)BuiltInRegistries.f_256754_.m_7745_(ResourceLocation.m_135820_((String)pCompound.m_128461_("NaturalVariant")));
        if (catvariant != null) {
            this.setNaturalVariant(catvariant);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"usePlayerItem(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/item/ItemStack;)V"})
    private void useCopycat(Player pPlayer, InteractionHand pHand, ItemStack pStack, CallbackInfo ci) {
        if (pStack.m_150930_(CCBlocks.COPYCAT_BLOCK.m_5456_())) {
            this.m_5496_(SoundEvents.f_12013_, 75.0f, 0.95f);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"mobInteract(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, cancellable=true)
    private void copycatInteract(Player pPlayer, InteractionHand pHand, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack stack = pPlayer.m_21120_(pHand);
        if (stack.m_150930_(CCBlocks.COPYCAT_BLOCK.m_5456_())) {
            CatVariant currentVariant = this.m_28554_();
            if (currentVariant.equals(CCCatVariants.COPY_CAT.m_203334_())) {
                return;
            }
            if (!this.m_9236_().m_5776_()) {
                this.setNaturalVariant(currentVariant);
                this.m_28464_((CatVariant)CCCatVariants.COPY_CAT.m_203334_());
                this.m_142075_(pPlayer, pHand, stack);
                this.m_21530_();
            }
            cir.setReturnValue((Object)InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_()));
        } else if (stack.m_204117_(AllTags.AllItemTags.WRENCH.tag)) {
            CatVariant currentVariant = this.m_28554_();
            if (!currentVariant.equals(CCCatVariants.COPY_CAT.m_203334_())) {
                return;
            }
            if (!this.m_9236_().m_5776_()) {
                this.m_28464_(this.getNaturalVariant());
                this.m_21530_();
                this.m_19998_((ItemLike)CCBlocks.COPYCAT_BLOCK.m_5456_());
                SoundType soundType = CCBlocks.COPYCAT_BLOCK.getDefaultState().m_60827_();
                this.m_5496_(soundType.m_56775_(), (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
            }
            cir.setReturnValue((Object)InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_()));
        }
    }
}

