/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.simibubi.create.api.contraption.storage.fluid.MountedFluidStorage;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorage;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class MountedStorageSyncPacket
extends SimplePacketBase {
    public final int contraptionId;
    public final Map<BlockPos, MountedItemStorage> items;
    public final Map<BlockPos, MountedFluidStorage> fluids;

    public MountedStorageSyncPacket(int contraptionId, Map<BlockPos, MountedItemStorage> items, Map<BlockPos, MountedFluidStorage> fluids) {
        this.contraptionId = contraptionId;
        this.items = items;
        this.fluids = fluids;
    }

    public MountedStorageSyncPacket(FriendlyByteBuf buf) {
        this.contraptionId = buf.m_130242_();
        this.items = MountedStorageSyncPacket.read(buf, MountedItemStorage.CODEC);
        this.fluids = MountedStorageSyncPacket.read(buf, MountedFluidStorage.CODEC);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.contraptionId);
        MountedStorageSyncPacket.write(buffer, this.items, MountedItemStorage.CODEC);
        MountedStorageSyncPacket.write(buffer, this.fluids, MountedFluidStorage.CODEC);
    }

    private static <T> void write(FriendlyByteBuf buf, Map<BlockPos, T> map, Codec<T> codec) {
        buf.m_236831_(map, FriendlyByteBuf::m_130064_, (b, t) -> b.m_266332_((DynamicOps)NbtOps.f_128958_, codec, t));
    }

    private static <T> Map<BlockPos, T> read(FriendlyByteBuf buf, Codec<T> codec) {
        return buf.m_236847_(FriendlyByteBuf::m_130135_, b -> b.m_266466_((DynamicOps)NbtOps.f_128958_, codec));
    }

    @Override
    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(this.contraptionId);
            if (!(entity instanceof AbstractContraptionEntity)) {
                return;
            }
            AbstractContraptionEntity contraption = (AbstractContraptionEntity)entity;
            contraption.getContraption().getStorage().handleSync(this, contraption);
        });
        return true;
    }
}

