/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.content.reactor.reactorrod;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.antarcticgardens.newage.NewAgeBlocks;
import org.antarcticgardens.newage.config.CommonConfig;
import org.antarcticgardens.newage.config.NewAgeConfig;
import org.antarcticgardens.newage.content.heat.HeatBlockEntity;
import org.antarcticgardens.newage.content.reactor.NuclearUtil;
import org.antarcticgardens.newage.content.reactor.reactorrod.ReactorRodBlock;
import org.jetbrains.annotations.Nullable;

public class ReactorRodBlockEntity
extends BlockEntity
implements HeatBlockEntity,
IHaveGoggleInformation {
    int twoSeconds = 0;
    private boolean working;
    public float heat = 0.0f;
    public int fuel = 0;

    public ReactorRodBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
        this.working = (Boolean)blockState.m_61143_((Property)ReactorRodBlock.ACTIVE);
    }

    public void tick(BlockPos pos, Level world, BlockState state) {
        CommonConfig common = NewAgeConfig.getCommon();
        double multiplier = (Double)common.overheatingMultiplier.get();
        if (multiplier > 0.0 && (double)this.heat > 16000.0 * multiplier) {
            this.heat = (float)((double)this.heat - (Double)common.nuclearReactorRodHeatLoss.get());
            this.m_6596_();
            HeatBlockEntity.handleOverheat(this, () -> world.m_7731_(pos, NewAgeBlocks.CORIUM.getDefaultState(), 3));
        }
        ++this.twoSeconds;
        if (this.twoSeconds > 40) {
            ReactorRodBlockEntity.transferAroundRodOnly(this);
            this.working = (Boolean)state.m_61143_((Property)ReactorRodBlock.ACTIVE);
            this.twoSeconds = 0;
            if (this.working) {
                NuclearUtil.createRadiation(8, world, pos);
            }
        }
        if (this.fuel > 0) {
            --this.fuel;
            if (!this.working) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)ReactorRodBlock.ACTIVE, (Comparable)Boolean.valueOf(true)), 3);
                this.working = true;
            }
            this.heat = (float)((double)this.heat + (Double)common.nuclearReactorRodHeat.get());
            this.m_6596_();
        } else if (this.working) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)ReactorRodBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
            this.working = false;
            this.m_6596_();
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        HeatBlockEntity.addToolTips(this, tooltip);
        return true;
    }

    static <T extends BlockEntity> void transferAroundRodOnly(T self) {
        if (self.m_58904_() == null) {
            return;
        }
        float totalToAverage = ((HeatBlockEntity)self).getHeat();
        int totalBlocks = 1;
        HeatBlockEntity[] setters = new HeatBlockEntity[6];
        for (int i = 0; i < 6; ++i) {
            ReactorRodBlockEntity hbe;
            Direction value = Direction.values()[i];
            BlockEntity entity = self.m_58904_().m_7702_(self.m_58899_().m_121945_(value));
            if (!(entity instanceof ReactorRodBlockEntity) || !(hbe = (ReactorRodBlockEntity)entity).canAdd(value)) continue;
            setters[i] = hbe;
            totalToAverage += hbe.getHeat();
            ++totalBlocks;
        }
        HeatBlockEntity.average(self, totalToAverage, totalBlocks, setters);
    }

    @Override
    public float maxHeat() {
        return 26000.0f;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.heat = tag.m_128457_("heat");
        this.fuel = tag.m_128451_("fuel");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128350_("heat", this.heat);
        tag.m_128405_("fuel", this.fuel);
    }

    @Override
    public float getHeat() {
        return this.heat;
    }

    @Override
    public void addHeat(float amount) {
        this.heat += amount;
        this.m_6596_();
    }

    @Override
    public void setHeat(float amount) {
        this.heat = amount;
        this.m_6596_();
    }
}

