/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.block_armor_properties;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import rbasamoyai.createbigcannons.base.BlockStatePredicateHelper;
import rbasamoyai.createbigcannons.block_armor_properties.BlockArmorPropertiesProvider;
import rbasamoyai.createbigcannons.block_armor_properties.SimpleBlockArmorProperties;

public record VariantBlockArmorProperties(SimpleBlockArmorProperties defaultProperties, Map<BlockState, SimpleBlockArmorProperties> propertiesByState) implements BlockArmorPropertiesProvider
{
    @Override
    public double hardness(Level level, BlockState state, BlockPos pos, boolean recurse) {
        return this.propertiesByState.getOrDefault(state, this.defaultProperties).hardness(level, state, pos, recurse);
    }

    @Override
    public double toughness(Level level, BlockState state, BlockPos pos, boolean recurse) {
        return this.propertiesByState.getOrDefault(state, this.defaultProperties).toughness(level, state, pos, recurse);
    }

    @Override
    public List<BlockState> containedBlockStates(Level level, BlockState state, BlockPos pos, boolean recurse) {
        return List.of(state);
    }

    public static VariantBlockArmorProperties fromJson(Block block, JsonObject obj) {
        StateDefinition definition = block.m_49965_();
        HashSet states = new HashSet(definition.m_61056_());
        Reference2ObjectOpenHashMap propertiesByState = new Reference2ObjectOpenHashMap();
        if (obj.has("variants") && obj.get("variants").isJsonObject()) {
            JsonObject variants = obj.getAsJsonObject("variants");
            for (String key : variants.keySet()) {
                Predicate<BlockState> pred = BlockStatePredicateHelper.variantPredicate((StateDefinition<Block, BlockState>)definition, key);
                JsonElement el = variants.get(key);
                if (!el.isJsonObject()) {
                    throw new JsonSyntaxException("Invalid info for variant '" + key + "''");
                }
                JsonObject variantInfo = el.getAsJsonObject();
                SimpleBlockArmorProperties properties = SimpleBlockArmorProperties.fromJson(variantInfo);
                Iterator stateIter = states.iterator();
                while (stateIter.hasNext()) {
                    BlockState state = (BlockState)stateIter.next();
                    if (!pred.test(state)) continue;
                    propertiesByState.put(state, properties);
                    stateIter.remove();
                }
            }
        }
        SimpleBlockArmorProperties defaultProperties = SimpleBlockArmorProperties.fromJson(obj);
        return new VariantBlockArmorProperties(defaultProperties, (Map<BlockState, SimpleBlockArmorProperties>)propertiesByState);
    }

    public void toNetwork(FriendlyByteBuf buf) {
        this.defaultProperties.toNetwork(buf);
        buf.m_130130_(this.propertiesByState.size());
        for (Map.Entry<BlockState, SimpleBlockArmorProperties> entry : this.propertiesByState.entrySet()) {
            buf.m_130130_(Block.m_49956_((BlockState)entry.getKey()));
            entry.getValue().toNetwork(buf);
        }
    }

    public static VariantBlockArmorProperties fromNetwork(FriendlyByteBuf buf) {
        SimpleBlockArmorProperties defaultProperties = SimpleBlockArmorProperties.fromNetwork(buf);
        int sz = buf.m_130242_();
        Reference2ObjectOpenHashMap propertiesByState = new Reference2ObjectOpenHashMap();
        for (int i = 0; i < sz; ++i) {
            BlockState state = Block.m_49803_((int)buf.m_130242_());
            SimpleBlockArmorProperties properties = SimpleBlockArmorProperties.fromNetwork(buf);
            propertiesByState.put(state, properties);
        }
        return new VariantBlockArmorProperties(defaultProperties, (Map<BlockState, SimpleBlockArmorProperties>)propertiesByState);
    }
}

