/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.crafting.casting;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import rbasamoyai.createbigcannons.base.CBCRegistries;
import rbasamoyai.createbigcannons.crafting.casting.CannonCastShape;
import rbasamoyai.createbigcannons.utils.CBCUtils;

public class FinishedCannonCastBlockEntity
extends SmartBlockEntity {
    private CannonCastShape renderedShape = CannonCastShape.VERY_SMALL;
    private BlockPos centralBlock;
    private BlockPos rootBlock;
    private int height;

    public FinishedCannonCastBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void setCentralBlock(BlockPos pos) {
        this.centralBlock = pos;
    }

    public boolean isCentralBlock() {
        return this.centralBlock == null;
    }

    public void setRootBlock(BlockPos pos) {
        this.rootBlock = pos;
    }

    public BlockPos getRootBlock() {
        return this.rootBlock == null ? this.f_58858_ : this.rootBlock;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setRenderedShape(CannonCastShape shape) {
        this.renderedShape = shape;
    }

    public CannonCastShape getRenderedShape() {
        return this.renderedShape;
    }

    public void initialize() {
        super.initialize();
        this.sendData();
        if (this.m_58904_().f_46443_) {
            this.invalidateRenderBoundingBox();
        }
    }

    protected AABB createRenderBoundingBox() {
        return this.isCentralBlock() ? new AABB(this.getRootBlock()).m_82363_(2.0, (double)(this.height - 1), 2.0) : super.createRenderBoundingBox();
    }

    public void removeCast() {
        this.m_7651_();
        if (this.isCentralBlock()) {
            this.m_58904_().m_5594_(null, this.f_58858_.m_7918_(1, 0, 1), this.m_58900_().m_60827_().m_56775_(), SoundSource.BLOCKS, 1.0f, 1.0f);
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)this.f_58858_, (BlockPos)this.f_58858_.m_7918_(2, 0, 2))) {
                BlockPos posI = pos.m_7949_();
                if (posI.equals((Object)this.f_58858_.m_7918_(1, 0, 1))) continue;
                this.m_58904_().m_7731_(posI, Blocks.f_50016_.m_49966_(), 11);
            }
        } else {
            FinishedCannonCastBlockEntity cast;
            BlockEntity blockEntity = this.m_58904_().m_7702_(this.centralBlock);
            if (blockEntity instanceof FinishedCannonCastBlockEntity && (cast = (FinishedCannonCastBlockEntity)blockEntity).isCentralBlock()) {
                cast.removeCast();
            }
        }
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (this.isCentralBlock()) {
            tag.m_128365_("RootBlock", (Tag)NbtUtils.m_129224_((BlockPos)this.getRootBlock()));
            tag.m_128405_("Height", this.height);
            tag.m_128359_("RenderedShape", CBCRegistries.cannonCastShapes().m_7981_((Object)this.renderedShape).toString());
        } else {
            tag.m_128365_("CentralBlock", (Tag)NbtUtils.m_129224_((BlockPos)this.centralBlock));
        }
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.centralBlock = tag.m_128441_("CentralBlock") ? NbtUtils.m_129239_((CompoundTag)tag.m_128469_("CentralBlock")) : null;
        this.rootBlock = tag.m_128441_("RootBlock") ? NbtUtils.m_129239_((CompoundTag)tag.m_128469_("RootBlock")) : this.f_58858_;
        this.height = tag.m_128451_("Height");
        this.renderedShape = tag.m_128441_("RenderedShape") ? (CannonCastShape)CBCRegistries.cannonCastShapes().m_7745_(CBCUtils.location(tag.m_128461_("RenderedShape"))) : CannonCastShape.VERY_SMALL;
    }
}

