/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.forge.mixin;

import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.OrientedContraptionEntity;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.spongepowered.asm.mixin.Mixin;
import rbasamoyai.createbigcannons.cannon_control.contraption.PitchOrientedContraptionEntity;
import rbasamoyai.createbigcannons.forge.mixin_interface.GetItemStorage;

@Mixin(value={PitchOrientedContraptionEntity.class})
public class PitchOrientedContraptionEntityMixin
extends OrientedContraptionEntity {
    private LazyOptional<IItemHandler> itemOptional;

    PitchOrientedContraptionEntityMixin(EntityType<?> type, Level level) {
        super(type, level);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (this.itemOptional == null) {
                LazyOptional<IItemHandler> lazyOptional;
                Contraption contraption = this.contraption;
                if (contraption instanceof GetItemStorage) {
                    GetItemStorage storage = (GetItemStorage)contraption;
                    lazyOptional = storage.getItemStorage();
                } else {
                    lazyOptional = LazyOptional.empty();
                }
                this.itemOptional = lazyOptional;
            }
            return this.itemOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemOptional != null) {
            this.itemOptional.invalidate();
        }
    }
}

