/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entities.projectiles;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.network.packet.EntityPacket;
import mod.azure.azurelib.util.AzureLibUtil;
import mod.azure.doom.MCDoom;
import mod.azure.doom.entities.DemonEntity;
import mod.azure.doom.entities.tierambient.GoreNestEntity;
import mod.azure.doom.entities.tierboss.ArchMakyrEntity;
import mod.azure.doom.entities.tierboss.GladiatorEntity;
import mod.azure.doom.entities.tierboss.IconofsinEntity;
import mod.azure.doom.entities.tierboss.MotherDemonEntity;
import mod.azure.doom.helper.CommonUtils;
import mod.azure.doom.platform.Services;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BFGEntity
extends AbstractArrow
implements GeoEntity {
    private static final EntityDataAccessor<Integer> TARGET_ENTITY = SynchedEntityData.m_135353_(BFGEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    Random rand = new Random();
    List<String> whitelistEntries;
    int randomIndex;
    ResourceLocation randomElement1;
    EntityType<?> randomElement;
    private int idleTicks;
    private LivingEntity cachedBeamTarget;

    public BFGEntity(EntityType<? extends BFGEntity> entityType, Level world) {
        super(entityType, world);
        this.whitelistEntries = Arrays.asList(MCDoom.config.bfg_damage_mob_whitelist);
        this.randomIndex = this.rand.nextInt(this.whitelistEntries.size());
        this.randomElement1 = new ResourceLocation(this.whitelistEntries.get(this.randomIndex));
        this.randomElement = (EntityType)BuiltInRegistries.f_256780_.m_7745_(this.randomElement1);
        this.idleTicks = 0;
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
    }

    public BFGEntity(Level world, LivingEntity owner) {
        super(Services.ENTITIES_HELPER.getBFGEtntity(), owner, world);
        this.whitelistEntries = Arrays.asList(MCDoom.config.bfg_damage_mob_whitelist);
        this.randomIndex = this.rand.nextInt(this.whitelistEntries.size());
        this.randomElement1 = new ResourceLocation(this.whitelistEntries.get(this.randomIndex));
        this.randomElement = (EntityType)BuiltInRegistries.f_256780_.m_7745_(this.randomElement1);
        this.idleTicks = 0;
        this.m_5602_((Entity)owner);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, event -> event.setAndContinue(RawAnimation.begin().thenLoop("idle")))});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return EntityPacket.createPacket((Entity)this);
    }

    protected void m_6901_() {
        if (this.f_19797_ >= 120) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    protected void m_7761_(@NotNull LivingEntity living) {
        super.m_7761_(living);
        if (!(living instanceof Player) && !(living instanceof IconofsinEntity)) {
            living.m_20334_(0.0, 0.0, 0.0);
            living.f_19802_ = 0;
        }
    }

    public void m_8119_() {
        int idleOpt = 100;
        this.idleTicks = this.m_20184_().m_82556_() < 0.01 ? ++this.idleTicks : 0;
        if (this.idleTicks < idleOpt) {
            super.m_8119_();
        }
        boolean isInsideWaterBlock = this.m_9236_().m_46801_(this.m_20183_());
        CommonUtils.spawnLightSource((Entity)this, isInsideWaterBlock);
        if (this.f_19797_ >= 80) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        CommonUtils.setOnFire((Projectile)this);
        this.m_9236_().m_45976_(LivingEntity.class, new AABB(this.m_20183_().m_7494_()).m_82377_(24.0, 24.0, 24.0)).forEach(e -> {
            Entity listEntity = this.randomElement.m_141992_((Entity)e);
            if (!(e instanceof Player) && !(e instanceof EnderDragon) && !(e instanceof GoreNestEntity) && !(e instanceof IconofsinEntity) && !(e instanceof ArchMakyrEntity) && !(e instanceof GladiatorEntity) && !(e instanceof MotherDemonEntity) && (e instanceof Monster || e instanceof Slime || e instanceof Phantom || e instanceof DemonEntity || e instanceof Shulker || e instanceof Hoglin || e == listEntity) && e.m_6084_()) {
                e.m_6469_(this.m_269291_().m_269036_((Entity)this, this.m_19749_()), MCDoom.config.bfgball_damage_aoe);
                this.setTargetedEntity(e.m_19879_());
            }
            if (e instanceof EnderDragon) {
                EnderDragon enderDragon = (EnderDragon)e;
                if (e.m_6084_()) {
                    enderDragon.f_31080_.m_6469_(this.m_269291_().m_269075_((Player)this.m_19749_()), MCDoom.config.bfgball_damage_dragon * 0.3f);
                    this.setTargetedEntity(e.m_19879_());
                }
            }
            if (e instanceof IconofsinEntity || e instanceof ArchMakyrEntity || e instanceof GladiatorEntity || e instanceof MotherDemonEntity && e.m_6084_()) {
                e.m_6469_(this.m_269291_().m_269075_((Player)this.m_19749_()), MCDoom.config.bfgball_damage_aoe * 0.1f);
            }
        });
    }

    @NotNull
    public ItemStack m_7941_() {
        return Items.f_41852_.m_7968_();
    }

    public boolean m_20068_() {
        return !this.m_20069_();
    }

    protected void m_8060_(@NotNull BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        if (!this.m_9236_().m_5776_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void m_5790_(@NotNull EntityHitResult entityHitResult) {
        if (!this.m_9236_().f_46443_) {
            this.doDamage();
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20227_(0.0625), this.m_20189_(), 1.0f, MCDoom.config.enable_block_breaking ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        this.m_5496_(Services.SOUNDS_HELPER.getBFG_HIT(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
    }

    public void doDamage() {
        this.m_9236_().m_45976_(LivingEntity.class, new AABB(this.m_20183_().m_7494_()).m_82377_(24.0, 24.0, 24.0)).forEach(e -> {
            Entity listEntity = this.randomElement.m_141992_((Entity)e);
            if (!(e instanceof Player || e instanceof EnderDragon || e instanceof GoreNestEntity || e instanceof IconofsinEntity || e instanceof ArchMakyrEntity || e instanceof GladiatorEntity || e instanceof MotherDemonEntity || !(e instanceof Monster) && !(e instanceof Slime) && !(e instanceof Phantom) && !(e instanceof DemonEntity) && !(e instanceof Shulker) && !(e instanceof Hoglin) && e != listEntity)) {
                if (this.m_6060_()) {
                    e.m_20254_(50);
                }
                e.m_6469_(this.m_269291_().m_269075_((Player)this.m_19749_()), MCDoom.config.bfgball_damage);
                this.setTargetedEntity(e.m_19879_());
                if (!this.m_9236_().f_46443_) {
                    List list1 = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(4.0, 2.0, 4.0));
                    AreaEffectCloud areaEffectCloud = new AreaEffectCloud(e.m_9236_(), e.m_20185_(), e.m_20186_(), e.m_20189_());
                    areaEffectCloud.m_19724_((ParticleOptions)ParticleTypes.f_123767_);
                    areaEffectCloud.m_19712_(3.0f);
                    areaEffectCloud.m_19734_(10);
                    if (!list1.isEmpty()) {
                        for (LivingEntity livingentity : list1) {
                            double d0 = this.m_20280_((Entity)livingentity);
                            if (!(d0 < 16.0)) continue;
                            areaEffectCloud.m_6034_(e.m_20185_(), e.m_20188_(), e.m_20189_());
                        }
                    }
                    e.m_9236_().m_7967_((Entity)areaEffectCloud);
                }
            }
            if (e instanceof EnderDragon) {
                EnderDragon enderDragon = (EnderDragon)e;
                if (e.m_6084_()) {
                    enderDragon.f_31080_.m_6469_(this.m_269291_().m_269075_((Player)this.m_19749_()), MCDoom.config.bfgball_damage_dragon * 0.3f);
                }
            }
            if (e instanceof IconofsinEntity || e instanceof ArchMakyrEntity || e instanceof GladiatorEntity || e instanceof MotherDemonEntity && e.m_6084_()) {
                if (this.m_6060_()) {
                    e.m_20254_(50);
                }
                e.m_6469_(this.m_269291_().m_269075_((Player)this.m_19749_()), MCDoom.config.bfgball_damage * 0.1f);
            }
        });
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TARGET_ENTITY, (Object)0);
    }

    public boolean hasTargetedEntity() {
        return (Integer)this.f_19804_.m_135370_(TARGET_ENTITY) != 0;
    }

    @Nullable
    public LivingEntity getTargetedEntity() {
        if (!this.hasTargetedEntity()) {
            return null;
        }
        if (this.m_9236_().f_46443_) {
            if (this.cachedBeamTarget != null) {
                return this.cachedBeamTarget;
            }
            Entity entity = this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(TARGET_ENTITY)).intValue());
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity;
                this.cachedBeamTarget = livingEntity = (LivingEntity)entity;
                return this.cachedBeamTarget;
            }
            return null;
        }
        return this.getTarget();
    }

    private void setTargetedEntity(int entityId) {
        this.f_19804_.m_135381_(TARGET_ENTITY, (Object)entityId);
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (TARGET_ENTITY.equals(key)) {
            this.cachedBeamTarget = null;
        }
    }

    @Nullable
    public LivingEntity getTarget() {
        return this.cachedBeamTarget;
    }

    public boolean m_6051_() {
        return false;
    }
}

