/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entities.projectiles;

import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.network.packet.EntityPacket;
import mod.azure.azurelib.util.AzureLibUtil;
import mod.azure.doom.MCDoom;
import mod.azure.doom.entities.tierheavy.CacodemonEntity;
import mod.azure.doom.platform.Services;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class GrenadeEntity
extends AbstractArrow
implements GeoEntity {
    private static final EntityDataAccessor<Boolean> SPINNING = SynchedEntityData.m_135353_(GrenadeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    protected String type;
    private LivingEntity shooter;

    public GrenadeEntity(EntityType<? extends GrenadeEntity> entityType, Level world) {
        super(entityType, world);
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
    }

    public GrenadeEntity(Level world, LivingEntity owner) {
        super(Services.ENTITIES_HELPER.getGranadeEntity(), owner, world);
        this.shooter = owner;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, event -> {
            if (this.f_36704_ == 0) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("spin"));
            }
            return PlayState.STOP;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPINNING, (Object)false);
    }

    public boolean isSpinning() {
        return (Boolean)this.f_19804_.m_135370_(SPINNING);
    }

    public void setSpinning(boolean spin) {
        this.f_19804_.m_135381_(SPINNING, (Object)spin);
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return EntityPacket.createPacket((Entity)this);
    }

    public void m_142687_(@NotNull Entity.RemovalReason reason) {
        AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
        areaeffectcloudentity.m_19724_((ParticleOptions)ParticleTypes.f_123744_);
        areaeffectcloudentity.m_19712_(6.0f);
        areaeffectcloudentity.m_19734_(1);
        areaeffectcloudentity.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_9236_().m_7967_((Entity)areaeffectcloudentity);
        this.explode();
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.5f);
        super.m_142687_(reason);
    }

    protected void m_6901_() {
        if (this.f_19797_ >= 40) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("State", this.isSpinning());
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.setSpinning(compound.m_128471_("State"));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_20184_().f_82479_ == 0.0) {
            this.setSpinning(false);
        }
        if (!this.m_20096_()) {
            this.setSpinning(true);
        }
        if (this.f_19797_ >= 46 && !this.m_9236_().m_5776_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void m_36740_(@NotNull SoundEvent soundIn) {
        this.m_7239_();
    }

    @NotNull
    protected SoundEvent m_7239_() {
        return Services.SOUNDS_HELPER.getBEEP();
    }

    protected void m_8060_(@NotNull BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        if (!this.m_9236_().m_5776_() && this.f_19797_ >= 46) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        Entity entity = entityHitResult.m_82443_();
        if (!this.m_9236_().m_5776_()) {
            if (entity instanceof CacodemonEntity) {
                entity.m_6469_(this.m_269291_().m_269075_((Player)this.shooter), ((LivingEntity)entity).m_21233_());
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            } else {
                super.m_5790_(entityHitResult);
                this.explode();
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    protected void explode() {
        this.m_9236_().m_45933_((Entity)this, new AABB(this.m_20183_().m_7494_()).m_82400_(8.0)).forEach(this::doDamage);
    }

    private void doDamage(Entity target) {
        if (target instanceof LivingEntity) {
            target.f_19802_ = 0;
            if (this.m_6060_()) {
                target.m_20254_(50);
            }
            target.m_6469_(this.m_269291_().m_269104_((Entity)this, target), MCDoom.config.grenade_damage);
            target.m_20256_(target.m_20184_().m_82520_(1.0, 0.6, 1.0));
        }
    }

    @NotNull
    public ItemStack m_7941_() {
        return new ItemStack((ItemLike)Items.f_41852_);
    }

    public boolean m_6051_() {
        return false;
    }
}

