/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entities.projectiles.entity;

import mod.azure.azurelib.network.packet.EntityPacket;
import mod.azure.doom.MCDoom;
import mod.azure.doom.entities.DemonEntity;
import mod.azure.doom.platform.Services;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class DroneBoltEntity
extends AbstractHurtingProjectile {
    private float directHitDamage = 2.0f;

    public DroneBoltEntity(EntityType<DroneBoltEntity> entity, Level level) {
        super(entity, level);
    }

    public DroneBoltEntity(Level worldIn, LivingEntity shooter, double accelX, double accelY, double accelZ, float directHitDamage) {
        super(Services.ENTITIES_HELPER.getDroneBoltEntity(), shooter, accelX, accelY, accelZ, worldIn);
        this.directHitDamage = directHitDamage;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return EntityPacket.createPacket((Entity)this);
    }

    public boolean m_20068_() {
        return !this.m_20069_();
    }

    protected void m_8060_(@NotNull BlockHitResult result) {
        super.m_8060_(result);
        if (!this.m_9236_().m_5776_()) {
            this.explode();
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        this.m_5496_(Services.SOUNDS_HELPER.getROCKET_HIT(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
    }

    protected void explode() {
        this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20227_(0.0625), this.m_20189_(), 1.0f, false, MCDoom.config.enable_block_breaking ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE);
    }

    protected void m_5790_(@NotNull EntityHitResult entityHitResult) {
        super.m_5790_(entityHitResult);
        if (!this.m_9236_().m_5776_()) {
            LivingEntity livingEntity;
            Entity entity = entityHitResult.m_82443_();
            Entity entity2 = this.m_19749_();
            if (entity instanceof LivingEntity) {
                livingEntity = (LivingEntity)entity;
                if (!(entity instanceof DemonEntity)) {
                    livingEntity.m_6469_(this.m_269291_().m_269299_((Entity)this, livingEntity), this.directHitDamage);
                }
            }
            if (entity2 instanceof LivingEntity) {
                livingEntity = (LivingEntity)entity2;
                if (!(entity instanceof DemonEntity)) {
                    this.m_19970_(livingEntity, entity);
                }
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
        this.m_5496_(Services.SOUNDS_HELPER.getUNMAKYR_FIRE(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ >= 80) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public boolean m_6051_() {
        return false;
    }
}

