/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.helper;

import mod.azure.azurelib.entities.TickingLightEntity;
import mod.azure.azurelib.platform.Services;
import mod.azure.doom.MCDoom;
import mod.azure.doom.entities.projectiles.BFGEntity;
import mod.azure.doom.entities.projectiles.BulletEntity;
import mod.azure.doom.entities.projectiles.RocketEntity;
import mod.azure.doom.items.weapons.BaseSwordItem;
import mod.azure.doom.items.weapons.DoomBaseItem;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class CommonUtils {
    private CommonUtils() {
    }

    public static void removeAmmo(Item ammo, Player playerEntity) {
        if ((playerEntity.m_21120_(playerEntity.m_7655_()).m_41720_() instanceof DoomBaseItem || playerEntity.m_21120_(playerEntity.m_7655_()).m_41720_() instanceof BaseSwordItem) && !playerEntity.m_7500_()) {
            block0: for (ItemStack item : playerEntity.m_150109_().f_35976_) {
                if (item.m_41720_() == ammo) {
                    item.m_41774_(1);
                    break;
                }
                for (ItemStack item1 : playerEntity.m_150109_().f_35974_) {
                    if (item1.m_41720_() != ammo) continue;
                    item1.m_41774_(1);
                    continue block0;
                }
            }
        }
    }

    public static void spawnLightSource(Entity entity, boolean isInWaterBlock) {
        BlockEntity blockEntity;
        BlockPos lightBlockPos = null;
        if (lightBlockPos == null) {
            lightBlockPos = CommonUtils.findFreeSpace(entity.m_9236_(), entity.m_20183_());
            if (lightBlockPos == null) {
                return;
            }
            entity.m_9236_().m_46597_(lightBlockPos, Services.PLATFORM.getTickingLightBlock().m_49966_());
        } else if (CommonUtils.checkDistance(lightBlockPos, entity.m_20183_()) && (blockEntity = entity.m_9236_().m_7702_(lightBlockPos)) instanceof TickingLightEntity) {
            TickingLightEntity tickingLightEntity = (TickingLightEntity)blockEntity;
            tickingLightEntity.refresh(isInWaterBlock ? 20 : 0);
        }
    }

    private static boolean checkDistance(BlockPos blockPosA, BlockPos blockPosB) {
        return Math.abs(blockPosA.m_123341_() - blockPosB.m_123341_()) <= 2 && Math.abs(blockPosA.m_123342_() - blockPosB.m_123342_()) <= 2 && Math.abs(blockPosA.m_123343_() - blockPosB.m_123343_()) <= 2;
    }

    private static BlockPos findFreeSpace(Level world, BlockPos blockPos) {
        if (blockPos == null) {
            return null;
        }
        int[] offsets = new int[5];
        offsets[0] = 0;
        for (int i = 2; i <= 4; i += 2) {
            offsets[i - 1] = i / 2;
            offsets[i] = -i / 2;
        }
        for (int x : offsets) {
            for (int y : offsets) {
                for (int z : offsets) {
                    BlockPos offsetPos = blockPos.m_7918_(x, y, z);
                    BlockState state = world.m_8055_(offsetPos);
                    if (!state.m_60795_() && !state.m_60734_().equals(Services.PLATFORM.getTickingLightBlock())) continue;
                    return offsetPos;
                }
            }
        }
        return null;
    }

    public static BulletEntity createBullet(Level worldIn, ItemStack stack, LivingEntity shooter, float damage) {
        int enchantment = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack);
        return new BulletEntity(worldIn, shooter, damage + (float)enchantment * 2.0f){};
    }

    public static RocketEntity createRocket(Level worldIn, ItemStack stack, LivingEntity shooter) {
        int enchantlevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack);
        return new RocketEntity(worldIn, shooter, MCDoom.config.rocket_damage + (float)enchantlevel * 2.0f){};
    }

    public static BFGEntity createBFG(Level worldIn, LivingEntity shooter) {
        return new BFGEntity(worldIn, shooter){};
    }

    public static boolean isUsable(ItemStack stack) {
        return stack.m_41773_() < stack.m_41776_() - 1;
    }

    public static boolean nonCentered() {
        return MCDoom.config.enable_noncenter;
    }

    public static void setOnFire(Projectile projectile) {
        if (projectile.m_6060_()) {
            projectile.m_9236_().m_45976_(LivingEntity.class, projectile.m_20191_().m_82400_(2.0)).forEach(e -> {
                if (e.m_6084_() && !(e instanceof Player)) {
                    e.m_7311_(90);
                }
            });
        }
    }
}

