/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.items.armor;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mod.azure.azurelib.animatable.GeoItem;
import mod.azure.azurelib.animatable.client.RenderProvider;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.util.AzureLibUtil;
import mod.azure.doom.client.render.armors.DoomRender;
import mod.azure.doom.items.enums.ArmorTypeEnum;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public abstract class DoomArmor
extends ArmorItem
implements GeoItem {
    protected final ArmorTypeEnum armorTypeEnum;
    private final Supplier<Object> renderProvider = GeoItem.makeRenderer((GeoItem)this);
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);

    protected DoomArmor(ArmorMaterial materialIn, ArmorItem.Type slot, ArmorTypeEnum armorTypeEnum) {
        super(materialIn, slot, new Item.Properties().m_41487_(1));
        this.armorTypeEnum = armorTypeEnum;
    }

    public ArmorTypeEnum getArmorTypeEnum() {
        return this.armorTypeEnum;
    }

    public void createRenderer(Consumer<Object> consumer) {
        consumer.accept(new RenderProvider(){
            private DoomRender<?> renderer;

            public HumanoidModel<LivingEntity> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<LivingEntity> original) {
                if (this.renderer == null) {
                    this.renderer = new DoomRender(DoomArmor.this.getArmorTypeEnum());
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public Supplier<Object> getRenderProvider() {
        return this.renderProvider;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, 20, state -> state.setAndContinue(RawAnimation.begin().thenLoop("idle")))});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_7373_(@NotNull ItemStack itemStack, Level level, @NotNull List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        switch (this.getArmorTypeEnum()) {
            case ASTRO: {
                list.add((Component)Component.m_237115_((String)"doom.astroarmor.text").m_130940_(ChatFormatting.YELLOW).m_130940_(ChatFormatting.ITALIC));
                break;
            }
            case CLASSIC_GREEN: 
            case CLASSIC_INDIGO: 
            case CLASSIC_BRONZE: 
            case CLASSIC_RED: {
                list.add((Component)Component.m_237115_((String)"doom.classicarmor.text").m_130940_(ChatFormatting.YELLOW).m_130940_(ChatFormatting.ITALIC));
                break;
            }
            case CRIMSON: {
                list.add((Component)Component.m_237115_((String)"doom.crimsonarmor.text").m_130940_(ChatFormatting.YELLOW).m_130940_(ChatFormatting.ITALIC));
                break;
            }
            case CULTIST: {
                list.add((Component)Component.m_237115_((String)"doom.cultistarmor.text").m_130940_(ChatFormatting.YELLOW).m_130940_(ChatFormatting.ITALIC));
                break;
            }
            case DARK_LORD: {
                list.add((Component)Component.m_237115_((String)"doom.darklordarmor.text").m_130940_(ChatFormatting.YELLOW).m_130940_(ChatFormatting.ITALIC));
                break;
            }
            case DEMONIC: 
            case DEMONCIDE: {
                list.add((Component)Component.m_237115_((String)"doom.demonicarmor.text").m_130940_(ChatFormatting.YELLOW).m_130940_(ChatFormatting.ITALIC));
                break;
            }
            case BRONZE: 
            case DOOM: 
            case HOTROD: 
            case TWENTYFIVE: {
                list.add((Component)Component.m_237115_((String)"doom.doomarmor.text").m_130940_(ChatFormatting.YELLOW).m_130940_(ChatFormatting.ITALIC));
                break;
            }
            case DOOMICORN: 
            case NIGHTMARE: 
            case PURPLE_PONY: {
                list.add((Component)Component.m_237115_((String)"doom.doomicornarmor.text").m_130940_(ChatFormatting.YELLOW).m_130940_(ChatFormatting.ITALIC));
                break;
            }
            case EMBER: {
                list.add((Component)Component.m_237115_((String)"doom.emberarmor.text").m_130940_(ChatFormatting.YELLOW).m_130940_(ChatFormatting.ITALIC));
                break;
            }
            case GOLD: {
                list.add((Component)Component.m_237115_((String)"doom.goldarmor.text").m_130940_(ChatFormatting.YELLOW).m_130940_(ChatFormatting.ITALIC));
                break;
            }
            case MAYKR: {
                list.add((Component)Component.m_237115_((String)"doom.makyrarmor.text").m_130940_(ChatFormatting.YELLOW).m_130940_(ChatFormatting.ITALIC));
                break;
            }
            case MIDNIGHT: {
                list.add((Component)Component.m_237115_((String)"doom.midnightarmor.text").m_130940_(ChatFormatting.YELLOW).m_130940_(ChatFormatting.ITALIC));
                break;
            }
            case MULLET1: 
            case MULLET2: 
            case MULLET3: {
                list.add((Component)Component.m_237115_((String)"doom.mulletarmor.text").m_130940_(ChatFormatting.YELLOW).m_130940_(ChatFormatting.ITALIC));
                break;
            }
            case PAINTER: {
                list.add((Component)Component.m_237115_((String)"doom.painterarmor.text").m_130940_(ChatFormatting.YELLOW).m_130940_(ChatFormatting.ITALIC));
                break;
            }
            case PHOBOS: {
                list.add((Component)Component.m_237115_((String)"doom.phobosarmor.text").m_130940_(ChatFormatting.YELLOW).m_130940_(ChatFormatting.ITALIC));
                break;
            }
            case PRAETOR: {
                list.add((Component)Component.m_237115_((String)"doom.praetorarmor.text").m_130940_(ChatFormatting.YELLOW).m_130940_(ChatFormatting.ITALIC));
                break;
            }
            case SANTA: {
                list.add((Component)Component.m_237115_((String)"doom.santadoomarmor.text").m_130940_(ChatFormatting.YELLOW).m_130940_(ChatFormatting.ITALIC));
                break;
            }
            case SENTINEL: {
                list.add((Component)Component.m_237115_((String)"doom.sentinelarmor.text").m_130940_(ChatFormatting.YELLOW).m_130940_(ChatFormatting.ITALIC));
                break;
            }
            case ZOMBIE: {
                list.add((Component)Component.m_237115_((String)"doom.zombiearmor.text").m_130940_(ChatFormatting.YELLOW).m_130940_(ChatFormatting.ITALIC));
            }
        }
        super.m_7373_(itemStack, level, list, tooltipFlag);
    }
}

