/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.items.powerup;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.azure.doom.MCDoom;
import mod.azure.doom.registry.NeoDoomItems;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class DaisyItem
extends Item {
    public DaisyItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public static boolean isRingInCuriosSlot(ItemStack belt, LivingEntity player) {
        return CuriosApi.getCurio((ItemStack)belt).isPresent();
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"doom.daisy1.text").m_130940_(ChatFormatting.YELLOW).m_130940_(ChatFormatting.ITALIC));
        tooltip.add((Component)Component.m_237115_((String)"doom.daisy2.text").m_130940_(ChatFormatting.ITALIC));
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag unused) {
        final ICurio curio = new ICurio(){

            public boolean canEquipFromUse(SlotContext slotContext) {
                return true;
            }

            public void onEquip(SlotContext slotContext, ItemStack prevStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (MCDoom.config.enable_daisy_effects) {
                        this.startPowers(player);
                    }
                }
            }

            public void onUnequip(SlotContext slotContext, ItemStack prevStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (MCDoom.config.enable_daisy_effects) {
                        this.stopPowers(player);
                    }
                }
            }

            private void startPowers(Player player) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 10000000, 2));
            }

            private void stopPowers(Player player) {
                player.m_21195_(MobEffects.f_19596_);
            }

            public void curioTick(SlotContext slotContext) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    this.startPowers(player);
                }
            }

            public boolean canEquip(SlotContext slotContext) {
                return !CuriosApi.getCuriosHelper().findFirstCurio(slotContext.entity(), (Item)NeoDoomItems.DAISY.get()).isPresent();
            }

            public ItemStack getStack() {
                return new ItemStack((ItemLike)NeoDoomItems.DAISY.get());
            }
        };
        return new ICapabilityProvider(){
            private final LazyOptional<ICurio> curioOpt = LazyOptional.of(() -> curio);

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return CuriosCapability.ITEM.orEmpty(cap, this.curioOpt);
            }
        };
    }
}

