/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.items.tools;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import mod.azure.doom.registry.DoomTags;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class ArgentPaxel
extends DiggerItem {
    private static final Set<ToolAction> PAXEL_ACTIONS = Stream.of(ToolActions.PICKAXE_DIG, ToolActions.AXE_DIG, ToolActions.AXE_STRIP, ToolActions.AXE_SCRAPE, ToolActions.AXE_WAX_OFF, ToolActions.SHOVEL_DIG, ToolActions.SHOVEL_FLATTEN).collect(Collectors.toCollection(Sets::newIdentityHashSet));

    public ArgentPaxel(Tier tier) {
        super(8.0f, -2.4f, tier, DoomTags.PAXEL_BLOCKS, new Item.Properties().m_41487_(1));
    }

    public float m_8102_(@Nonnull ItemStack stack, BlockState state) {
        return 30.0f;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return state.m_204336_(BlockTags.f_144282_) || state.m_204336_(BlockTags.f_144280_) || state.m_204336_(BlockTags.f_144283_);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return PAXEL_ACTIONS.contains(toolAction);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        Player player = context.m_43723_();
        BlockState blockstate = level.m_8055_(blockpos);
        Optional<BlockState> optional = Optional.ofNullable(blockstate.getToolModifiedState(context, ToolActions.AXE_STRIP, false));
        Optional<BlockState> optional1 = Optional.ofNullable(blockstate.getToolModifiedState(context, ToolActions.AXE_SCRAPE, false));
        Optional<BlockState> optional2 = Optional.ofNullable(blockstate.getToolModifiedState(context, ToolActions.AXE_WAX_OFF, false));
        BlockState optional3 = blockstate.getToolModifiedState(context, ToolActions.SHOVEL_FLATTEN, false);
        ItemStack itemstack = context.m_43722_();
        Optional<Object> optional4 = Optional.empty();
        if (optional.isPresent()) {
            level.m_5594_(player, blockpos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            optional4 = optional;
        } else if (optional1.isPresent()) {
            level.m_5594_(player, blockpos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5898_(player, 3005, blockpos, 0);
            optional4 = optional1;
        } else if (optional2.isPresent()) {
            level.m_5594_(player, blockpos, SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5898_(player, 3004, blockpos, 0);
            optional4 = optional2;
        } else if (optional3 != null && level.m_46859_(blockpos.m_7494_())) {
            level.m_5594_(player, blockpos, SoundEvents.f_12406_, SoundSource.BLOCKS, 1.0f, 1.0f);
            optional4 = Optional.ofNullable(optional3);
        } else if (blockstate.m_60734_() instanceof CampfireBlock && Boolean.TRUE.equals(blockstate.m_61143_((Property)CampfireBlock.f_51227_))) {
            if (!level.m_5776_()) {
                level.m_5898_((Player)null, 1009, blockpos, 0);
            }
            CampfireBlock.m_152749_((Entity)context.m_43723_(), (LevelAccessor)level, (BlockPos)blockpos, (BlockState)blockstate);
            optional4 = Optional.ofNullable((BlockState)blockstate.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false)));
        }
        if (optional4.isPresent()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.f_10562_.m_285767_(serverPlayer, blockpos, itemstack);
            }
            level.m_7731_(blockpos, (BlockState)optional4.get(), 11);
            if (player != null) {
                itemstack.m_41622_(1, (LivingEntity)player, user -> user.m_21190_(context.m_43724_()));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"doom.argent_powered.text").m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.ITALIC));
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }
}

