/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.screen;

import guideme.Guide;
import guideme.PageAnchor;
import guideme.internal.GuideMEClient;
import guideme.internal.screen.GlobalInMemoryHistory;
import guideme.internal.screen.GuideIconButton;
import guideme.internal.screen.GuideNavigation;
import guideme.internal.screen.GuideScreenHistory;
import guideme.internal.screen.GuideSearchScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractWidget;
import org.jetbrains.annotations.Nullable;

public class NavigationToolbar {
    private static final int GAP = 5;
    @Nullable
    private final Guide guide;
    @Nullable
    private Runnable closeCallback;
    private boolean canSearch;
    private final GuideIconButton backButton;
    private final GuideIconButton forwardButton;
    private final GuideIconButton toggleFullWidthButton;
    private final GuideIconButton closeButton;
    private final GuideIconButton searchButton;
    private final List<GuideIconButton> buttons = new ArrayList<GuideIconButton>();

    public NavigationToolbar(@Nullable Guide guide) {
        this.guide = guide;
        this.searchButton = new GuideIconButton(0, 0, GuideIconButton.Role.SEARCH, this::startSearch);
        this.backButton = new GuideIconButton(0, 0, GuideIconButton.Role.BACK, () -> GuideNavigation.navigateBack(guide));
        this.forwardButton = new GuideIconButton(0, 0, GuideIconButton.Role.FORWARD, () -> GuideNavigation.navigateForward(guide));
        this.toggleFullWidthButton = new GuideIconButton(0, 0, GuideIconButton.Role.OPEN_FULL_WIDTH_VIEW, this::toggleFullWidth);
        this.closeButton = new GuideIconButton(0, 0, GuideIconButton.Role.CLOSE, () -> {
            if (this.closeCallback != null) {
                this.closeCallback.run();
            }
        });
        this.update();
    }

    public void update() {
        this.updateLayout();
        if (GuideMEClient.instance().isFullWidthLayout()) {
            this.toggleFullWidthButton.setRole(GuideIconButton.Role.CLOSE_FULL_WIDTH_VIEW);
        } else {
            this.toggleFullWidthButton.setRole(GuideIconButton.Role.OPEN_FULL_WIDTH_VIEW);
        }
        if (this.guide != null) {
            GuideScreenHistory history = GlobalInMemoryHistory.get(this.guide);
            this.backButton.f_93623_ = history.peekBack().isPresent();
            this.forwardButton.f_93623_ = history.peekForward().isPresent();
        }
    }

    public void addToScreen(Consumer<AbstractWidget> addWidget) {
        addWidget.accept((AbstractWidget)this.closeButton);
        addWidget.accept((AbstractWidget)this.toggleFullWidthButton);
        if (this.guide != null) {
            addWidget.accept((AbstractWidget)this.forwardButton);
            addWidget.accept((AbstractWidget)this.backButton);
        }
        if (this.canSearch) {
            addWidget.accept((AbstractWidget)this.searchButton);
        }
    }

    private void updateLayout() {
        this.buttons.clear();
        if (this.canSearch) {
            this.buttons.add(this.searchButton);
        }
        if (this.guide != null) {
            this.buttons.add(this.backButton);
            this.buttons.add(this.forwardButton);
        }
        this.buttons.add(this.toggleFullWidthButton);
        if (this.closeCallback != null) {
            this.buttons.add(this.closeButton);
        }
    }

    private void toggleFullWidth() {
        GuideMEClient.instance().setFullWidthLayout(!GuideMEClient.instance().isFullWidthLayout());
    }

    private void startSearch() {
        GuideNavigation.navigateTo(this.guide, PageAnchor.page(GuideSearchScreen.PAGE_ID));
    }

    public void setCloseCallback(@Nullable Runnable closeCallback) {
        this.closeCallback = closeCallback;
        this.update();
    }

    public boolean isCanSearch() {
        return this.canSearch;
    }

    public void setCanSearch(boolean canSearch) {
        this.canSearch = canSearch;
        this.update();
    }

    public int getWidth() {
        int width = 0;
        for (GuideIconButton button : this.buttons) {
            width += button.m_5711_() + 5;
        }
        return width;
    }

    public int getHeight() {
        return 16;
    }

    public void move(int x, int y) {
        for (GuideIconButton button : this.buttons) {
            button.m_252865_(x);
            button.m_253211_(y);
            x += button.m_5711_() + 5;
        }
    }
}

