/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.store;

import guideme.internal.shaded.lucene.store.BufferedIndexInput;
import guideme.internal.shaded.lucene.store.FSDirectory;
import guideme.internal.shaded.lucene.store.FSLockFactory;
import guideme.internal.shaded.lucene.store.IOContext;
import guideme.internal.shaded.lucene.store.IndexInput;
import guideme.internal.shaded.lucene.store.LockFactory;
import guideme.internal.shaded.lucene.util.IOUtils;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class NIOFSDirectory
extends FSDirectory {
    public NIOFSDirectory(Path path, LockFactory lockFactory) throws IOException {
        super(path, lockFactory);
    }

    public NIOFSDirectory(Path path) throws IOException {
        this(path, FSLockFactory.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexInput openInput(String name, IOContext context) throws IOException {
        NIOFSIndexInput nIOFSIndexInput;
        block3: {
            this.ensureOpen();
            this.ensureCanRead(name);
            Path path = this.getDirectory().resolve(name);
            FileChannel fc = FileChannel.open(path, StandardOpenOption.READ);
            boolean success = false;
            try {
                NIOFSIndexInput indexInput = new NIOFSIndexInput("NIOFSIndexInput(path=\"" + path + "\")", fc, context);
                success = true;
                nIOFSIndexInput = indexInput;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(fc);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(fc);
        }
        return nIOFSIndexInput;
    }

    static final class NIOFSIndexInput
    extends BufferedIndexInput {
        private static final int CHUNK_SIZE = 16384;
        protected final FileChannel channel;
        boolean isClone = false;
        protected final long off;
        protected final long end;

        public NIOFSIndexInput(String resourceDesc, FileChannel fc, IOContext context) throws IOException {
            super(resourceDesc, context);
            this.channel = fc;
            this.off = 0L;
            this.end = fc.size();
        }

        public NIOFSIndexInput(String resourceDesc, FileChannel fc, long off, long length, int bufferSize) {
            super(resourceDesc, bufferSize);
            this.channel = fc;
            this.off = off;
            this.end = off + length;
            this.isClone = true;
        }

        @Override
        public void close() throws IOException {
            if (!this.isClone) {
                this.channel.close();
            }
        }

        @Override
        public NIOFSIndexInput clone() {
            NIOFSIndexInput clone = (NIOFSIndexInput)super.clone();
            clone.isClone = true;
            return clone;
        }

        @Override
        public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
            if (offset < 0L || length < 0L || offset + length > this.length()) {
                throw new IllegalArgumentException("slice() " + sliceDescription + " out of bounds: offset=" + offset + ",length=" + length + ",fileLength=" + this.length() + ": " + this);
            }
            return new NIOFSIndexInput(this.getFullSliceDescription(sliceDescription), this.channel, this.off + offset, length, this.getBufferSize());
        }

        @Override
        public final long length() {
            return this.end - this.off;
        }

        @Override
        protected void readInternal(ByteBuffer b) throws IOException {
            long pos = this.getFilePointer() + this.off;
            if (pos + (long)b.remaining() > this.end) {
                throw new EOFException("read past EOF: " + this);
            }
            try {
                int readLength;
                int i;
                for (readLength = b.remaining(); readLength > 0; readLength -= i) {
                    int toRead = Math.min(16384, readLength);
                    b.limit(b.position() + toRead);
                    assert (b.remaining() == toRead);
                    i = this.channel.read(b, pos);
                    if (i < 0) {
                        throw new EOFException("read past EOF: " + this + " buffer: " + b + " chunkLen: " + toRead + " end: " + this.end);
                    }
                    assert (i > 0) : "FileChannel.read with non zero-length bb.remaining() must always read at least one byte (FileChannel is in blocking mode, see spec of ReadableByteChannel)";
                    pos += (long)i;
                }
                assert (readLength == 0);
            }
            catch (IOException ioe) {
                throw new IOException(ioe.getMessage() + ": " + this, ioe);
            }
        }

        @Override
        protected void seekInternal(long pos) throws IOException {
            if (pos > this.length()) {
                throw new EOFException("read past EOF: pos=" + pos + " vs length=" + this.length() + ": " + this);
            }
        }
    }
}

