/*
 * Decompiled with CFR 0.152.
 */
package net.hiccupslegacy.ai;

import java.util.EnumSet;
import net.hiccupslegacy.entity.DragonEntity;
import net.hiccupslegacy.procedures.ReplaceDragonProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class DragonFollowOwnerGoal
extends Goal {
    private final DragonEntity tamable;
    private LivingEntity owner;
    private final LevelReader level;
    private final double speedModifier;
    private final PathNavigation navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private final float startDistance;
    private float oldWaterCost;
    private final boolean canFly;

    public DragonFollowOwnerGoal(DragonEntity tamableAnimal, double speedModifier, float startDistance, float stopDistance, boolean canFly) {
        this.tamable = tamableAnimal;
        this.level = tamableAnimal.m_9236_();
        this.speedModifier = speedModifier;
        this.navigation = tamableAnimal.m_21573_();
        this.startDistance = startDistance;
        this.stopDistance = stopDistance;
        this.canFly = canFly;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(tamableAnimal.m_21573_() instanceof GroundPathNavigation) && !(tamableAnimal.m_21573_() instanceof FlyingPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean m_8036_() {
        LivingEntity dragonOwner = this.tamable.m_269323_();
        if (dragonOwner == null) {
            return false;
        }
        if (this.tamable.getMovementType() != 3) {
            return false;
        }
        if (dragonOwner.m_5833_()) {
            return false;
        }
        if (this.unableToMove()) {
            return false;
        }
        if (this.tamable.m_20280_((Entity)dragonOwner) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.owner = dragonOwner;
        return true;
    }

    public boolean m_8045_() {
        if (this.navigation.m_26571_()) {
            return false;
        }
        if (this.unableToMove()) {
            return false;
        }
        return !(this.tamable.m_20280_((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
    }

    private boolean unableToMove() {
        return this.tamable.m_21827_() || this.tamable.m_20159_() || this.tamable.m_21523_();
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.tamable.m_21439_(BlockPathTypes.WATER);
        this.tamable.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.owner = null;
        this.navigation.m_26573_();
        this.tamable.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        this.tamable.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.tamable.m_8132_());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.m_183277_(10);
            if (this.tamable.m_20280_((Entity)this.owner) >= 144.0) {
                this.teleportToOwner();
            } else {
                this.navigation.m_5624_((Entity)this.owner, this.speedModifier);
            }
        }
        if (this.owner.m_20186_() - this.tamable.m_20188_() > 4.0 || this.tamable.m_20186_() - this.owner.m_20186_() > 6.0) {
            ReplaceDragonProcedure.replaceWithFlyingCounterpart((LevelAccessor)this.tamable.m_9236_(), this.tamable.m_20185_(), this.tamable.m_20186_(), this.tamable.m_20189_(), (LivingEntity)this.tamable, null);
        }
    }

    private void teleportToOwner() {
        BlockPos ownerPosition = this.owner.m_20183_();
        for (int i = 0; i < 10; ++i) {
            int randomX = this.randomIntInclusive(-3, 3);
            int randomY = this.randomIntInclusive(-1, 1);
            int randomZ = this.randomIntInclusive(-3, 3);
            boolean maybeTeleportTo = this.maybeTeleportTo(ownerPosition.m_123341_() + randomX, ownerPosition.m_123342_() + randomY, ownerPosition.m_123343_() + randomZ);
            if (!maybeTeleportTo) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int x, int y, int z) {
        if (Math.abs((double)x - this.owner.m_20185_()) < 2.0 && Math.abs((double)z - this.owner.m_20189_()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(x, y, z))) {
            return false;
        }
        this.tamable.m_7678_((double)x + 0.5, y, (double)z + 0.5, this.tamable.m_146908_(), this.tamable.m_146909_());
        this.navigation.m_26573_();
        return true;
    }

    private boolean canTeleportTo(BlockPos blockPos) {
        BlockPathTypes blockPathTypeStatic = WalkNodeEvaluator.m_77604_((BlockGetter)this.level, (BlockPos.MutableBlockPos)blockPos.m_122032_());
        if (blockPathTypeStatic != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockState blockState = this.level.m_8055_(blockPos.m_7495_());
        if (!this.canFly && blockState.m_60734_() instanceof LeavesBlock) {
            return false;
        }
        BlockPos finalPos = blockPos.m_121996_((Vec3i)this.tamable.m_20183_());
        return this.level.m_45756_((Entity)this.tamable, this.tamable.m_20191_().m_82338_(finalPos));
    }

    private int randomIntInclusive(int min, int max) {
        return this.tamable.m_217043_().m_188503_(max - min + 1) + min;
    }
}

