/*
 * Decompiled with CFR 0.152.
 */
package net.hiccupslegacy.ai;

import java.util.EnumSet;
import java.util.List;
import net.hiccupslegacy.entity.NightterrorEntity;
import net.hiccupslegacy.init.HiccupsLegacyModEntities;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class NightTerrorFlyFollowLeaderGoal
extends Goal {
    private final NightterrorEntity nightTerror;
    private double speedModifier;

    public NightTerrorFlyFollowLeaderGoal(NightterrorEntity nightTerror, double speedModifier) {
        this.nightTerror = nightTerror;
        this.speedModifier = speedModifier;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.nightTerror.getVariantId() == 1) {
            return false;
        }
        if (!this.nightTerror.hasLeader()) {
            NightterrorEntity closestLeader = this.findClosestLeader();
            if (closestLeader != null) {
                this.nightTerror.joinLeader(closestLeader);
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean m_8045_() {
        NightterrorEntity leader = this.nightTerror.getLeader();
        if (leader == null || leader.m_213877_() || !leader.m_6084_()) {
            this.nightTerror.leaveLeader();
            return false;
        }
        return true;
    }

    public void m_8056_() {
        super.m_8056_();
        this.speedModifier = 10.0;
    }

    public void m_8041_() {
        this.nightTerror.leaveLeader();
        this.speedModifier = 2.1;
    }

    public void m_8037_() {
        double distanceToLeader;
        NightterrorEntity leader = this.nightTerror.getLeader();
        if (leader != null && (distanceToLeader = this.nightTerror.m_20280_((Entity)leader)) > 10.0) {
            Vec3 targetPos = leader.m_20299_(1.0f);
            this.nightTerror.m_21566_().m_6849_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_, this.speedModifier);
        }
    }

    private NightterrorEntity findClosestLeader() {
        List nightTerrorList = this.nightTerror.m_9236_().m_6249_((Entity)this.nightTerror, this.nightTerror.m_20191_().m_82377_(10.0, 8.0, 10.0), entity -> entity.m_6095_() == HiccupsLegacyModEntities.NIGHTTERROR.get());
        NightterrorEntity closestLeader = null;
        double lastDistance = Double.MAX_VALUE;
        for (Entity entity2 : nightTerrorList) {
            double distanceToSqr;
            NightterrorEntity candidate = (NightterrorEntity)entity2;
            if (candidate.getVariantId() != 1 || !((distanceToSqr = this.nightTerror.m_20280_((Entity)candidate)) < lastDistance)) continue;
            lastDistance = distanceToSqr;
            closestLeader = candidate;
        }
        return closestLeader;
    }
}

