/*
 * Decompiled with CFR 0.152.
 */
package net.hiccupslegacy.ai;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;

public class RandomFlyingGoal
extends Goal {
    public static final int DEFAULT_INTERVAL = 120;
    protected final PathfinderMob mob;
    protected double wantedX;
    protected double wantedY;
    protected double wantedZ;
    protected final double speedModifier;
    protected int interval;
    protected boolean forceTrigger;
    private final boolean checkNoActionTime;

    public RandomFlyingGoal(PathfinderMob mob, double speedModifier) {
        this(mob, speedModifier, 120);
    }

    public RandomFlyingGoal(PathfinderMob mob, double speedModifier, int interval) {
        this(mob, speedModifier, interval, true);
    }

    public RandomFlyingGoal(PathfinderMob mob, double speedModifier, int interval, boolean checkNoActionTime) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.interval = interval;
        this.checkNoActionTime = checkNoActionTime;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.mob.m_20160_()) {
            return false;
        }
        if (!this.forceTrigger) {
            if (this.checkNoActionTime && this.mob.m_21216_() >= 100) {
                return false;
            }
            if (this.mob.m_217043_().m_188503_(RandomFlyingGoal.m_186073_((int)this.interval)) != 0) {
                return false;
            }
        }
        if (this.mob.m_20096_()) {
            return false;
        }
        Vec3 position = this.getPosition();
        if (position == null) {
            return false;
        }
        this.wantedX = position.f_82479_;
        this.wantedY = position.f_82480_;
        this.wantedZ = position.f_82481_;
        this.forceTrigger = false;
        return true;
    }

    @Nullable
    protected Vec3 getPosition() {
        return DefaultRandomPos.m_148403_((PathfinderMob)this.mob, (int)10, (int)7);
    }

    public boolean m_8045_() {
        return !this.mob.m_21573_().m_26571_() && !this.mob.m_20160_();
    }

    public void m_8056_() {
        double deltaX = this.wantedX - this.mob.m_20185_();
        double deltaY = this.wantedY - this.mob.m_20186_();
        double deltaZ = this.wantedZ - this.mob.m_20189_();
        double distance = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
        double velocityX = deltaX / distance * this.speedModifier;
        double velocityY = deltaY / distance * this.speedModifier;
        double velocityZ = deltaZ / distance * this.speedModifier;
        this.mob.m_20334_(velocityX, velocityY, velocityZ);
    }

    public void m_8041_() {
        this.mob.m_20334_(0.0, 0.0, 0.0);
        super.m_8041_();
    }

    public void trigger() {
        this.forceTrigger = true;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }
}

