/*
 * Decompiled with CFR 0.152.
 */
package net.hiccupslegacy.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.hiccupslegacy.entity.FlyingDragonEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class FlyingDragonRenderer<T extends FlyingDragonEntity, M extends EntityModel<T>>
extends MobRenderer<T, M> {
    public FlyingDragonRenderer(EntityRendererProvider.Context context, M entityModel, float v) {
        super(context, entityModel, v);
    }

    protected abstract float getYOffset();

    protected float getMaxTilt() {
        return 70.0f;
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        float currentTilt = Mth.m_14036_((float)((float)(-entity.m_20184_().f_82480_) * 40.0f), (float)-70.0f, (float)this.getMaxTilt());
        ((FlyingDragonEntity)((Object)entity)).previousTilt = ((FlyingDragonEntity)((Object)entity)).previousTilt * 0.9f + currentTilt * 0.1f;
        float previousYaw = ((FlyingDragonEntity)((Object)entity)).f_20886_;
        float currentYaw = ((FlyingDragonEntity)((Object)entity)).f_20885_;
        float yawDifference = Mth.m_14177_((float)(currentYaw - previousYaw));
        float rollTarget = yawDifference * 2.0f;
        float smoothingFactor = 0.1f;
        ((FlyingDragonEntity)((Object)entity)).setLastRollAngle(FlyingDragonRenderer.lerpAngle(smoothingFactor, ((FlyingDragonEntity)((Object)entity)).getLastRollAngle(), rollTarget));
        poseStack.m_85836_();
        float bodyYaw = Mth.m_14179_((float)partialTicks, (float)((FlyingDragonEntity)((Object)entity)).f_20884_, (float)((FlyingDragonEntity)((Object)entity)).f_20883_);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-bodyYaw));
        poseStack.m_252880_(0.0f, this.getYOffset(), 0.0f);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(((FlyingDragonEntity)((Object)entity)).previousTilt));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(((FlyingDragonEntity)((Object)entity)).getLastRollAngle()));
        poseStack.m_252880_(0.0f, -this.getYOffset(), 0.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(bodyYaw));
        super.m_7392_(entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        poseStack.m_85849_();
    }

    public static float normalizeAngle(float angle) {
        if ((angle %= 360.0f) > 180.0f) {
            angle -= 360.0f;
        } else if (angle < -180.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public static float lerpAngle(float smoothingFactor, float startAngle, float endAngle) {
        startAngle = FlyingDragonRenderer.normalizeAngle(startAngle);
        float difference = (endAngle = FlyingDragonRenderer.normalizeAngle(endAngle)) - startAngle;
        if (difference > 180.0f) {
            difference -= 360.0f;
        } else if (difference < -180.0f) {
            difference += 360.0f;
        }
        float lerpedAngle = startAngle + difference * smoothingFactor;
        return FlyingDragonRenderer.normalizeAngle(lerpedAngle);
    }

    public boolean shouldRender(T entity, Frustum frustum, double x, double y, double z) {
        if (entity.m_20160_()) {
            return true;
        }
        return super.m_5523_(entity, frustum, x, y, z);
    }
}

