/*
 * Decompiled with CFR 0.152.
 */
package net.hiccupslegacy.entity;

import net.hiccupslegacy.entity.FlyingDragonEntity;
import net.hiccupslegacy.entity.GronckleEntity;
import net.hiccupslegacy.entity.GronckleFlyEntity;
import net.hiccupslegacy.entity.LightFuryEntity;
import net.hiccupslegacy.entity.LightFuryFlyEntity;
import net.hiccupslegacy.entity.NightFuryEntity;
import net.hiccupslegacy.entity.NightFuryFlyEntity;
import net.hiccupslegacy.entity.NightLightEntity;
import net.hiccupslegacy.entity.NightLightFlyEntity;
import net.hiccupslegacy.entity.SmallDragonEntity;
import net.hiccupslegacy.entity.SmallFlyingDragonEntity;
import net.hiccupslegacy.entity.SnowWraithEntity;
import net.hiccupslegacy.entity.SnowWraithFlyEntity;
import net.hiccupslegacy.procedures.DragonOnEntityTickUpdateProcedure;
import net.hiccupslegacy.procedures.DragonRightClickedOnEntityProcedure;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DragonEntity
extends TamableAnimal {
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.m_135353_(DragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TAMING_FOOD_AMOUNT = SynchedEntityData.m_135353_(DragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> MOVEMENT_TYPE = SynchedEntityData.m_135353_(DragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SECONDARY_ATTACK_TICK = SynchedEntityData.m_135353_(DragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public DragonEntity(EntityType<? extends DragonEntity> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(1.0f);
        this.m_21557_(false);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_VARIANT_ID, (Object)0);
        this.f_19804_.m_135372_(TAMING_FOOD_AMOUNT, (Object)0);
        this.f_19804_.m_135372_(MOVEMENT_TYPE, (Object)0);
        this.f_19804_.m_135372_(SECONDARY_ATTACK_TICK, (Object)-1);
    }

    public int getVariantId() {
        return (Integer)this.f_19804_.m_135370_(DATA_VARIANT_ID);
    }

    public void setVariantId(int variantId) {
        this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)variantId);
    }

    public int getVariantAmount() {
        return 1;
    }

    public int getExtraVariantsFromHatching() {
        return 0;
    }

    public int getTamingFoodAmount() {
        return (Integer)this.f_19804_.m_135370_(TAMING_FOOD_AMOUNT);
    }

    public void setTamingFoodAmount(int amount) {
        this.f_19804_.m_135381_(TAMING_FOOD_AMOUNT, (Object)amount);
    }

    public int getMovementType() {
        return (Integer)this.f_19804_.m_135370_(MOVEMENT_TYPE);
    }

    public void setMovementType(int movementType) {
        this.f_19804_.m_135381_(MOVEMENT_TYPE, (Object)movementType);
    }

    public int getSecondaryAttackTick() {
        return (Integer)this.f_19804_.m_135370_(SECONDARY_ATTACK_TICK);
    }

    public void setSecondaryAttackTick(int secondaryAttackTick) {
        this.f_19804_.m_135381_(SECONDARY_ATTACK_TICK, (Object)secondaryAttackTick);
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariantId());
        tag.m_128405_("TamingFoodAmount", this.getTamingFoodAmount());
        tag.m_128405_("MovementType", this.getMovementType());
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.setVariantId(tag.m_128451_("Variant"));
        this.setTamingFoodAmount(tag.m_128451_("TamingFoodAmount"));
        this.setMovementType(tag.m_128451_("MovementType"));
        if (this.m_21825_() || this.getMovementType() == 2) {
            this.m_20124_(Pose.SITTING);
            this.m_21837_(true);
        }
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public boolean m_5825_() {
        return true;
    }

    protected void clampRotation(Entity entity) {
        entity.m_5618_(this.m_146908_());
        float f = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
        float f1 = Mth.m_14036_((float)f, (float)-50.0f, (float)50.0f);
        entity.f_19859_ += f1 - f;
        entity.m_146922_(entity.m_146908_() + f1 - f);
        entity.m_5616_(entity.m_146908_());
    }

    public void m_7023_(Vec3 dir) {
        if (this.m_20160_() && this.getControllingEntity() == this.m_146895_()) {
            Entity entity = this.m_146895_();
            assert (entity != null);
            this.m_146922_(entity.m_146908_());
            this.f_19859_ = this.m_146908_();
            this.m_146926_(entity.m_146909_() * 0.5f);
            this.m_19915_(this.m_146908_(), this.m_146909_());
            this.f_20883_ = entity.m_146908_();
            this.f_20885_ = entity.m_146908_();
            if (entity instanceof LivingEntity) {
                float strafe;
                LivingEntity passenger = (LivingEntity)entity;
                this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                float forward = passenger.f_20902_;
                float f = strafe = this.getCanStrafe() ? passenger.f_20900_ : 0.0f;
                if (forward == 0.0f && strafe == 0.0f && this.m_20184_().m_82556_() < 0.15) {
                    this.m_20334_(this.m_20184_().f_82479_ * 0.95, this.m_20184_().f_82480_, this.m_20184_().f_82481_ * 0.95);
                }
                super.m_7023_(new Vec3((double)strafe, 0.0, (double)forward));
            }
            return;
        }
        super.m_7023_(dir);
    }

    public boolean isMoving() {
        return this.m_20184_().m_165925_() > 1.0E-6;
    }

    protected boolean getCanStrafe() {
        return true;
    }

    public static void init() {
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
    }

    public void m_6075_() {
        super.m_6075_();
        this.dragonTypeTickProcedure();
    }

    protected void dragonTypeTickProcedure() {
        DragonOnEntityTickUpdateProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this);
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        TamableAnimal tamableAnimal;
        Entity entity;
        if (damageSource.m_276093_(DamageTypes.f_268631_) || damageSource.m_276093_(DamageTypes.f_268671_) || damageSource.m_276093_(DamageTypes.f_268722_) || damageSource.m_276093_(DamageTypes.f_268482_) || damageSource.m_276093_(DamageTypes.f_268612_)) {
            return false;
        }
        if (damageSource.m_276093_(DamageTypes.f_268565_) && (this instanceof NightFuryEntity || this instanceof NightFuryFlyEntity || this instanceof LightFuryEntity || this instanceof LightFuryFlyEntity || this instanceof GronckleEntity || this instanceof GronckleFlyEntity || this instanceof SnowWraithEntity || this instanceof SnowWraithFlyEntity || this instanceof NightLightEntity || this instanceof NightLightFlyEntity)) {
            return false;
        }
        if (damageSource.m_7639_() == this || (entity = damageSource.m_7639_()) instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)entity).m_269323_() != null && tamableAnimal.m_269323_() == this.m_269323_()) {
            return false;
        }
        return super.m_6469_(damageSource, amount);
    }

    public boolean m_142535_(float l, float d, DamageSource source) {
        return false;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        SpawnGroupData retval = super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
        this.setVariantId(this.getRandomVariant());
        return retval;
    }

    public InteractionResult m_6071_(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.m_21120_(hand);
        InteractionResult retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        Item item = itemstack.m_41720_();
        boolean preventRiding = true;
        if (itemstack.m_41720_() instanceof SpawnEggItem) {
            retval = super.m_6071_(sourceentity, hand);
        } else if (this.m_9236_().m_5776_()) {
            retval = this.m_21824_() && this.m_21830_((LivingEntity)sourceentity) || this.m_6898_(itemstack) ? InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_()) : InteractionResult.PASS;
        } else if (this.m_21824_()) {
            preventRiding = false;
            if (this.m_21830_((LivingEntity)sourceentity)) {
                if (item.m_41472_() && this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                    this.m_142075_(sourceentity, hand, itemstack);
                    this.m_5634_(item.m_41473_().m_38744_());
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11912_, SoundSource.NEUTRAL, 1.0f, 1.0f / (RandomSource.m_216327_().m_188501_() * 0.5f + 1.0f));
                    retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                    preventRiding = true;
                } else if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                    this.m_142075_(sourceentity, hand, itemstack);
                    this.m_5634_(4.0f);
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11912_, SoundSource.NEUTRAL, 1.0f, 1.0f / (RandomSource.m_216327_().m_188501_() * 0.5f + 1.0f));
                    retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                    preventRiding = true;
                } else {
                    Level level;
                    if (this.m_6162_() && !sourceentity.m_6047_() && (level = this.m_9236_()) instanceof ServerLevel) {
                        ServerLevel _level = (ServerLevel)level;
                        _level.m_8767_((ParticleOptions)ParticleTypes.f_123750_, this.m_20185_(), this.m_20186_() + 0.2, this.m_20189_(), 5, 0.5, 0.5, 0.5, 0.0);
                    }
                    retval = super.m_6071_(sourceentity, hand);
                }
            }
        } else if (!this.canBeTamed()) {
            retval = super.m_6071_(sourceentity, hand);
        } else if (this.m_6898_(itemstack)) {
            boolean isSmallDragon;
            this.m_142075_(sourceentity, hand, itemstack);
            int currentFood = this.getTamingFoodAmount();
            boolean bl = isSmallDragon = this instanceof SmallDragonEntity || this instanceof SmallFlyingDragonEntity;
            int neededFood = this.m_146764_() < 0 ? (isSmallDragon ? 2 : 10) + this.m_217043_().m_188503_(10) : (isSmallDragon ? 5 : 30) + this.m_217043_().m_188503_(20);
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11912_, SoundSource.NEUTRAL, 1.0f, 1.0f / (RandomSource.m_216327_().m_188501_() * 0.5f + 1.0f));
            if (currentFood >= neededFood && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.m_21828_(sourceentity);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.setTamingFoodAmount(currentFood + 1);
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            this.m_21530_();
            retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        } else {
            retval = super.m_6071_(sourceentity, hand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.m_21530_();
            }
        }
        if (!(this.m_6162_() || this.m_9236_().f_46443_ || !this.canBeRidden() || !this.m_21830_((LivingEntity)sourceentity) && this.m_146895_() != this.m_269323_() || !this.m_20197_().isEmpty() && this.m_20197_().size() >= this.maxPassengers() - 1 || preventRiding)) {
            sourceentity.m_20329_((Entity)this);
        }
        Level world = this.m_9236_();
        DragonRightClickedOnEntityProcedure.execute(world, this, (Entity)sourceentity, hand);
        return retval;
    }

    protected void m_20348_(Entity entity) {
        if (this.m_20197_().size() >= this.maxPassengers()) {
            return;
        }
        if (this.getMovementType() == 2 && !(this instanceof FlyingDragonEntity) && this.m_20197_().isEmpty()) {
            this.m_20334_(0.0, 0.0, 0.0);
        }
        super.m_20348_(entity);
    }

    protected boolean canBeRidden() {
        return true;
    }

    protected boolean canBeTamed() {
        return true;
    }

    public int maxPassengers() {
        return 2;
    }

    protected boolean m_7310_(Entity passenger) {
        if (this.m_21824_() && (this.m_269323_() == this.m_146895_() || this.m_269323_() == passenger)) {
            return this.m_20197_().size() < this.maxPassengers();
        }
        return super.m_7310_(passenger);
    }

    protected void m_20351_(Entity passenger) {
        super.m_20351_(passenger);
        if (!this.m_20197_().contains(this.m_269323_())) {
            this.m_20153_();
        }
    }

    public LivingEntity getControllingEntity() {
        Entity entity = this.m_146895_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.m_21824_() && this.m_21830_((LivingEntity)player)) {
                return player;
            }
        }
        return null;
    }

    public boolean needsToSeeSkyToFly() {
        return true;
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction moveFunction) {
        if (this.m_20363_(passenger)) {
            int index = this.m_20197_().indexOf(passenger);
            if (index == 0 && passenger == this.m_269323_()) {
                double d0 = this.m_20186_() + this.m_6048_() + passenger.m_6049_();
                moveFunction.m_20372_(passenger, this.m_20185_(), d0, this.m_20189_());
            } else {
                moveFunction.m_20372_(passenger, this.m_20185_(), this.m_20186_() - passenger.m_20191_().m_82376_(), this.m_20189_());
            }
        }
    }

    public int getRandomVariant() {
        return this.f_19796_.m_188503_(this.getVariantAmount());
    }
}

