/*
 * Decompiled with CFR 0.152.
 */
package net.hiccupslegacy.entity;

import java.util.EnumSet;
import net.hiccupslegacy.ai.DragonMovementControl;
import net.hiccupslegacy.ai.DragonPathNavigation;
import net.hiccupslegacy.ai.WaterAvoidingRandomDragonStrollGoal;
import net.hiccupslegacy.config.ConfigHandler;
import net.hiccupslegacy.init.HiccupsLegacyModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class FirewormEntity
extends Monster {
    private static EntityDataAccessor<Float> CUSTOM_SCALE = SynchedEntityData.m_135353_(FirewormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private int lastStoppedFlyingTick = 0;
    private boolean firstTickDone = false;

    public FirewormEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<FirewormEntity>)((EntityType)HiccupsLegacyModEntities.FIREWORM.get()), world);
    }

    public FirewormEntity(EntityType<FirewormEntity> type, Level world) {
        super(type, world);
        this.m_274367_(1.0f);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.f_21342_ = new DragonMovementControl((Mob)this, 1, true);
        this.f_21344_ = new DragonPathNavigation((Mob)this, world);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected PathNavigation m_6037_(Level world) {
        return new DragonPathNavigation((Mob)this, world);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CUSTOM_SCALE, (Object)Float.valueOf(this.f_19796_.m_188501_() * 0.75f + 0.25f));
    }

    public float getCustomScale() {
        return ((Float)this.f_19804_.m_135370_(CUSTOM_SCALE)).floatValue();
    }

    public void setCustomScale(float customScale) {
        this.f_19804_.m_135381_(CUSTOM_SCALE, (Object)Float.valueOf(customScale));
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, new Goal(){
            {
                this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            }

            public boolean m_8036_() {
                return FirewormEntity.this.m_5448_() != null && !FirewormEntity.this.m_21566_().m_24995_();
            }

            public boolean m_8045_() {
                return FirewormEntity.this.m_21566_().m_24995_() && FirewormEntity.this.m_5448_() != null && FirewormEntity.this.m_5448_().m_6084_();
            }

            public void m_8056_() {
                LivingEntity livingentity = FirewormEntity.this.m_5448_();
                Vec3 vec3d = livingentity.m_20299_(1.0f);
                FirewormEntity.this.f_21342_.m_6849_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 1.0);
            }

            public void m_8037_() {
                LivingEntity livingentity = FirewormEntity.this.m_5448_();
                if (livingentity == null) {
                    return;
                }
                if (FirewormEntity.this.m_20191_().m_82381_(livingentity.m_20191_())) {
                    FirewormEntity.this.m_7327_((Entity)livingentity);
                } else {
                    double d0 = FirewormEntity.this.m_20280_((Entity)livingentity);
                    if (d0 < 16.0) {
                        Vec3 vec3d = livingentity.m_20299_(1.0f);
                        FirewormEntity.this.f_21342_.m_6849_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 1.0);
                    }
                }
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomDragonStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected double m_6639_(LivingEntity entity) {
                return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + entity.m_20205_();
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(5, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        super.m_7472_(source, looting, recentlyHitIn);
        this.m_19983_(new ItemStack((ItemLike)Items.f_42525_));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return SoundEvents.f_11915_;
    }

    public SoundEvent m_5592_() {
        return SoundEvents.f_11910_;
    }

    public float m_6134_() {
        if (this.m_6162_()) {
            return 0.3f;
        }
        return this.getCustomScale();
    }

    public boolean m_142535_(float l, float d, DamageSource source) {
        return false;
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (damagesource.m_276093_(DamageTypes.f_268631_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268482_)) {
            return false;
        }
        return super.m_6469_(damagesource, amount);
    }

    public boolean m_5825_() {
        return true;
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        Level world = this.m_9236_();
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        if (world.m_5776_()) {
            return;
        }
        if (!(source.m_7639_() instanceof Player)) {
            return;
        }
        if (!((Boolean)ConfigHandler.ALLOW_FIREWORM_GRIEF.get()).booleanValue()) {
            return;
        }
        if (!world.m_6106_().m_5470_().m_46207_(GameRules.f_46132_)) {
            return;
        }
        if (!world.m_46859_(BlockPos.m_274561_((double)x, (double)y, (double)z))) {
            return;
        }
        if (!(world.m_46859_(BlockPos.m_274561_((double)x, (double)(y - 1.0), (double)z)) && world.m_46859_(BlockPos.m_274561_((double)(x - 1.0), (double)y, (double)z)) && world.m_46859_(BlockPos.m_274561_((double)(x + 1.0), (double)y, (double)z)) && world.m_46859_(BlockPos.m_274561_((double)x, (double)y, (double)(z - 1.0))) && world.m_46859_(BlockPos.m_274561_((double)x, (double)y, (double)(z + 1.0))))) {
            world.m_7731_(BlockPos.m_274561_((double)x, (double)y, (double)z), Blocks.f_50083_.m_49966_(), 3);
        }
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.firstTickDone) {
            this.firstTickDone = true;
            if (this.m_20068_()) {
                this.switchToFlying();
            } else {
                this.switchToGround();
            }
        }
        if (this.m_20096_() && this.m_20068_() && this.m_5448_() == null) {
            this.switchToGround();
        } else if (!this.m_20068_() && this.m_20096_() && this.f_19797_ - this.lastStoppedFlyingTick > 400 && this.f_19797_ % 40 == 0 && (double)this.m_217043_().m_188501_() <= 0.1) {
            this.switchToFlying();
        } else if (this.m_20184_().f_82480_ < -0.5 && !this.m_20068_()) {
            this.switchToFlying();
        }
    }

    protected void switchToGround() {
        this.m_20242_(false);
        this.lastStoppedFlyingTick = this.f_19797_;
        this.f_21344_.m_26573_();
    }

    protected void switchToFlying() {
        if (!this.m_20068_()) {
            this.m_20242_(true);
            Vec3 vel = this.m_20184_();
            this.m_20334_(vel.f_82479_, vel.f_82480_ + 0.3, vel.f_82481_);
        }
        this.f_21344_.m_26573_();
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.2);
        builder = builder.m_22268_(Attributes.f_22276_, 5.0);
        builder = builder.m_22268_(Attributes.f_22284_, 1.25);
        builder = builder.m_22268_(Attributes.f_22281_, 1.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        builder = builder.m_22268_(Attributes.f_22280_, 0.5);
        builder = builder.m_22268_(Attributes.f_22288_, 1.3);
        return builder;
    }
}

