/*
 * Decompiled with CFR 0.152.
 */
package net.hiccupslegacy.entity;

import java.util.ArrayList;
import java.util.List;
import net.hiccupslegacy.ai.FlyingDragonFollowOwnerGoal;
import net.hiccupslegacy.entity.DragonEntity;
import net.hiccupslegacy.entity.SmallFlyingDragonEntity;
import net.hiccupslegacy.procedures.DragonFlyingOnEntityTickUpdateProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class FlyingDragonEntity
extends DragonEntity {
    private static final EntityDataAccessor<Boolean> WAS_RIDDEN = SynchedEntityData.m_135353_(FlyingDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> LAST_ROLL_ANGLE = SynchedEntityData.m_135353_(FlyingDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public float previousTilt = 0.0f;
    public float prevRightWingRot = 0.0f;
    public float prevLeftWingRot = 0.0f;
    public float prevRightWingEndRot = 0.0f;
    public float prevLeftWingEndRot = 0.0f;
    public List<Float> tailRotationHistory = new ArrayList<Float>();
    public float lastYVelocity = 0.0f;
    public boolean isLandingPrevented = false;

    public FlyingDragonEntity(EntityType<? extends DragonEntity> entityType, Level level) {
        super(entityType, level);
        this.m_21557_(false);
        this.m_274367_(1.0f);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, true);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(WAS_RIDDEN, (Object)false);
        this.f_19804_.m_135372_(LAST_ROLL_ANGLE, (Object)Float.valueOf(0.0f));
    }

    public boolean getWasRidden() {
        return (Boolean)this.f_19804_.m_135370_(WAS_RIDDEN);
    }

    public void setWasRidden(boolean ridden) {
        this.f_19804_.m_135381_(WAS_RIDDEN, (Object)ridden);
    }

    public float getLastRollAngle() {
        return ((Float)this.f_19804_.m_135370_(LAST_ROLL_ANGLE)).floatValue();
    }

    public void setLastRollAngle(float lastRollAngle) {
        this.f_19804_.m_135381_(LAST_ROLL_ANGLE, (Object)Float.valueOf(lastRollAngle));
    }

    public int m_21529_() {
        return 4;
    }

    protected float m_274460_() {
        if (this.m_146895_() instanceof Player) {
            return 0.02f;
        }
        if (this.getWasRidden()) {
            return 0.08f;
        }
        if (this instanceof SmallFlyingDragonEntity) {
            return 0.03f;
        }
        return this.m_6113_() * 0.05f;
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(3, (Goal)new FlyingDragonFollowOwnerGoal(this, 10.0, 5.0f, 2.0f));
    }

    @Override
    protected boolean getCanStrafe() {
        return false;
    }

    @Override
    protected void m_20348_(Entity entity) {
        super.m_20348_(entity);
        this.setWasRidden(true);
    }

    protected PathNavigation m_6037_(Level world) {
        return new FlyingPathNavigation((Mob)this, world);
    }

    @Override
    protected void dragonTypeTickProcedure() {
        DragonFlyingOnEntityTickUpdateProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this);
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public FlyingSpeed getDragonFlyingSpeed() {
        return FlyingSpeed.MEDIUM;
    }

    @NotNull
    public Vec3 m_7688_(@NotNull LivingEntity passenger) {
        if (this.m_20197_().size() == this.maxPassengers() - 1) {
            return new Vec3(this.m_20185_(), this.m_20191_().f_82289_ - passenger.m_20191_().m_82376_(), this.m_20189_());
        }
        return super.m_7688_(passenger);
    }

    @Override
    public boolean isMoving() {
        Vec3 delta = this.m_20184_();
        return delta.m_165925_() > 1.0E-6 || delta.f_82480_ < -0.1;
    }

    public void m_20242_(boolean ignored) {
        super.m_20242_(true);
    }

    public boolean addLookingVectorVelocity() {
        return true;
    }

    public boolean shouldGoDownWithTimer() {
        return true;
    }

    public boolean canLand() {
        return true;
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_20242_(true);
    }

    public void playFlapSound() {
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11893_, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    public static enum FlyingSpeed {
        SLOW(0),
        MEDIUM(1),
        FAST(2);

        int speed;

        private FlyingSpeed(int speed) {
            this.speed = speed;
        }

        public int getSpeed() {
            return this.speed;
        }
    }
}

