/*
 * Decompiled with CFR 0.152.
 */
package net.hiccupslegacy.entity;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import net.hiccupslegacy.entity.LargeDragonProjectileEntity;
import net.hiccupslegacy.init.HiccupsLegacyModEntities;
import net.hiccupslegacy.init.HiccupsLegacyModMobEffects;
import net.hiccupslegacy.init.HiccupsLegacyModSounds;
import net.hiccupslegacy.procedures.RedDeathFlyingOnTickUpdateProcedure;
import net.hiccupslegacy.procedures.RedDeathKilledProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.BreathAirGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.SpectralArrow;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;

public class RedDeathFlyEntity
extends Monster
implements RangedAttackMob {
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_6);
    private static final EntityDataAccessor<Boolean> IS_MOUTH_OPEN = SynchedEntityData.m_135353_(RedDeathFlyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int biteCooldownTicks = 0;

    public RedDeathFlyEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<RedDeathFlyEntity>)((EntityType)HiccupsLegacyModEntities.RED_DEATH_FLY.get()), world);
    }

    public RedDeathFlyEntity(EntityType<RedDeathFlyEntity> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.f_21364_ = 3200;
        this.m_21557_(false);
        this.m_21530_();
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, true);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected PathNavigation m_6037_(Level world) {
        return new FlyingPathNavigation((Mob)this, world);
    }

    protected float m_6121_() {
        return 4.0f;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_MOUTH_OPEN, (Object)false);
    }

    public boolean getIsMouthOpen() {
        return (Boolean)this.f_19804_.m_135370_(IS_MOUTH_OPEN);
    }

    public void setIsMouthOpen(boolean isMouthOpen) {
        this.f_19804_.m_135381_(IS_MOUTH_OPEN, (Object)isMouthOpen);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, new Goal(){
            {
                this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            }

            public boolean m_8036_() {
                return RedDeathFlyEntity.this.m_5448_() != null && !RedDeathFlyEntity.this.m_21566_().m_24995_();
            }

            public boolean m_8045_() {
                return RedDeathFlyEntity.this.m_21566_().m_24995_() && RedDeathFlyEntity.this.m_5448_() != null && RedDeathFlyEntity.this.m_5448_().m_6084_();
            }

            public void m_8056_() {
                LivingEntity livingentity = RedDeathFlyEntity.this.m_5448_();
                Vec3 vec3d = livingentity.m_20299_(1.0f);
                RedDeathFlyEntity.this.f_21342_.m_6849_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 2.0);
            }

            public void m_8041_() {
                super.m_8041_();
            }

            public void m_8037_() {
                LivingEntity livingentity = RedDeathFlyEntity.this.m_5448_();
                double d0 = RedDeathFlyEntity.this.m_20280_((Entity)livingentity);
                if (RedDeathFlyEntity.this.biteCooldownTicks <= 0 && d0 < 400.0) {
                    RedDeathFlyEntity.this.m_7327_((Entity)livingentity);
                    RedDeathFlyEntity.this.playBiteSound();
                    RedDeathFlyEntity.this.biteCooldownTicks = 30;
                } else if (d0 < 60.0) {
                    Vec3 vec3d = livingentity.m_20299_(1.0f);
                    RedDeathFlyEntity.this.f_21342_.m_6849_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 2.0);
                }
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 2.0, true){

            protected double m_6639_(@NotNull LivingEntity entity) {
                return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + entity.m_20205_();
            }
        });
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(4, (Goal)new BreathAirGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.f_21345_.m_25352_(1, (Goal)new RangedAttackGoal(this, 1.25, 80, 10.0f){

            public boolean m_8045_() {
                return this.m_8036_();
            }
        });
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)HiccupsLegacyModSounds.RED_DEATH_IDLE.get();
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return SoundEvents.f_11915_;
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)HiccupsLegacyModSounds.RED_DEATH_IDLE.get();
    }

    public void m_8032_() {
        super.m_8032_();
        Vec3 _center = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
        List<Entity> _entfound = this.m_9236_().m_6443_(Entity.class, new AABB(_center, _center).m_82400_(25.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.m_20238_(_center))).toList();
        for (Entity entityiterator : _entfound) {
            ServerPlayer _entity;
            Player _entity2;
            if (entityiterator instanceof Player && !(_entity2 = (Player)entityiterator).m_9236_().m_5776_()) {
                _entity2.m_7292_(new MobEffectInstance((MobEffect)HiccupsLegacyModMobEffects.SCREEN_SHAKE.get(), 80, 5, false, false));
                continue;
            }
            if (!(entityiterator instanceof ServerPlayer) || (_entity = (ServerPlayer)entityiterator).m_9236_().m_5776_()) continue;
            _entity.m_7292_(new MobEffectInstance((MobEffect)HiccupsLegacyModMobEffects.SCREEN_SHAKE.get(), 80, 5, false, false));
        }
    }

    public void playBiteSound() {
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12187_, SoundSource.HOSTILE, this.m_6121_(), 0.4f);
    }

    public boolean m_142535_(float l, float d, DamageSource source) {
        return false;
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (damagesource.m_276093_(DamageTypes.f_268631_)) {
            return false;
        }
        if (damagesource.m_7640_() instanceof ThrownPotion || damagesource.m_7640_() instanceof AreaEffectCloud) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268585_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268526_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268482_)) {
            return false;
        }
        if (damagesource.m_7640_() instanceof SpectralArrow || damagesource.m_7640_() instanceof Arrow) {
            return false;
        }
        return super.m_6469_(damagesource, amount);
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        RedDeathKilledProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), source.m_7639_());
    }

    public boolean m_5825_() {
        return true;
    }

    public void m_6075_() {
        super.m_6075_();
        RedDeathFlyingOnTickUpdateProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), (LivingEntity)this);
        if (!this.m_9236_().f_46443_) {
            if (this.biteCooldownTicks > 0) {
                --this.biteCooldownTicks;
            }
            this.setIsMouthOpen(this.m_5448_() != null && this.biteCooldownTicks <= 0);
        }
    }

    public void m_6504_(LivingEntity target, float flval) {
        LargeDragonProjectileEntity.shoot((LivingEntity)this, target);
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6072_() {
        return false;
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public void m_8024_() {
        super.m_8024_();
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void m_20242_(boolean ignored) {
        super.m_20242_(true);
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_20242_(true);
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 1.0);
        builder = builder.m_22268_(Attributes.f_22276_, 500.0);
        builder = builder.m_22268_(Attributes.f_22284_, 2.0);
        builder = builder.m_22268_(Attributes.f_22281_, 30.0);
        builder = builder.m_22268_(Attributes.f_22277_, 64.0);
        builder = builder.m_22268_(Attributes.f_22278_, 2.0);
        builder = builder.m_22268_(Attributes.f_22280_, 1.0);
        return builder;
    }
}

