/*
 * Decompiled with CFR 0.152.
 */
package net.hiccupslegacy.entity.eggs;

import net.hiccupslegacy.HiccupsLegacyMod;
import net.hiccupslegacy.procedures.EggOnEntityTickUpdateProcedure;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public abstract class AgeableEgg
extends AgeableMob {
    private static final EntityDataAccessor<Boolean> ALMOST_HATCHING = SynchedEntityData.m_135353_(AgeableEgg.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    protected AgeableEgg(EntityType<? extends AgeableMob> p_146738_, Level p_146739_) {
        super(p_146738_, p_146739_);
        this.m_146762_(12000);
        this.f_21364_ = 0;
        this.m_21530_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ALMOST_HATCHING, (Object)false);
    }

    public boolean getAlmostHatching() {
        return (Boolean)this.f_19804_.m_135370_(ALMOST_HATCHING);
    }

    public void setAlmostHatching(boolean almostHatching) {
        this.f_19804_.m_135381_(ALMOST_HATCHING, (Object)almostHatching);
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public boolean m_5825_() {
        return true;
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.turtle.egg_crack"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.turtle.egg_crack"));
    }

    public void m_6075_() {
        super.m_6075_();
        EggOnEntityTickUpdateProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this);
    }

    public boolean m_7337_(Entity entity) {
        return true;
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (damagesource.m_276093_(DamageTypes.f_268631_)) {
            return false;
        }
        if (damagesource.m_7640_() instanceof ThrownPotion || damagesource.m_7640_() instanceof AreaEffectCloud) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268585_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268450_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268482_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268493_) || damagesource.m_276093_(DamageTypes.f_268641_)) {
            return false;
        }
        return super.m_6469_(damagesource, amount);
    }

    public void m_6667_(DamageSource cause) {
        ResourceLocation entityRegistryName;
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_7605_((Entity)this, (byte)3);
        }
        if ((entityRegistryName = ForgeRegistries.ENTITY_TYPES.getKey((Object)this.m_6095_())) != null) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(entityRegistryName);
            if (item != null) {
                this.m_19983_(new ItemStack((ItemLike)item));
            } else {
                HiccupsLegacyMod.LOGGER.warn("No item found for entity: " + entityRegistryName);
            }
        } else {
            HiccupsLegacyMod.LOGGER.warn("Entity type not registered: " + this.m_6095_());
        }
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public EntityType<?> getHatchEntity() {
        return null;
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 1.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        return builder;
    }
}

