/*
 * Decompiled with CFR 0.152.
 */
package net.hiccupslegacy.init;

import net.hiccupslegacy.init.HiccupsLegacyModEntities;
import net.hiccupslegacy.network.HiccupsLegacyModVariables;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="hiccups_legacy", bus=Mod.EventBusSubscriber.Bus.MOD)
public class HiccupsLegacyModEvents {
    @SubscribeEvent
    public static void registerSpawnPlacements(SpawnPlacementRegisterEvent event) {
        event.register((EntityType)HiccupsLegacyModEntities.FIREWORM.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, HiccupsLegacyModEvents::checkFirewormSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)HiccupsLegacyModEntities.WHISPERING_DEATH.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, HiccupsLegacyModEvents::checkWhisperingDeathSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)HiccupsLegacyModEntities.DEADLY_NADDER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)HiccupsLegacyModEntities.SPEED_STINGER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)HiccupsLegacyModEntities.RAZORWHIP.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, HiccupsLegacyModEvents::checkRazorwhipSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)HiccupsLegacyModEntities.SONGWING.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, HiccupsLegacyModEvents::checkSongWingSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)HiccupsLegacyModEntities.GRONCKLE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, HiccupsLegacyModEvents::checkDryAreaSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)HiccupsLegacyModEntities.DEATH_SONNG.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)HiccupsLegacyModEntities.HOBGOBBLER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)HiccupsLegacyModEntities.FLIGHTMARE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)HiccupsLegacyModEntities.NIGHTTERRORWALK.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)HiccupsLegacyModEntities.SNOW_WRAITH.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)HiccupsLegacyModEntities.YAK.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)HiccupsLegacyModEntities.HIDEOUS_ZIPPLEBACK.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)HiccupsLegacyModEntities.MONSTROUS_NIGHTMARE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, HiccupsLegacyModEvents::checkDryAreaSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)HiccupsLegacyModEntities.GRIM_GNASHER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)HiccupsLegacyModEntities.NIGHTFURY.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)HiccupsLegacyModEntities.LIGHTFURY.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)HiccupsLegacyModEntities.SMOTHER_SMOKE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)HiccupsLegacyModEntities.SKRILL_FLY.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, HiccupsLegacyModEvents::checkSkrillSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)HiccupsLegacyModEntities.EEL.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, HiccupsLegacyModEvents::checkEelSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)HiccupsLegacyModEntities.THUNDERDRUM_FLY.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, HiccupsLegacyModEvents::checkThunderdrumSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)HiccupsLegacyModEntities.TERRIBLE_TERROR.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    private static boolean checkSkrillSpawnRules(EntityType<? extends Animal> entity, ServerLevelAccessor serverLevelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        return serverLevelAccessor.m_6018_().m_46470_() && blockPos.m_123342_() > 90 && HiccupsLegacyModVariables.MapVariables.get((LevelAccessor)serverLevelAccessor).unlockedSkrill;
    }

    private static boolean checkThunderdrumSpawnRules(EntityType<? extends Animal> entity, ServerLevelAccessor serverLevelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        return serverLevelAccessor.m_8055_(blockPos).m_60713_(Blocks.f_49990_) && HiccupsLegacyModVariables.MapVariables.get((LevelAccessor)serverLevelAccessor).unlockedThunderdrum;
    }

    private static boolean checkEelSpawnRules(EntityType<? extends PathfinderMob> entity, ServerLevelAccessor serverLevelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        return serverLevelAccessor.m_8055_(blockPos).m_60713_(Blocks.f_49990_) && serverLevelAccessor.m_8055_(blockPos.m_7494_()).m_60713_(Blocks.f_49990_);
    }

    private static boolean checkWhisperingDeathSpawnRules(EntityType<? extends Animal> entity, ServerLevelAccessor serverLevelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        BlockState blockStateBellow = serverLevelAccessor.m_8055_(blockPos.m_7495_());
        if (serverLevelAccessor.m_6018_().m_204166_(blockPos).m_203656_(BiomeTags.f_207607_) && (double)randomSource.m_188501_() < 0.75) {
            return false;
        }
        return blockStateBellow.m_204336_(BlockTags.f_184228_) || blockStateBellow.m_204336_(BlockTags.f_13061_) || blockStateBellow.m_60713_(Blocks.f_49994_) || blockStateBellow.m_204336_(BlockTags.f_13029_) || blockStateBellow.m_204336_(BlockTags.f_198156_);
    }

    private static boolean checkFirewormSpawnRules(EntityType<? extends Monster> entity, ServerLevelAccessor levelAccessor, MobSpawnType type, BlockPos pos, RandomSource randomSource) {
        return !levelAccessor.m_46861_(pos) && Monster.m_219009_((ServerLevelAccessor)levelAccessor, (BlockPos)pos, (RandomSource)randomSource) && Mob.m_217057_(entity, (LevelAccessor)levelAccessor, (MobSpawnType)type, (BlockPos)pos, (RandomSource)randomSource);
    }

    private static boolean checkDryAreaSpawnRules(EntityType<? extends Animal> entity, ServerLevelAccessor serverLevelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        BlockState blockStateBellow = serverLevelAccessor.m_8055_(blockPos.m_7495_());
        if (serverLevelAccessor.m_6018_().m_204166_(blockPos).m_203656_(BiomeTags.f_207607_) && (double)randomSource.m_188501_() < 0.75) {
            return false;
        }
        return (blockStateBellow.m_204336_(BlockTags.f_184228_) || blockStateBellow.m_204336_(BlockTags.f_13029_) || blockStateBellow.m_204336_(BlockTags.f_198156_)) && HiccupsLegacyModEvents.isBrightEnoughToSpawn((BlockAndTintGetter)serverLevelAccessor, blockPos);
    }

    private static boolean checkSongWingSpawnRules(EntityType<? extends Animal> entity, ServerLevelAccessor serverLevelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        return serverLevelAccessor.m_8055_(blockPos.m_7495_()).m_204336_(BlockTags.f_184228_) && HiccupsLegacyModEvents.isBrightEnoughToSpawn((BlockAndTintGetter)serverLevelAccessor, blockPos) && HiccupsLegacyModVariables.MapVariables.get((LevelAccessor)serverLevelAccessor).unlockedSongwing;
    }

    private static boolean checkRazorwhipSpawnRules(EntityType<? extends Animal> entity, ServerLevelAccessor serverLevelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        return serverLevelAccessor.m_8055_(blockPos.m_7495_()).m_204336_(BlockTags.f_184228_) && HiccupsLegacyModEvents.isBrightEnoughToSpawn((BlockAndTintGetter)serverLevelAccessor, blockPos) && HiccupsLegacyModVariables.MapVariables.get((LevelAccessor)serverLevelAccessor).unlockedRazorwhip;
    }

    protected static boolean isBrightEnoughToSpawn(BlockAndTintGetter blockAndTintGetter, BlockPos blockPos) {
        return blockAndTintGetter.m_45524_(blockPos, 0) > 8;
    }
}

