/*
 * Decompiled with CFR 0.152.
 */
package net.hiccupslegacy.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.hiccupslegacy.HiccupsLegacyMod;
import net.hiccupslegacy.world.inventory.DragonEyeButtonsGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DragonEyeButtonsGUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public DragonEyeButtonsGUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public DragonEyeButtonsGUIButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(DragonEyeButtonsGUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(DragonEyeButtonsGUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            DragonEyeButtonsGUIButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int id, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = DragonEyeButtonsGUIMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        int dragonEyeMode = entity.m_21205_().m_41784_().m_128451_("dragonEyeMode");
        int currentClass = entity.m_21205_().m_41784_().m_128451_("dragonClass");
        dragonEyeMode = id != currentClass ? 0 : (dragonEyeMode + 1) % 3;
        entity.m_21205_().m_41784_().m_128405_("dragonEyeMode", dragonEyeMode);
        entity.m_21205_().m_41784_().m_128405_("dragonClass", id);
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        HiccupsLegacyMod.addNetworkMessage(DragonEyeButtonsGUIButtonMessage.class, DragonEyeButtonsGUIButtonMessage::buffer, DragonEyeButtonsGUIButtonMessage::new, DragonEyeButtonsGUIButtonMessage::handler);
    }
}

