/*
 * Decompiled with CFR 0.152.
 */
package net.hiccupslegacy.procedures;

import java.util.Comparator;
import java.util.List;
import net.hiccupslegacy.HiccupsLegacyMod;
import net.hiccupslegacy.entity.DragonEntity;
import net.hiccupslegacy.entity.MonstrousNightmareEntity;
import net.hiccupslegacy.entity.MonstrousNightmareFlyEntity;
import net.hiccupslegacy.init.HiccupsLegacyModParticleTypes;
import net.hiccupslegacy.init.HiccupsLegacyModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DragonStreamFire {
    public static void execute(LevelAccessor world, double x, double y, double z, LivingEntity entity, FireTypes fireType) {
        DragonStreamFire.execute(world, x, y, z, entity, 30, fireType);
    }

    public static void execute(LevelAccessor world, double x, double y, double z, LivingEntity entity, Integer iterations, FireTypes fireType) {
        Vec3 lookAngles;
        if (entity == null) {
            return;
        }
        double iteration = entity.getPersistentData().m_128459_("iteration");
        entity.getPersistentData().m_128347_("iteration", iteration += 1.0);
        Entity firstPassenger = entity.m_146895_();
        if (firstPassenger != null) {
            lookAngles = firstPassenger.m_20154_();
        } else {
            double yaw = Math.toRadians(entity.m_6080_());
            double pitch = Math.toRadians(entity.m_146909_());
            lookAngles = new Vec3(-Math.sin(yaw) * Math.cos(pitch), -Math.sin(pitch), Math.cos(yaw) * Math.cos(pitch)).m_82541_();
        }
        SoundEvent soundEvent = switch (fireType) {
            case FireTypes.LIGHTNING -> SoundEvents.f_12090_;
            case FireTypes.SOUND -> (SoundEvent)HiccupsLegacyModSounds.SOUND_ATTACK.get();
            default -> SoundEvents.f_11874_;
        };
        float pitch = switch (fireType) {
            case FireTypes.LIGHTNING -> entity.m_217043_().m_188501_() * 0.3f + 1.7f;
            case FireTypes.SOUND -> entity.m_217043_().m_188501_() * 0.4f + 0.8f;
            default -> entity.m_217043_().m_188501_() * 0.4f + 0.7f;
        };
        for (int index0 = 0; index0 < 10; ++index0) {
            ServerLevel _level;
            double lookX = lookAngles.f_82479_;
            double lookY = lookAngles.f_82480_;
            double lookZ = lookAngles.f_82481_;
            double posX = firstPassenger == null ? entity.m_20185_() : firstPassenger.m_20185_();
            double posY = entity.m_20188_();
            double posZ = firstPassenger == null ? entity.m_20189_() : firstPassenger.m_20189_();
            double locX = posX + lookX * 5.0 * (double)(index0 + 1);
            double locY = posY + lookY * 5.0 * (double)(index0 + 1);
            double locZ = posZ + lookZ * 5.0 * (double)(index0 + 1);
            BlockPos currentBlockPos = BlockPos.m_274561_((double)locX, (double)locY, (double)locZ);
            if (index0 == 0 && iteration % 2.0 == 0.0 && world instanceof Level && !(_level = (Level)world).m_5776_()) {
                _level.m_5594_(null, currentBlockPos, soundEvent, SoundSource.NEUTRAL, 2.0f, pitch);
            }
            if (world instanceof ServerLevel) {
                _level = (ServerLevel)world;
                if (fireType == FireTypes.MAGNESIUM) {
                    _level.m_8767_((ParticleOptions)((SimpleParticleType)HiccupsLegacyModParticleTypes.MAGNESIUM_FIRE.get()), locX, locY, locZ, 2, 0.3, 0.3, 0.3, 0.0);
                    _level.m_8767_((ParticleOptions)ParticleTypes.f_123744_, locX, locY, locZ, 2, 0.3, 0.3, 0.3, 0.0);
                    _level.m_8767_((ParticleOptions)ParticleTypes.f_123777_, locX, locY, locZ, 1, 0.4, 0.4, 0.4, 0.01);
                } else if (fireType == FireTypes.BLUE_FIRE) {
                    _level.m_8767_((ParticleOptions)((SimpleParticleType)HiccupsLegacyModParticleTypes.BLUE_FIRE.get()), locX, locY, locZ, 3, 0.3, 0.3, 0.3, 0.0);
                    _level.m_8767_((ParticleOptions)ParticleTypes.f_123745_, locX, locY, locZ, 3, 0.3, 0.3, 0.3, 0.0);
                } else if (fireType == FireTypes.LIGHTNING) {
                    _level.m_8767_((ParticleOptions)ParticleTypes.f_175830_, locX, locY, locZ, 4, 0.3, 0.3, 0.3, 0.0);
                    _level.m_8767_((ParticleOptions)((SimpleParticleType)HiccupsLegacyModParticleTypes.LIGHTNING.get()), locX, locY, locZ, 1, 0.3, 0.3, 0.3, 0.0);
                } else if (fireType == FireTypes.SOUND) {
                    _level.m_8767_((ParticleOptions)((SimpleParticleType)HiccupsLegacyModParticleTypes.SOUND_ATTACK.get()), locX, locY, locZ, 1, 0.0, 0.0, 0.0, 0.0);
                } else {
                    _level.m_8767_((ParticleOptions)ParticleTypes.f_123744_, locX, locY, locZ, 3, 0.3, 0.3, 0.3, 0.0);
                    _level.m_8767_((ParticleOptions)((SimpleParticleType)HiccupsLegacyModParticleTypes.FIRE_1.get()), locX, locY, locZ, 3, 0.3, 0.3, 0.3, 0.0);
                    _level.m_8767_((ParticleOptions)((SimpleParticleType)HiccupsLegacyModParticleTypes.FIRE_2.get()), locX, locY, locZ, 2, 0.3, 0.3, 0.3, 0.0);
                    _level.m_8767_((ParticleOptions)((SimpleParticleType)HiccupsLegacyModParticleTypes.FIRE_3.get()), locX, locY, locZ, 1, 0.3, 0.3, 0.3, 0.0);
                    _level.m_8767_((ParticleOptions)ParticleTypes.f_123777_, locX, locY, locZ, 2, 0.4, 0.4, 0.4, 0.01);
                }
            }
            Vec3 _center = new Vec3(locX, locY, locZ);
            List<Entity> entitiesFound = world.m_6443_(Entity.class, new AABB(_center, _center).m_82400_(2.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.m_20238_(_center))).toList();
            float multiplier = 1.0f;
            if (entity instanceof MonstrousNightmareEntity || entity instanceof MonstrousNightmareFlyEntity) {
                int secondaryTick = ((DragonEntity)entity).getSecondaryAttackTick();
                if (secondaryTick != -1 && entity.f_19797_ - secondaryTick < 300) {
                    multiplier = 1.5f;
                }
            } else if (fireType == FireTypes.LIGHTNING) {
                multiplier = entity.m_9236_().m_46470_() ? (multiplier *= 3.0f) : (entity.m_9236_().m_46471_() ? (multiplier *= 2.5f) : (multiplier *= 2.0f));
            } else if (fireType == FireTypes.SOUND) {
                multiplier *= 2.5f;
            }
            for (Entity entityIterator : entitiesFound) {
                float f;
                if (entity == entityIterator || firstPassenger == entityIterator) continue;
                if (entityIterator instanceof LivingEntity) {
                    LivingEntity _livEnt = (LivingEntity)entityIterator;
                    f = _livEnt.m_21223_();
                } else {
                    f = -1.0f;
                }
                if (!(f > 0.0f)) continue;
                if (fireType != FireTypes.SOUND) {
                    entityIterator.m_20254_((int)(8.0 + Math.floor(multiplier)));
                }
                float damage = 3.0f;
                if (fireType == FireTypes.LIGHTNING) {
                    ((LivingEntity)entityIterator).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 2, false, true, true));
                } else if (fireType == FireTypes.SOUND) {
                    ((LivingEntity)entityIterator).m_7292_(new MobEffectInstance(MobEffects.f_19604_, 100, 1, false, true, true));
                    float knockbackStrength = 1.5f;
                    entityIterator.m_20256_(lookAngles.m_82490_((double)knockbackStrength));
                }
                entityIterator.m_6469_(new DamageSource((Holder)world.m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268534_), (Entity)entity), damage *= multiplier);
            }
            if (world.m_46859_(currentBlockPos)) continue;
            if (!world.m_5776_() && world.m_46859_(currentBlockPos.m_7918_(0, 1, 0)) && world.m_6106_().m_5470_().m_46207_(GameRules.f_46132_) && fireType != FireTypes.LIGHTNING && fireType != FireTypes.SOUND) {
                world.m_7731_(currentBlockPos.m_7918_(0, 1, 0), Blocks.f_50083_.m_49966_(), 3);
            }
            if (!(world.m_8055_(currentBlockPos).m_60800_((BlockGetter)world, currentBlockPos) >= 3.0f) || !(world.m_6425_(currentBlockPos).m_76188_().m_60734_() instanceof LiquidBlock)) break;
        }
        if (iteration >= (double)iterations.intValue()) {
            entity.getPersistentData().m_128347_("iteration", 0.0);
        } else {
            HiccupsLegacyMod.queueServerWork(1, () -> DragonStreamFire.execute(world, x, y, z, entity, iterations, fireType));
        }
    }

    public static enum FireTypes {
        MAGNESIUM(1),
        COMMON_FIRE(2),
        BLUE_FIRE(3),
        LIGHTNING(4),
        SOUND(5);

        private final int id;

        private FireTypes(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

