/*
 * Decompiled with CFR 0.152.
 */
package net.hiccupslegacy.procedures;

import java.util.Comparator;
import java.util.List;
import net.hiccupslegacy.entity.MtEntity;
import net.hiccupslegacy.init.HiccupsLegacyModEntities;
import net.hiccupslegacy.init.HiccupsLegacyModItems;
import net.hiccupslegacy.init.HiccupsLegacyModSounds;
import net.hiccupslegacy.item.InfernoFireItem;
import net.hiccupslegacy.item.InfernoRetractedItem;
import net.hiccupslegacy.item.InfernoSwordItem;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.ItemHandlerHelper;

public class InfernoSwordUtils {
    public static void InfernoFireToolInInventoryTick(Entity entity, ItemStack itemStack) {
        if (entity == null) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (itemStack.m_41720_() == HiccupsLegacyModItems.INFERNO_FIRE.get()) {
                InfernoFireItem sword = (InfernoFireItem)itemStack.m_41720_();
                if (sword.gelAmount <= 0) {
                    if (!entity.m_9236_().m_5776_()) {
                        entity.m_9236_().m_5594_(null, BlockPos.m_274561_((double)entity.m_20185_(), (double)entity.m_20186_(), (double)entity.m_20189_()), SoundEvents.f_11914_, SoundSource.PLAYERS, 0.8f, 1.0f);
                    }
                    ItemStack newStack = new ItemStack((ItemLike)HiccupsLegacyModItems.INFERNO_BLADE.get());
                    newStack.m_41764_(1);
                    CompoundTag existingTag = itemStack.m_41783_();
                    if (existingTag != null) {
                        newStack.m_41751_(existingTag.m_6426_());
                    }
                    livingEntity.m_21008_(InteractionHand.MAIN_HAND, newStack);
                    if (livingEntity instanceof Player) {
                        Player player = (Player)livingEntity;
                        player.m_150109_().m_6596_();
                    }
                } else if (!entity.m_9236_().m_5776_()) {
                    --sword.gelAmount;
                }
            }
        }
    }

    public static void InfernoRetractedRightClicked(LevelAccessor world, double x, double y, double z, Entity entity) {
        Player player;
        block14: {
            block13: {
                if (!(entity instanceof Player)) break block13;
                player = (Player)entity;
                if (!world.m_5776_()) break block14;
            }
            return;
        }
        Item item = player.m_21205_().m_41720_();
        if (item instanceof InfernoRetractedItem) {
            ItemStack canister;
            InfernoRetractedItem infernoRetractedItem = (InfernoRetractedItem)item;
            if (player.m_21206_().m_41720_() == HiccupsLegacyModItems.GEL_CANISTER.get() && infernoRetractedItem.gelAmount < 2400) {
                if (!world.m_5776_()) {
                    world.m_5594_(null, BlockPos.m_274561_((double)x, (double)y, (double)z), SoundEvents.f_11970_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
                canister = new ItemStack((ItemLike)HiccupsLegacyModItems.CANISTER.get()).m_41777_();
                canister.m_41764_(1);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)canister);
                player.m_150109_().m_36022_(p -> new ItemStack((ItemLike)HiccupsLegacyModItems.GEL_CANISTER.get()).m_41720_() == p.m_41720_(), 1, (Container)player.f_36095_.m_39730_());
                infernoRetractedItem.gelAmount = 2400;
                return;
            }
            if (player.m_21206_().m_41720_() == HiccupsLegacyModItems.GAS_CANISTER.get() && infernoRetractedItem.gasAmount < 4) {
                if (!world.m_5776_()) {
                    world.m_5594_(null, BlockPos.m_274561_((double)x, (double)y, (double)z), SoundEvents.f_11677_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
                canister = new ItemStack((ItemLike)HiccupsLegacyModItems.CANISTER.get()).m_41777_();
                canister.m_41764_(1);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)canister);
                player.m_150109_().m_36022_(p -> new ItemStack((ItemLike)HiccupsLegacyModItems.GAS_CANISTER.get()).m_41720_() == p.m_41720_(), 1, (Container)player.f_36095_.m_39730_());
                infernoRetractedItem.gasAmount = 4;
                return;
            }
            int gelAmount = infernoRetractedItem.gelAmount;
            int gasAmount = infernoRetractedItem.gasAmount;
            if (InfernoSwordUtils.spawnZipplebackGasIfHasGas((LivingEntity)player, world)) {
                return;
            }
            if (!world.m_5776_()) {
                world.m_5594_(null, BlockPos.m_274561_((double)x, (double)y, (double)z), SoundEvents.f_11679_, SoundSource.NEUTRAL, 0.8f, 1.0f);
                if (gelAmount > 0) {
                    world.m_5594_(null, BlockPos.m_274561_((double)x, (double)y, (double)z), SoundEvents.f_11874_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
            }
            ItemStack _setstack = new ItemStack(gelAmount > 0 ? (ItemLike)HiccupsLegacyModItems.INFERNO_FIRE.get() : (ItemLike)HiccupsLegacyModItems.INFERNO_BLADE.get()).m_41777_();
            _setstack.m_41764_(1);
            Item item2 = _setstack.m_41720_();
            if (item2 instanceof InfernoSwordItem) {
                InfernoSwordItem infernoSwordItem = (InfernoSwordItem)item2;
                infernoSwordItem.gelAmount = gelAmount;
                infernoSwordItem.gasAmount = gasAmount;
            }
            if (gelAmount > 0) {
                InfernoSwordUtils.igniteGasEntitiesInRadius(world, (LivingEntity)player, 5);
            }
            player.m_21008_(InteractionHand.MAIN_HAND, _setstack);
            player.m_150109_().m_6596_();
        }
    }

    public static void InfernoFireRightClicked(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null || world.m_5776_()) {
            return;
        }
        LivingEntity playerLivingEntity = (LivingEntity)entity;
        if (playerLivingEntity.m_21206_().m_41720_() == ItemStack.f_41583_.m_41720_()) {
            Level _level;
            int gelAmount = 0;
            int gasAmount = 0;
            Item item = playerLivingEntity.m_21205_().m_41720_();
            if (item instanceof InfernoSwordItem) {
                InfernoSwordItem sword = (InfernoSwordItem)item;
                gelAmount = sword.gelAmount;
                gasAmount = sword.gasAmount;
            }
            if (InfernoSwordUtils.spawnZipplebackGasIfHasGas(playerLivingEntity, world)) {
                return;
            }
            ItemStack retractedInferno = new ItemStack((ItemLike)HiccupsLegacyModItems.INFERNO_RETRACTED.get()).m_41777_();
            retractedInferno.m_41764_(1);
            Item item2 = retractedInferno.m_41720_();
            if (item2 instanceof InfernoRetractedItem) {
                InfernoRetractedItem infernoRetractedItem = (InfernoRetractedItem)item2;
                infernoRetractedItem.gelAmount = gelAmount;
                infernoRetractedItem.gasAmount = gasAmount;
            }
            playerLivingEntity.m_21008_(InteractionHand.MAIN_HAND, retractedInferno);
            if (playerLivingEntity instanceof Player) {
                Player _player = (Player)playerLivingEntity;
                _player.m_150109_().m_6596_();
            }
            if (world instanceof Level && !(_level = (Level)world).m_5776_()) {
                _level.m_5594_(null, BlockPos.m_274561_((double)x, (double)y, (double)z), SoundEvents.f_11679_, SoundSource.NEUTRAL, 0.8f, 1.0f);
            }
        }
    }

    private static boolean spawnZipplebackGasIfHasGas(LivingEntity playerLivingEntity, LevelAccessor world) {
        Player player;
        if (!(playerLivingEntity instanceof Player) || !(player = (Player)playerLivingEntity).m_36341_()) {
            return false;
        }
        if (world.m_5776_()) {
            return false;
        }
        ItemStack mainHandItem = player.m_21205_();
        Item item = mainHandItem.m_41720_();
        if (!(item instanceof InfernoSwordItem)) {
            return false;
        }
        InfernoSwordItem _sword = (InfernoSwordItem)item;
        int gasAmount = _sword.gasAmount--;
        if (gasAmount <= 0) {
            return false;
        }
        if (!world.m_5776_()) {
            world.m_5594_(null, BlockPos.m_274561_((double)playerLivingEntity.m_20185_(), (double)playerLivingEntity.m_20186_(), (double)playerLivingEntity.m_20189_()), (SoundEvent)HiccupsLegacyModSounds.HIDEOUSZIPPLEBACK_GAS.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
        if (world instanceof ServerLevel) {
            ServerLevel _level = (ServerLevel)world;
            Entity entityToSpawn = ((EntityType)HiccupsLegacyModEntities.MT.get()).m_262496_(_level, new BlockPos(playerLivingEntity.m_9236_().m_45547_(new ClipContext(playerLivingEntity.m_20299_(1.0f), playerLivingEntity.m_20299_(1.0f).m_82549_(playerLivingEntity.m_20252_(1.0f).m_82490_(2.0)), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)playerLivingEntity)).m_82425_().m_123341_(), playerLivingEntity.m_9236_().m_45547_(new ClipContext(playerLivingEntity.m_20299_(1.0f), playerLivingEntity.m_20299_(1.0f).m_82549_(playerLivingEntity.m_20252_(1.0f).m_82490_(2.0)), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)playerLivingEntity)).m_82425_().m_123342_(), playerLivingEntity.m_9236_().m_45547_(new ClipContext(playerLivingEntity.m_20299_(1.0f), playerLivingEntity.m_20299_(1.0f).m_82549_(playerLivingEntity.m_20252_(1.0f).m_82490_(2.0)), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)playerLivingEntity)).m_82425_().m_123343_()), MobSpawnType.MOB_SUMMONED);
            if (entityToSpawn != null) {
                entityToSpawn.m_146922_(world.m_213780_().m_188501_() * 360.0f);
            }
        }
        return true;
    }

    private static void igniteGasEntitiesInRadius(LevelAccessor world, LivingEntity livingEntity, int radius) {
        Entity gasEntity;
        double z;
        double y;
        double x = livingEntity.m_20185_();
        List gasEntities = world.m_6443_(MtEntity.class, AABB.m_165882_((Vec3)new Vec3(x, y = livingEntity.m_20186_(), z = livingEntity.m_20189_()), (double)radius, (double)radius, (double)radius), e -> true);
        if (!gasEntities.isEmpty() && (gasEntity = (Entity)gasEntities.stream().min(new Object(){

            Comparator<Entity> compareDistOf(double _x, double _y, double _z) {
                return Comparator.comparingDouble(_entcnd -> _entcnd.m_20275_(_x, _y, _z));
            }
        }.compareDistOf(x, y, z)).orElse(null)) != null) {
            double gasX = gasEntity.m_20185_();
            double gasY = gasEntity.m_20186_();
            double gasZ = gasEntity.m_20189_();
            if (!gasEntity.m_9236_().m_5776_()) {
                gasEntity.m_146870_();
            }
            if (world instanceof ServerLevel) {
                ServerLevel _level = (ServerLevel)world;
                Entity entityToSpawn = ((EntityType)HiccupsLegacyModEntities.FT.get()).m_262496_(_level, BlockPos.m_274561_((double)gasX, (double)gasY, (double)gasZ), MobSpawnType.MOB_SUMMONED);
                if (entityToSpawn != null) {
                    entityToSpawn.m_146922_(world.m_213780_().m_188501_() * 360.0f);
                }
            }
            if (!world.m_5776_()) {
                world.m_5594_(null, BlockPos.m_274561_((double)x, (double)y, (double)z), SoundEvents.f_11784_, SoundSource.NEUTRAL, 1.0f, 0.7f);
                world.m_5594_(null, BlockPos.m_274561_((double)x, (double)y, (double)z), SoundEvents.f_11913_, SoundSource.NEUTRAL, 0.5f, 1.1f);
                world.m_5594_(null, BlockPos.m_274561_((double)x, (double)y, (double)z), SoundEvents.f_11942_, SoundSource.NEUTRAL, 1.0f, 0.8f);
            }
        }
    }
}

