/*
 * Decompiled with CFR 0.152.
 */
package com.corrinedev.jsconf.api;

import com.corrinedev.jsconf.JSConf;
import com.corrinedev.jsconf.api.Config;
import com.google.gson.JsonElement;
import java.lang.reflect.Type;

public class ConfigValue<E> {
    public final String element;
    private E value;
    private final Type type;

    public ConfigValue(E value, String element, Type type) {
        this.value = value;
        this.element = element;
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public ConfigValue(E value, String element, String confToAdd, Type type) {
        this(value, element, type);
        JSConf.CONFIGS.get(confToAdd).addValue(this);
    }

    public ConfigValue(E value, String element, Config confToAdd, Type type) {
        this(value, element, type);
        confToAdd.addValue(this);
    }

    public JsonElement getAsJson() {
        return Config.GSON.toJsonTree(this.value, this.type);
    }

    public ConfigValue<E> set(E val) {
        this.value = val;
        return this;
    }

    public E get() {
        return this.value;
    }

    public String toString() {
        return "ConfigValue{element='" + this.element + "', value=" + String.valueOf(this.value) + "}";
    }
}

