/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.init.events;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import dev.xkmc.l2library.base.effects.ClientEffectCap;
import dev.xkmc.l2library.base.effects.EffectToClient;
import dev.xkmc.l2library.base.effects.api.ClientRenderEffect;
import dev.xkmc.l2library.base.effects.api.DelayedEntityRender;
import dev.xkmc.l2library.base.effects.api.FirstPlayerRenderEffect;
import dev.xkmc.l2library.base.effects.api.IconRenderRegion;
import dev.xkmc.l2library.init.L2LibraryConfig;
import dev.xkmc.l2library.util.Proxy;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="l2library", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientEffectRenderEvents {
    private static final ArrayList<DelayedEntityRender> ICONS = new ArrayList();

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        LocalPlayer player = Proxy.getClientPlayer();
        if (player != null) {
            for (Map.Entry entry : player.m_21221_().entrySet()) {
                Object k = entry.getKey();
                if (!(k instanceof FirstPlayerRenderEffect)) continue;
                FirstPlayerRenderEffect effect = (FirstPlayerRenderEffect)k;
                effect.onClientLevelRender((AbstractClientPlayer)player, (MobEffectInstance)entry.getValue());
            }
        }
    }

    @SubscribeEvent
    public static void levelRenderLast(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_WEATHER) {
            return;
        }
        if (ICONS.isEmpty()) {
            return;
        }
        if (!((Boolean)L2LibraryConfig.CLIENT.renderOverlayIcons.get()).booleanValue()) {
            ICONS.clear();
            return;
        }
        LevelRenderer renderer = event.getLevelRenderer();
        MultiBufferSource.BufferSource buffers = Minecraft.m_91087_().m_91269_().m_110104_();
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        PoseStack stack = event.getPoseStack();
        PoseStack posestack = RenderSystem.getModelViewStack();
        PoseStack.Pose last = posestack.m_85850_();
        posestack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.disableDepthTest();
        for (DelayedEntityRender icon : ICONS) {
            ClientEffectRenderEvents.renderIcon(stack, (MultiBufferSource)buffers, icon, event.getPartialTick(), camera, renderer.f_109463_);
        }
        buffers.m_109911_();
        posestack.m_85836_();
        posestack.m_166856_();
        posestack.m_85850_().m_252922_().mul((Matrix4fc)last.m_252922_());
        posestack.m_85850_().m_252943_().mul((Matrix3fc)last.m_252943_());
        RenderSystem.applyModelViewMatrix();
        RenderSystem.enableDepthTest();
        ICONS.clear();
    }

    @SubscribeEvent
    public static void onLivingEntityRender(RenderLivingEvent.Post<?, ?> event) {
        LivingEntity entity = event.getEntity();
        ClientEffectRenderEvents.onLivingRenderEvents(entity);
    }

    public static void onLivingRenderEvents(LivingEntity entity) {
        if (!ClientEffectCap.HOLDER.isProper(entity)) {
            return;
        }
        if (entity.m_19880_().contains("ClientOnly")) {
            return;
        }
        ClientEffectCap cap = ClientEffectCap.HOLDER.get(entity);
        ArrayList<Pair> l0 = new ArrayList<Pair>();
        for (Map.Entry<MobEffect, Integer> entry : cap.map.entrySet()) {
            MobEffect mobEffect = entry.getKey();
            if (!(mobEffect instanceof ClientRenderEffect)) continue;
            ClientRenderEffect effect = (ClientRenderEffect)mobEffect;
            l0.add(Pair.of((Object)effect, (Object)entry.getValue()));
        }
        if (l0.isEmpty()) {
            return;
        }
        ArrayList l1 = new ArrayList();
        int index = 0;
        for (Pair e : l0) {
            int lv = (Integer)e.getSecond();
            int size = l1.size();
            int I = index++;
            ((ClientRenderEffect)e.getFirst()).render(entity, lv, x -> l1.add(Pair.of((Object)I, (Object)x)));
            if (l1.size() <= size) continue;
        }
        int n = index;
        int w = (int)Math.ceil(Math.sqrt(n));
        int h = (int)Math.ceil((double)n * 1.0 / (double)w);
        for (Pair e : l1) {
            int i = (Integer)e.getFirst();
            int iy = i / w;
            int iw = Math.min(w, n - iy * w);
            int ix = i - iy * w;
            ICONS.add(((DelayedEntityRender)e.getSecond()).resize(IconRenderRegion.of(w, ix, iy, iw, h)));
        }
    }

    private static void renderIcon(PoseStack pose, MultiBufferSource buffer, DelayedEntityRender icon, float partial, Camera camera, EntityRenderDispatcher dispatcher) {
        LivingEntity entity = icon.entity();
        float f = entity.m_20206_() / 2.0f;
        double x0 = Mth.m_14139_((double)partial, (double)entity.f_19790_, (double)entity.m_20185_());
        double y0 = Mth.m_14139_((double)partial, (double)entity.f_19791_, (double)entity.m_20186_());
        double z0 = Mth.m_14139_((double)partial, (double)entity.f_19792_, (double)entity.m_20189_());
        Vec3 offset = dispatcher.m_114382_((Entity)entity).m_7860_((Entity)entity, partial);
        Vec3 cam_pos = camera.m_90583_();
        double d2 = x0 - cam_pos.f_82479_ + offset.m_7096_();
        double d3 = y0 - cam_pos.f_82480_ + offset.m_7098_();
        double d0 = z0 - cam_pos.f_82481_ + offset.m_7094_();
        pose.m_85836_();
        pose.m_85837_(d2, d3 + (double)f, d0);
        pose.m_252781_(camera.m_253121_());
        PoseStack.Pose entry = pose.m_85850_();
        VertexConsumer ivertexbuilder = buffer.m_6299_(ClientEffectRenderEvents.get2DIcon(icon.rl()));
        float ix0 = -0.5f + icon.region().x();
        float ix1 = ix0 + icon.region().scale();
        float iy0 = -0.5f + icon.region().y();
        float iy1 = iy0 + icon.region().scale();
        float u0 = icon.tx();
        float v0 = icon.ty();
        float u1 = icon.tx() + icon.tw();
        float v1 = icon.ty() + icon.th();
        ClientEffectRenderEvents.iconVertex(entry, ivertexbuilder, ix1, iy0, u0, v1);
        ClientEffectRenderEvents.iconVertex(entry, ivertexbuilder, ix0, iy0, u1, v1);
        ClientEffectRenderEvents.iconVertex(entry, ivertexbuilder, ix0, iy1, u1, v0);
        ClientEffectRenderEvents.iconVertex(entry, ivertexbuilder, ix1, iy1, u0, v0);
        pose.m_85849_();
    }

    private static void iconVertex(PoseStack.Pose entry, VertexConsumer builder, float x, float y, float u, float v) {
        builder.m_252986_(entry.m_252922_(), x, y, 0.0f).m_7421_(u, v).m_252939_(entry.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public static RenderType get2DIcon(ResourceLocation rl) {
        return RenderType.m_173215_((String)"entity_body_icon", (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173083_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(rl, false, false)).m_110685_(RenderStateShard.f_110135_).m_110663_(RenderStateShard.f_110111_).m_110691_(false));
    }

    public static void sync(EffectToClient eff) {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        Entity e = Minecraft.m_91087_().f_91073_.m_6815_(eff.entity);
        if (!(e instanceof LivingEntity)) {
            return;
        }
        LivingEntity le = (LivingEntity)e;
        if (!ClientEffectCap.HOLDER.isProper(le)) {
            return;
        }
        ClientEffectCap cap = ClientEffectCap.HOLDER.get(le);
        if (eff.exist) {
            cap.map.put(eff.effect, eff.level);
        } else {
            cap.map.remove(eff.effect);
        }
    }
}

