/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.placementmodifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class NoiseSlopePlacement
extends PlacementModifier {
    public static final Codec<NoiseSlopePlacement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceKey.m_195966_((ResourceKey)Registries.f_256865_).fieldOf("noise").forGetter(NoiseSlopePlacement::noise), (App)Codec.INT.fieldOf("slope").forGetter(NoiseSlopePlacement::slope), (App)Codec.INT.fieldOf("offset").orElse((Object)0).forGetter(NoiseSlopePlacement::offset), (App)Codec.DOUBLE.fieldOf("xz_scale").forGetter(NoiseSlopePlacement::xzScale), (App)Codec.DOUBLE.fieldOf("y_scale").forGetter(NoiseSlopePlacement::yScale)).apply((Applicative)instance, NoiseSlopePlacement::new));
    public static final PlacementModifierType<NoiseSlopePlacement> TYPE = () -> CODEC;
    private final ResourceKey<NormalNoise.NoiseParameters> noise;
    private final int slope;
    private final int offset;
    private final double xzScale;
    private final double yScale;

    public NoiseSlopePlacement(ResourceKey<NormalNoise.NoiseParameters> noise, int slope, int offset, double xzScale, double yScale) {
        this.noise = noise;
        this.slope = slope;
        this.offset = offset;
        this.xzScale = xzScale;
        this.yScale = yScale;
    }

    public ResourceKey<NormalNoise.NoiseParameters> noise() {
        return this.noise;
    }

    public int slope() {
        return this.slope;
    }

    public int offset() {
        return this.offset;
    }

    public double xzScale() {
        return this.xzScale;
    }

    public double yScale() {
        return this.yScale;
    }

    public Stream<BlockPos> m_213676_(PlacementContext context, RandomSource random, BlockPos pos) {
        return IntStream.range(0, this.count(context, pos)).mapToObj(__ -> pos);
    }

    protected int count(PlacementContext context, BlockPos pos) {
        RandomState state = context.m_191831_().m_6018_().m_7726_().m_214994_();
        double value = state.m_224560_(this.noise).m_75380_((double)pos.m_123341_() * this.xzScale, (double)pos.m_123342_() * this.yScale, (double)pos.m_123343_() * this.xzScale);
        return (int)Math.ceil(value * (double)this.slope) + this.offset;
    }

    public PlacementModifierType<?> m_183327_() {
        return TYPE;
    }
}

