/*
 * Decompiled with CFR 0.152.
 */
package me.xjqsh.lrtactical.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tacz.guns.api.client.animation.statemachine.LuaAnimationStateMachine;
import com.tacz.guns.api.client.other.KeepingItemRenderer;
import com.tacz.guns.client.input.InteractKey;
import me.xjqsh.lrtactical.api.animation.BaseAnimationStateContext;
import me.xjqsh.lrtactical.api.collision.OBB;
import me.xjqsh.lrtactical.api.item.ICustomItem;
import me.xjqsh.lrtactical.client.renderer.item.FlashShieldItemRenderer;
import me.xjqsh.lrtactical.client.renderer.item.MeleeItemRenderer;
import me.xjqsh.lrtactical.config.ClientConfig;
import me.xjqsh.lrtactical.init.ModEffects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="lrtactical")
public class ClientEventsHandler {
    public static double shakeTime = 0.0;
    public static double shakeRadius = 0.0;
    public static double shakeAmplitude = 0.0;
    public static Vec3 shakePos = Vec3.f_82478_;
    public static double shakeType = 0.0;

    public static void handleShakeClient(double time, double radius, double amplitude, Vec3 position) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || player.m_5833_()) {
            return;
        }
        float shakeStrength = ((Double)ClientConfig.EXPLODE_SCREEN_SHAKE_MULTIPLIER.get()).floatValue();
        if (shakeStrength <= 0.0f) {
            return;
        }
        shakeTime = time;
        shakeRadius = radius;
        shakeAmplitude = amplitude * 0.01745329238474369 * (double)shakeStrength;
        shakePos = position;
        shakeType = 2.0 * (Math.random() - 0.5);
    }

    @SubscribeEvent
    public static void computeCameraAngles(ViewportEvent.ComputeCameraAngles event) {
        Entity entity = event.getCamera().m_90592_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        float yaw = event.getYaw();
        float pitch = event.getPitch();
        float roll = event.getRoll();
        shakeTime = Mth.m_14139_((double)(0.05 * event.getPartialTick()), (double)shakeTime, (double)0.0);
        if (player != null && shakeTime > 0.0) {
            float shakeRadiusAmplitude = (float)Mth.m_14008_((double)(1.0 - player.m_20182_().m_82554_(shakePos) / shakeRadius), (double)0.0, (double)1.0);
            boolean onVehicle = player.m_20202_() != null;
            double f = shakeTime * Math.sin(1.5707963267948966 * shakeTime) * shakeAmplitude * (double)shakeRadiusAmplitude * (onVehicle ? 0.1 : 1.0);
            if (shakeType > 0.0) {
                event.setYaw((float)((double)yaw + f * shakeType));
                event.setPitch((float)((double)pitch - f * shakeType));
                event.setRoll((float)((double)roll - f));
            } else {
                event.setYaw((float)((double)yaw - f * shakeType));
                event.setPitch((float)((double)pitch + f * shakeType));
                event.setRoll((float)((double)roll + f));
            }
        }
    }

    @SubscribeEvent
    public static void onRenderHand(RenderHandEvent event) {
        ICustomItem item;
        ItemStack stack;
        Item item2;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (event.getHand() == InteractionHand.OFF_HAND && (item2 = (stack = KeepingItemRenderer.getRenderer().getCurrentItem()).m_41720_()) instanceof ICustomItem && (item = (ICustomItem)item2).blockOffhandRendering(stack)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void tickAnimation(TickEvent.ClientTickEvent event) {
        FlashShieldItemRenderer renderer2;
        LuaAnimationStateMachine animationStateMachine;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack mainHandItem = player.m_21205_();
        BlockEntityWithoutLevelRenderer renderer = IClientItemExtensions.of((ItemStack)mainHandItem).getCustomRenderer();
        if (renderer instanceof MeleeItemRenderer) {
            MeleeItemRenderer renderer1 = (MeleeItemRenderer)renderer;
            LuaAnimationStateMachine<BaseAnimationStateContext> animationStateMachine2 = renderer1.getStateMachine(mainHandItem);
            if (animationStateMachine2 != null) {
                ClientEventsHandler.tickMove(player, animationStateMachine2);
            }
        } else if (renderer instanceof FlashShieldItemRenderer && (animationStateMachine = (renderer2 = (FlashShieldItemRenderer)renderer).getStateMachine(mainHandItem)) != null) {
            ClientEventsHandler.tickMove(player, animationStateMachine);
        }
    }

    private static boolean tickMove(LocalPlayer player, LuaAnimationStateMachine<?> animationStateMachine) {
        if (player.f_108618_ == null) {
            animationStateMachine.trigger("idle");
            return true;
        }
        if (!player.m_108635_() && player.m_20142_()) {
            animationStateMachine.trigger("run");
        } else if (!player.m_108635_() && (double)player.f_108618_.m_108575_().m_165907_() > 0.01) {
            animationStateMachine.trigger("walk");
        } else {
            animationStateMachine.trigger("idle");
        }
        return false;
    }

    public static void afterLevel(float pPartialTicks, long pNanoTime, boolean pRenderLevel) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (!pRenderLevel || mc.f_91073_ == null || player == null) {
            return;
        }
        MobEffectInstance effect = player.m_21124_((MobEffect)ModEffects.BLIND.get());
        if (effect == null) {
            return;
        }
        int tickRemain = effect.m_19557_();
        int alpha = tickRemain > 100 ? 255 : (int)((float)tickRemain / 100.0f * 255.0f);
        int color = ((Boolean)ClientConfig.BLACK_FLASH.get() != false ? 0 : 0xFFFFFF) + (alpha << 24);
        GuiGraphics graphics = new GuiGraphics(mc, mc.m_91269_().m_110104_());
        int width = mc.m_91268_().m_85445_();
        int height = mc.m_91268_().m_85446_();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        graphics.m_280509_(0, 0, width, height, color);
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
    }

    @SubscribeEvent
    public static void onClickInput(InputEvent.InteractionKeyMappingTriggered event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (InteractKey.INTERACT_KEY.m_90857_()) {
            return;
        }
        ItemStack itemInHand = player.m_21120_(InteractionHand.MAIN_HAND);
        Item item = itemInHand.m_41720_();
        if (item instanceof ICustomItem) {
            boolean flag;
            ICustomItem customItem = (ICustomItem)item;
            boolean bl = flag = event.isAttack() && customItem.shouldBlockAttack() || event.isUseItem() && customItem.shouldBlockUse() || event.isPickBlock() && customItem.shouldBlockUse();
            if (flag) {
                event.setSwingHand(false);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void renderAttackHitBox(RenderLevelStageEvent event) {
    }

    public static void renderOBB(PoseStack poseStack, VertexConsumer buffer, float centerX, float centerY, float centerZ, Quaternionf rotation, float halfX, float halfY, float halfZ, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        poseStack.m_252880_(centerX, centerY, centerZ);
        poseStack.m_252781_(rotation);
        LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)buffer, (double)(-halfX), (double)(-halfY), (double)(-halfZ), (double)halfX, (double)halfY, (double)halfZ, (float)red, (float)green, (float)blue, (float)alpha);
        poseStack.m_85849_();
    }

    public static void renderOBB(Vec3 position, OBB obb, PoseStack poseStack, VertexConsumer buffer, float red, float green, float blue, float alpha) {
        Vector3f center = obb.center();
        Vector3f halfExtents = obb.extents();
        Quaternionf rotation = obb.rotation();
        ClientEventsHandler.renderOBB(poseStack, buffer, (float)((double)center.x() - position.m_7096_()), (float)((double)center.y() - position.m_7098_()), (float)((double)center.z() - position.m_7094_()), rotation, halfExtents.x(), halfExtents.y(), halfExtents.z(), red, green, blue, alpha);
    }
}

