/*
 * Decompiled with CFR 0.152.
 */
package com.mcwstairs.kikoz.objects;

import com.mcwstairs.kikoz.objects.BalconyRailing;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StairRailing
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty TOGGLE = BooleanProperty.m_61465_((String)"toggle");
    public static final EnumProperty<BalconyRailing.RailingStyle> STYLE = EnumProperty.m_61587_((String)"style", BalconyRailing.RailingStyle.class);
    public static final VoxelShape N = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)20.0, (double)16.0);
    public static final VoxelShape E = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)20.0, (double)16.0);
    public static final VoxelShape S = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)20.0, (double)16.0);
    public static final VoxelShape W = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)20.0, (double)3.0);
    public static final VoxelShape N_COLLISION = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)38.0, (double)16.0);
    public static final VoxelShape E_COLLISION = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)38.0, (double)16.0);
    public static final VoxelShape S_COLLISION = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)38.0, (double)16.0);
    public static final VoxelShape W_COLLISION = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)38.0, (double)3.0);

    public VoxelShape m_5940_(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext selectionContext) {
        boolean toggle = (Boolean)state.m_61143_((Property)TOGGLE);
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case NORTH: {
                return toggle ? N : S;
            }
            case SOUTH: {
                return toggle ? S : N;
            }
            case EAST: {
                return toggle ? W : E;
            }
            case WEST: {
                return toggle ? E : W;
            }
        }
        return N;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext selectionContext) {
        boolean toggle = (Boolean)state.m_61143_((Property)TOGGLE);
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case NORTH: {
                return toggle ? N_COLLISION : S_COLLISION;
            }
            case SOUTH: {
                return toggle ? S_COLLISION : N_COLLISION;
            }
            case EAST: {
                return toggle ? W_COLLISION : E_COLLISION;
            }
            case WEST: {
                return toggle ? E_COLLISION : W_COLLISION;
            }
        }
        return N_COLLISION;
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return Shapes.m_83040_();
    }

    public StairRailing(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)TOGGLE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(STYLE, (Comparable)((Object)BalconyRailing.RailingStyle.CLASSIC)));
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, TOGGLE, STYLE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_43719_();
        BlockPos blockpos = context.m_8083_();
        Level level = context.m_43725_();
        BlockState neighborState = level.m_8055_(blockpos.m_121945_(direction.m_122424_()));
        Direction playerFacingDirection = context.m_8125_().m_122424_();
        double clickX = context.m_43720_().f_82479_ - (double)blockpos.m_123341_();
        double clickZ = context.m_43720_().f_82481_ - (double)blockpos.m_123343_();
        boolean toggleValue = true;
        if (neighborState.m_61138_((Property)FACING)) {
            Direction neighborFacingDirection = (Direction)neighborState.m_61143_((Property)FACING);
            if (neighborFacingDirection == Direction.NORTH) {
                toggleValue = clickX <= 0.5;
            } else if (neighborFacingDirection == Direction.SOUTH) {
                toggleValue = clickX > 0.5;
            } else if (neighborFacingDirection == Direction.WEST) {
                toggleValue = clickZ > 0.5;
            } else if (neighborFacingDirection == Direction.EAST) {
                toggleValue = clickZ <= 0.5;
            }
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)neighborFacingDirection)).m_61124_((Property)TOGGLE, (Comparable)Boolean.valueOf(toggleValue));
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)playerFacingDirection)).m_61124_((Property)TOGGLE, (Comparable)Boolean.valueOf(true));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        Item item = heldItem.m_41720_();
        if (item == Items.f_42574_) {
            if (level.m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            BalconyRailing.RailingStyle currentStyle = (BalconyRailing.RailingStyle)((Object)state.m_61143_(STYLE));
            BalconyRailing.RailingStyle[] styles = BalconyRailing.RailingStyle.values();
            int newIndex = (currentStyle.ordinal() + 1) % styles.length;
            BalconyRailing.RailingStyle newStyle = styles[newIndex];
            BlockState newState = (BlockState)state.m_61124_(STYLE, (Comparable)((Object)newStyle));
            level.m_7731_(pos, newState, 3);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void onBroken(Level worldIn, BlockPos pos) {
        worldIn.m_46796_(1029, pos, 0);
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return true;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }
}

