/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.item.cell;

import appeng.api.config.FuzzyMode;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.AEKeyFilter;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.storage.cells.ICellWorkbenchItem;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.core.AEConfig;
import appeng.core.localization.Tooltips;
import appeng.items.AEBaseItem;
import appeng.items.contents.CellConfig;
import appeng.items.storage.StorageCellTooltipComponent;
import appeng.util.ConfigInventory;
import gripe._90.megacells.definition.MEGAItems;
import gripe._90.megacells.definition.MEGATranslations;
import gripe._90.megacells.item.cell.BulkCellInventory;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BulkCellItem
extends AEBaseItem
implements ICellWorkbenchItem {
    public static final Handler HANDLER = new Handler();

    public BulkCellItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public ConfigInventory getConfigInventory(ItemStack is) {
        return CellConfig.create((AEKeyFilter)AEItemKey.filter(), (ItemStack)is, (int)1);
    }

    public IUpgradeInventory getUpgrades(ItemStack is) {
        return UpgradeInventories.forItem((ItemStack)is, (int)1);
    }

    public void m_7373_(ItemStack is, Level level, @NotNull List<Component> lines, @NotNull TooltipFlag adv) {
        BulkCellInventory inv = HANDLER.getCellInventory(is, null);
        if (inv != null) {
            AEItemKey storedItem = inv.getStoredItem();
            AEItemKey filterItem = inv.getFilterItem();
            if (storedItem != null) {
                lines.add((Component)Tooltips.of((Component)MEGATranslations.Contains.text(new Object[]{storedItem.getDisplayName()})));
                long quantity = inv.getStoredQuantity();
                lines.add((Component)Tooltips.of((Component)MEGATranslations.Quantity.text(new Object[]{quantity < Long.MAX_VALUE ? Tooltips.ofNumber((long)quantity) : MEGATranslations.ALot.text().m_130948_(Tooltips.NUMBER_TEXT)})));
            } else {
                lines.add((Component)Tooltips.of((Component)MEGATranslations.Empty.text()));
            }
            if (filterItem != null) {
                if (storedItem == null) {
                    lines.add((Component)Tooltips.of((Component)MEGATranslations.PartitionedFor.text(new Object[]{filterItem.getDisplayName()})));
                } else if (!storedItem.equals((Object)filterItem)) {
                    lines.add((Component)MEGATranslations.MismatchedFilter.text().m_130940_(ChatFormatting.DARK_RED));
                }
            } else {
                lines.add((Component)(storedItem != null ? MEGATranslations.MismatchedFilter.text().m_130940_(ChatFormatting.DARK_RED) : Tooltips.of((Component)MEGATranslations.NotPartitioned.text())));
            }
            lines.add((Component)Tooltips.of((Component)MEGATranslations.Compression.text(new Object[]{inv.isCompressionEnabled() ? MEGATranslations.Enabled.text().m_130940_(ChatFormatting.GREEN) : MEGATranslations.Disabled.text().m_130940_(ChatFormatting.RED)})));
        }
    }

    @NotNull
    public Optional<TooltipComponent> m_142422_(ItemStack is) {
        BulkCellInventory inv = HANDLER.getCellInventory(is, null);
        if (inv == null) {
            return Optional.empty();
        }
        ArrayList<ItemStack> upgrades = new ArrayList<ItemStack>();
        if (AEConfig.instance().isTooltipShowCellUpgrades() && inv.isCompressionEnabled()) {
            upgrades.add(MEGAItems.COMPRESSION_CARD.stack());
        }
        ArrayList<GenericStack> content = new ArrayList<GenericStack>();
        if (AEConfig.instance().isTooltipShowCellContent()) {
            if (inv.getStoredItem() != null) {
                content.add(new GenericStack((AEKey)inv.getStoredItem(), inv.getStoredQuantity()));
            } else if (inv.getFilterItem() != null) {
                content.add(new GenericStack((AEKey)inv.getFilterItem(), 0L));
            }
        }
        return Optional.of(new StorageCellTooltipComponent(upgrades, content, false, true));
    }

    public FuzzyMode getFuzzyMode(ItemStack itemStack) {
        return null;
    }

    public void setFuzzyMode(ItemStack itemStack, FuzzyMode fuzzyMode) {
    }

    public static class Handler
    implements ICellHandler {
        private Handler() {
        }

        public boolean isCell(ItemStack is) {
            return is != null && is.m_41720_() instanceof BulkCellItem;
        }

        @Nullable
        public BulkCellInventory getCellInventory(ItemStack is, @Nullable ISaveProvider host) {
            return this.isCell(is) ? new BulkCellInventory(is, host) : null;
        }
    }
}

