/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.inventory.slot;

import com.jerry.mekanism_extras.common.tier.AdvancedFactoryTier;
import com.jerry.mekanism_extras.common.tile.factory.TileEntityExtraFactory;
import java.util.Objects;
import mekanism.api.IContentsListener;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.inventory.slot.InputInventorySlot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdvancedFactoryInputInventorySlot
extends InputInventorySlot {
    private final TileEntityExtraFactory<?> factory;

    public static AdvancedFactoryInputInventorySlot create(TileEntityExtraFactory<?> factory, int process, IInventorySlot outputSlot, @Nullable IContentsListener listener, int x, int y) {
        return AdvancedFactoryInputInventorySlot.create(factory, process, outputSlot, null, listener, x, y);
    }

    public static AdvancedFactoryInputInventorySlot create(TileEntityExtraFactory<?> factory, int process, IInventorySlot outputSlot, @Nullable IInventorySlot secondaryOutputSlot, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(factory, "Factory cannot be null");
        Objects.requireNonNull(outputSlot, "Primary output slot cannot be null");
        return new AdvancedFactoryInputInventorySlot(factory, process, outputSlot, secondaryOutputSlot, listener, x, y);
    }

    private AdvancedFactoryInputInventorySlot(TileEntityExtraFactory<?> factory, int process, IInventorySlot outputSlot, @Nullable IInventorySlot secondaryOutputSlot, @Nullable IContentsListener listener, int x, int y) {
        super(stack -> factory.isValidInputItem((ItemStack)stack) && factory.inputProducesOutput(process, (ItemStack)stack, outputSlot, secondaryOutputSlot, false), factory::isValidInputItem, listener, x, y);
        this.factory = factory;
    }

    public void setStackUnchecked(@NotNull ItemStack stack) {
        super.setStackUnchecked(stack);
    }

    public int getLimit(@NotNull ItemStack stack) {
        if (this.factory != null) {
            return switch (this.factory.tier) {
                default -> throw new IncompatibleClassChangeError();
                case AdvancedFactoryTier.ABSOLUTE -> super.getLimit(stack) * 8;
                case AdvancedFactoryTier.SUPREME -> super.getLimit(stack) * 16;
                case AdvancedFactoryTier.COSMIC -> super.getLimit(stack) * 32;
                case AdvancedFactoryTier.INFINITE -> super.getLimit(stack) * 64;
            };
        }
        return super.getLimit(stack);
    }
}

