/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.item;

import com.jerry.mekanism_extras.common.content.network.transmitter.IExtraUpgradeableTransmitter;
import com.jerry.mekanism_extras.common.registry.ExtraBlock;
import java.util.ArrayList;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.tier.BaseTier;
import mekanism.common.Mekanism;
import mekanism.common.advancements.MekanismCriteriaTriggers;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.network.transmitter.BufferedTransmitter;
import mekanism.common.content.network.transmitter.IUpgradeableTransmitter;
import mekanism.common.content.network.transmitter.Transmitter;
import mekanism.common.lib.transmitter.DynamicBufferedNetwork;
import mekanism.common.lib.transmitter.DynamicNetwork;
import mekanism.common.tile.transmitter.TileEntityLogisticalTransporter;
import mekanism.common.tile.transmitter.TileEntityMechanicalPipe;
import mekanism.common.tile.transmitter.TileEntityPressurizedTube;
import mekanism.common.tile.transmitter.TileEntityThermodynamicConductor;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.tile.transmitter.TileEntityUniversalCable;
import mekanism.common.upgrade.transmitter.TransmitterUpgradeData;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public class ItemAlloyRadiance
extends Item {
    public ItemAlloyRadiance(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos;
        Level world;
        BlockEntity tile;
        LazyOptional capability;
        Player player = context.m_43723_();
        if (player != null && MekanismConfig.general.transmitterAlloyUpgrade.get() && (capability = CapabilityUtils.getCapability((ICapabilityProvider)(tile = WorldUtils.getTileEntity((BlockGetter)(world = context.m_43725_()), (BlockPos)(pos = context.m_8083_()))), (Capability)Capabilities.ALLOY_INTERACTION, (Direction)context.m_43719_())).isPresent() && world.m_7702_(pos) instanceof TileEntityTransmitter) {
            if (!world.f_46443_) {
                this.onExtraAlloyInteraction(player, context.m_43722_(), world, pos, (TileEntityTransmitter)world.m_7702_(pos));
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void onExtraAlloyInteraction(Player player, ItemStack stack, Level level, BlockPos worldPosition, TileEntityTransmitter tileEntityTransmitter) {
        if (level != null && tileEntityTransmitter.getTransmitter().hasTransmitterNetwork()) {
            DynamicNetwork transmitterNetwork = tileEntityTransmitter.getTransmitter().getTransmitterNetwork();
            ArrayList list = new ArrayList(transmitterNetwork.getTransmitters());
            list.sort((o1, o2) -> {
                if (o1 != null && o2 != null) {
                    return Double.compare(o1.getTilePos().m_123331_((Vec3i)worldPosition), o2.getTilePos().m_123331_((Vec3i)worldPosition));
                }
                return 0;
            });
            boolean sharesSet = false;
            int upgraded = 0;
            for (Transmitter transmitter : list) {
                IBlockProvider target;
                BlockState upgradeState;
                TileEntityTransmitter transmitterTile;
                BlockState state;
                IUpgradeableTransmitter upgradeableTransmitter;
                if (!(transmitter instanceof IUpgradeableTransmitter) || (upgradeableTransmitter = (IUpgradeableTransmitter)transmitter).getTier().getBaseTier() != this.getBaseTier() || (state = (transmitterTile = transmitter.getTransmitterTile()).m_58900_()) == (upgradeState = BlockStateHelper.copyStateData((BlockState)state, (IBlockProvider)(target = ItemAlloyRadiance.getiBlockProvider(transmitterTile))))) continue;
                if (!sharesSet) {
                    if (transmitterNetwork instanceof DynamicBufferedNetwork) {
                        DynamicBufferedNetwork dynamicNetwork = (DynamicBufferedNetwork)transmitterNetwork;
                        dynamicNetwork.validateSaveShares((BufferedTransmitter)transmitter);
                    }
                    sharesSet = true;
                }
                transmitter.startUpgrading();
                TransmitterUpgradeData upgradeData = upgradeableTransmitter.getUpgradeData();
                BlockPos transmitterPos = transmitter.getTilePos();
                Level transmitterWorld = transmitter.getTileWorld();
                if (upgradeData == null) {
                    Mekanism.logger.warn("Got no upgrade data for transmitter at position: {} in {} but it said it would be able to provide some.", (Object)transmitterPos, (Object)transmitterWorld);
                    continue;
                }
                transmitterWorld.m_46597_(transmitterPos, upgradeState);
                TileEntityTransmitter upgradedTile = (TileEntityTransmitter)WorldUtils.getTileEntity(TileEntityTransmitter.class, (BlockGetter)transmitterWorld, (BlockPos)transmitterPos);
                if (upgradedTile == null) {
                    Mekanism.logger.warn("Error upgrading transmitter at position: {} in {}.", (Object)transmitterPos, (Object)transmitterWorld);
                    continue;
                }
                Transmitter upgradedTransmitter = upgradedTile.getTransmitter();
                if (upgradedTransmitter instanceof IUpgradeableTransmitter) {
                    this.transferUpgradeData((IExtraUpgradeableTransmitter)upgradedTransmitter, upgradeData);
                } else {
                    Mekanism.logger.warn("Unhandled upgrade data.", (Throwable)new IllegalStateException());
                }
                if (++upgraded != 8) continue;
                break;
            }
            if (upgraded > 0) {
                transmitterNetwork.invalidate(null);
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    MekanismCriteriaTriggers.ALLOY_UPGRADE.trigger(serverPlayer);
                }
            }
        }
    }

    private static IBlockProvider getiBlockProvider(TileEntityTransmitter transmitterTile) {
        if (transmitterTile instanceof TileEntityPressurizedTube) {
            return ExtraBlock.ABSOLUTE_PRESSURIZED_TUBE;
        }
        if (transmitterTile instanceof TileEntityUniversalCable) {
            return ExtraBlock.ABSOLUTE_UNIVERSAL_CABLE;
        }
        if (transmitterTile instanceof TileEntityMechanicalPipe) {
            return ExtraBlock.ABSOLUTE_MECHANICAL_PIPE;
        }
        if (transmitterTile instanceof TileEntityThermodynamicConductor) {
            return ExtraBlock.ABSOLUTE_THERMODYNAMIC_CONDUCTOR;
        }
        if (transmitterTile instanceof TileEntityLogisticalTransporter) {
            return ExtraBlock.ABSOLUTE_LOGISTICAL_TRANSPORTER;
        }
        return null;
    }

    private <DATA extends TransmitterUpgradeData> void transferUpgradeData(IExtraUpgradeableTransmitter<DATA> upgradeableTransmitter, TransmitterUpgradeData data) {
        if (upgradeableTransmitter.dataTypeMatches(data)) {
            upgradeableTransmitter.parseUpgradeData(data);
        } else {
            Mekanism.logger.warn("Unhandled upgrade data.", (Throwable)new IllegalStateException());
        }
    }

    private BaseTier getBaseTier() {
        return BaseTier.ULTIMATE;
    }
}

