/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekanism_extras.common.tier;

import com.jerry.mekanism_extras.api.tier.IAdvancedTier;

public class TierColor {
    private static final int[] cosmicColor = new int[]{255, 255, 255};
    private static final int[] infiniteColor = new int[]{1, 2, 3};
    private static final int[] startColor = new int[]{255, 255, 255};
    private static final int[] endColor = new int[]{255, 70, 235};
    private static double tCosmic = 0.0;
    private static final double deltaTCosmic = 0.01;
    private static int direction = 1;
    private static double tInfinite = 0.0;
    private static final double deltaTInfinite = 0.01;

    public static float[] getColor(IAdvancedTier tier) {
        float[] fArray;
        switch (tier.getAdvanceTier()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case ABSOLUTE: {
                float[] fArray2 = new float[3];
                fArray2[0] = 1.0f;
                fArray2[1] = 1.0f;
                fArray = fArray2;
                fArray2[2] = 0.0f;
                break;
            }
            case SUPREME: {
                float[] fArray3 = new float[3];
                fArray3[0] = 1.0f;
                fArray3[1] = 0.0f;
                fArray = fArray3;
                fArray3[2] = 0.0f;
                break;
            }
            case COSMIC: {
                float[] fArray4 = new float[3];
                fArray4[0] = (float)cosmicColor[0] / 255.0f;
                fArray4[1] = (float)cosmicColor[1] / 255.0f;
                fArray = fArray4;
                fArray4[2] = (float)cosmicColor[2] / 255.0f;
                break;
            }
            case INFINITE: {
                float[] fArray5 = new float[3];
                fArray5[0] = (float)infiniteColor[0] / 255.0f;
                fArray5[1] = (float)infiniteColor[1] / 255.0f;
                fArray = fArray5;
                fArray5[2] = (float)infiniteColor[2] / 255.0f;
            }
        }
        return fArray;
    }

    public static void tick() {
        TierColor.editCosmicColor();
        TierColor.editInfiniteColor();
    }

    private static void editCosmicColor() {
        TierColor.cosmicColor[0] = (int)((1.0 - tCosmic) * (double)startColor[0] + tCosmic * (double)endColor[0]);
        TierColor.cosmicColor[1] = (int)((1.0 - tCosmic) * (double)startColor[1] + tCosmic * (double)endColor[1]);
        TierColor.cosmicColor[2] = (int)((1.0 - tCosmic) * (double)startColor[2] + tCosmic * (double)endColor[2]);
        if ((tCosmic += 0.01 * (double)direction) > 1.0) {
            tCosmic = 1.0;
            direction = -1;
        } else if (tCosmic < 0.0) {
            tCosmic = 0.0;
            direction = 1;
        }
    }

    private static void editInfiniteColor() {
        TierColor.infiniteColor[0] = (int)(Math.sin(Math.PI * 2 * tInfinite) * 127.0 + 128.0);
        TierColor.infiniteColor[1] = (int)(Math.sin(Math.PI * 2 * (tInfinite + 0.33)) * 127.0 + 128.0);
        TierColor.infiniteColor[2] = (int)(Math.sin(Math.PI * 2 * (tInfinite + 0.67)) * 127.0 + 128.0);
        if ((tInfinite += 0.01) > 1.0) {
            tInfinite = 0.0;
        }
    }
}

