/*
 * Decompiled with CFR 0.152.
 */
package com.github.x3r.mekanism_turrets.client.model;

import com.github.x3r.mekanism_turrets.common.block.LaserTurretBlock;
import com.github.x3r.mekanism_turrets.common.block_entity.LaserTurretBlockEntity;
import com.github.x3r.mekanism_turrets.common.block_entity.LaserTurretTier;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedBlockGeoModel;

public class LaserTurretModel
extends DefaultedBlockGeoModel<LaserTurretBlockEntity> {
    private static final ResourceLocation MODEL_BASIC = new ResourceLocation("mekanism_turrets", "geo/block/basic_laser_turret.geo.json");
    private static final ResourceLocation MODEL_ADVANCED = new ResourceLocation("mekanism_turrets", "geo/block/advanced_laser_turret.geo.json");
    private static final ResourceLocation MODEL_ELITE = new ResourceLocation("mekanism_turrets", "geo/block/elite_laser_turret.geo.json");
    private static final ResourceLocation MODEL_ULTIMATE = new ResourceLocation("mekanism_turrets", "geo/block/ultimate_laser_turret.geo.json");
    private static final ResourceLocation TEXTURE_BASIC = new ResourceLocation("mekanism_turrets", "textures/block/basic_laser_turret.png");
    private static final ResourceLocation TEXTURE_ADVANCED = new ResourceLocation("mekanism_turrets", "textures/block/advanced_laser_turret.png");
    private static final ResourceLocation TEXTURE_ELITE = new ResourceLocation("mekanism_turrets", "textures/block/elite_laser_turret.png");
    private static final ResourceLocation TEXTURE_ULTIMATE = new ResourceLocation("mekanism_turrets", "textures/block/ultimate_laser_turret.png");
    private static final ResourceLocation ANIMATION_BASIC = new ResourceLocation("mekanism_turrets", "animations/block/basic_anim.json");
    private static final ResourceLocation ANIMATION_ADVANCED = new ResourceLocation("mekanism_turrets", "animations/block/advanced_anim.json");
    private static final ResourceLocation ANIMATION_ELITE = new ResourceLocation("mekanism_turrets", "animations/block/elite_anim.json");
    private static final ResourceLocation ANIMATION_ULTIMATE = new ResourceLocation("mekanism_turrets", "animations/block/ultimate_anim.json");

    public LaserTurretModel() {
        super(new ResourceLocation("mekanism_turrets", "laser_turret"));
    }

    public ResourceLocation getModelResource(LaserTurretBlockEntity animatable) {
        return switch (animatable.getTier()) {
            default -> throw new IncompatibleClassChangeError();
            case LaserTurretTier.BASIC -> MODEL_BASIC;
            case LaserTurretTier.ADVANCED -> MODEL_ADVANCED;
            case LaserTurretTier.ELITE -> MODEL_ELITE;
            case LaserTurretTier.ULTIMATE -> MODEL_ULTIMATE;
        };
    }

    public ResourceLocation getTextureResource(LaserTurretBlockEntity animatable) {
        return switch (animatable.getTier()) {
            default -> throw new IncompatibleClassChangeError();
            case LaserTurretTier.BASIC -> TEXTURE_BASIC;
            case LaserTurretTier.ADVANCED -> TEXTURE_ADVANCED;
            case LaserTurretTier.ELITE -> TEXTURE_ELITE;
            case LaserTurretTier.ULTIMATE -> TEXTURE_ULTIMATE;
        };
    }

    public ResourceLocation getAnimationResource(LaserTurretBlockEntity animatable) {
        return switch (animatable.getTier()) {
            default -> throw new IncompatibleClassChangeError();
            case LaserTurretTier.BASIC -> ANIMATION_BASIC;
            case LaserTurretTier.ADVANCED -> ANIMATION_ADVANCED;
            case LaserTurretTier.ELITE -> ANIMATION_ELITE;
            case LaserTurretTier.ULTIMATE -> ANIMATION_ULTIMATE;
        };
    }

    public void setCustomAnimations(LaserTurretBlockEntity animatable, long instanceId, AnimationState<LaserTurretBlockEntity> animationState) {
        CoreGeoBone turret = this.getAnimationProcessor().getBone("turret");
        CoreGeoBone cannon = this.getAnimationProcessor().getBone("cannon");
        if (turret != null && cannon != null) {
            if (this.hasTarget(animatable)) {
                Vec3 targetPos = new Vec3(this.targetX(animatable), this.targetY(animatable), this.targetZ(animatable));
                Direction direction = (Direction)animatable.m_58900_().m_61143_((Property)LaserTurretBlock.FACING);
                Vec3 center = animatable.m_58899_().m_252807_();
                Vector3f deltaPos = this.getTransform(direction).transform(new Vec3(targetPos.f_82479_ - center.f_82479_, targetPos.f_82480_ - center.f_82480_, targetPos.f_82481_ - center.f_82481_).m_252839_());
                double deltaHorizontal = Math.sqrt(deltaPos.x * deltaPos.x + deltaPos.z * deltaPos.z);
                float xRot = this.lerp(animatable.xRot0, (float)(4.71238899230957 + Math.atan2(deltaPos.y, deltaHorizontal)));
                float yRot = this.lerp(animatable.yRot0, (float)(4.71238899230957 - Math.atan2(deltaPos.z, deltaPos.x)));
                animatable.xRot0 = xRot;
                animatable.yRot0 = yRot;
                cannon.setRotX(xRot);
                turret.setRotY(yRot);
            } else {
                float xRot = this.lerp(animatable.xRot0, -1.5707964f);
                float yRot = this.lerp(animatable.yRot0, 0.0f);
                animatable.xRot0 = xRot;
                animatable.yRot0 = yRot;
                cannon.setRotX(xRot);
                turret.setRotY(yRot);
            }
        }
    }

    private Quaternionf getTransform(Direction direction) {
        switch (direction) {
            case NORTH: {
                return new Quaternionf().rotationX(-1.5707964f);
            }
            case EAST: {
                return new Quaternionf().rotationZ(-1.5707964f);
            }
            case SOUTH: {
                return new Quaternionf().rotationX(1.5707964f);
            }
            case WEST: {
                return new Quaternionf().rotationZ(1.5707964f);
            }
            case UP: {
                return new Quaternionf().rotationZ((float)Math.PI);
            }
            case DOWN: {
                return new Quaternionf();
            }
        }
        return new Quaternionf();
    }

    private float lerp(float start, float end) {
        return Mth.m_14189_((float)0.1f, (float)(start * 57.295776f), (float)(end * 57.295776f)) * ((float)Math.PI / 180);
    }

    private boolean hasTarget(LaserTurretBlockEntity animatable) {
        return Boolean.TRUE.equals(animatable.getAnimData(LaserTurretBlockEntity.HAS_TARGET));
    }

    private double targetX(LaserTurretBlockEntity animatable) {
        Double targetX = (Double)animatable.getAnimData(LaserTurretBlockEntity.TARGET_POS_X);
        if (targetX != null) {
            return targetX;
        }
        return 0.0;
    }

    private double targetY(LaserTurretBlockEntity animatable) {
        Double targetY = (Double)animatable.getAnimData(LaserTurretBlockEntity.TARGET_POS_Y);
        if (targetY != null) {
            return targetY;
        }
        return 0.0;
    }

    private double targetZ(LaserTurretBlockEntity animatable) {
        Double targetZ = (Double)animatable.getAnimData(LaserTurretBlockEntity.TARGET_POS_Z);
        if (targetZ != null) {
            return targetZ;
        }
        return 0.0;
    }
}

