/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.util;

import dev.su5ed.mffs.util.ModFluidType;
import java.util.function.Supplier;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public class FluidRegistryObject {
    private final Supplier<FluidType> fluidType = Lazy.of(() -> new ModFluidType(properties));
    private final Lazy<Fluid> sourceFluid;
    private final Lazy<Fluid> flowingFluid;

    public FluidRegistryObject(ModFluidType.FluidProperties properties) {
        ForgeFlowingFluid.Properties fluidProperties = new ForgeFlowingFluid.Properties(this.fluidType, this::getSourceFluid, this::getFlowingFluid);
        this.sourceFluid = Lazy.of(() -> new ForgeFlowingFluid.Source(fluidProperties));
        this.flowingFluid = Lazy.of(() -> new ForgeFlowingFluid.Flowing(fluidProperties));
    }

    public Supplier<FluidType> fluidType() {
        return this.fluidType;
    }

    public Supplier<Fluid> sourceFluid() {
        return this.sourceFluid;
    }

    public Supplier<Fluid> flowingFluid() {
        return this.flowingFluid;
    }

    public Fluid getSourceFluid() {
        return (Fluid)this.sourceFluid.get();
    }

    public Fluid getFlowingFluid() {
        return (Fluid)this.flowingFluid.get();
    }
}

