/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.util;

import dev.su5ed.mffs.api.module.Module;
import dev.su5ed.mffs.api.module.ModuleType;
import dev.su5ed.mffs.api.security.FieldPermission;
import dev.su5ed.mffs.setup.ModCapabilities;
import dev.su5ed.mffs.setup.ModObjects;
import dev.su5ed.mffs.util.SetBlockEvent;
import dev.su5ed.mffs.util.loot.DamageSourceTrigger;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.IFluidBlock;

public final class ModUtil {
    public static final Integer TICKS_PER_SECOND = 20;

    public static Vec3 rotateByAngleExact(Vec3 pos, double yaw, double pitch, double roll) {
        double yawRadians = Math.toRadians(yaw);
        double pitchRadians = Math.toRadians(pitch);
        double rollRadians = Math.toRadians(roll);
        double x = pos.m_7096_();
        double y = pos.m_7098_();
        double z = pos.m_7094_();
        double mulX = x * Math.cos(yawRadians) * Math.cos(pitchRadians) + z * (Math.cos(yawRadians) * Math.sin(pitchRadians) * Math.sin(rollRadians) - Math.sin(yawRadians) * Math.cos(rollRadians)) + y * (Math.cos(yawRadians) * Math.sin(pitchRadians) * Math.cos(rollRadians) + Math.sin(yawRadians) * Math.sin(rollRadians));
        double mulZ = x * Math.sin(yawRadians) * Math.cos(pitchRadians) + z * (Math.sin(yawRadians) * Math.sin(pitchRadians) * Math.sin(rollRadians) + Math.cos(yawRadians) * Math.cos(rollRadians)) + y * (Math.sin(yawRadians) * Math.sin(pitchRadians) * Math.cos(rollRadians) - Math.cos(yawRadians) * Math.sin(rollRadians));
        double mulY = -x * Math.sin(pitchRadians) + z * Math.cos(pitchRadians) * Math.sin(rollRadians) + y * Math.cos(pitchRadians) * Math.cos(rollRadians);
        return new Vec3(mulX, mulY, mulZ);
    }

    public static boolean moveItemStackTo(ItemStack stack, List<Slot> slots) {
        ItemStack slotStack;
        Slot slot;
        int i;
        boolean success = false;
        if (stack.m_41753_()) {
            for (i = 0; !stack.m_41619_() && i < slots.size(); ++i) {
                int maxCount;
                slot = slots.get(i);
                slotStack = slot.m_7993_();
                if (slotStack.m_41619_() || !ItemStack.m_150942_((ItemStack)stack, (ItemStack)slotStack)) continue;
                int total = stack.m_41613_() + slotStack.m_41613_();
                if (total <= (maxCount = Math.min(slot.m_6641_(), stack.m_41741_()))) {
                    stack.m_41764_(0);
                    slotStack.m_41764_(total);
                    slot.m_6654_();
                    success = true;
                    continue;
                }
                if (slotStack.m_41613_() >= maxCount) continue;
                stack.m_41774_(maxCount - slotStack.m_41613_());
                slotStack.m_41764_(maxCount);
                slot.m_6654_();
                success = true;
            }
        }
        if (!stack.m_41619_()) {
            for (i = 0; i < slots.size(); ++i) {
                slot = slots.get(i);
                slotStack = slot.m_7993_();
                if (!slotStack.m_41619_() || !slot.m_5857_(stack)) continue;
                if (stack.m_41613_() > slot.m_6641_()) {
                    slot.m_5852_(stack.m_41620_(slot.m_6641_()));
                } else {
                    slot.m_5852_(stack.m_41620_(stack.m_41613_()));
                }
                slot.m_6654_();
                return true;
            }
        }
        return success;
    }

    public static BlockPos normalize(BlockPos pos, BlockPos other) {
        if (other.m_123341_() <= pos.m_123341_()) {
            pos = pos.m_122029_();
        }
        if (other.m_123343_() <= pos.m_123343_()) {
            pos = pos.m_122019_();
        }
        if (other.m_123342_() <= pos.m_123342_()) {
            pos = pos.m_7494_();
        }
        return pos;
    }

    public static MutableComponent translate(FieldPermission permission) {
        return ModUtil.translate("info", "field_permission." + permission.name().toLowerCase(Locale.ROOT), new Object[0]);
    }

    public static MutableComponent translateTooltip(FieldPermission permission) {
        return ModUtil.translate("info", "field_permission." + permission.name().toLowerCase(Locale.ROOT) + ".tooltip", new Object[0]);
    }

    public static MutableComponent translate(String prefix, String key, Object ... args) {
        return Component.m_237110_((String)ModUtil.translationKey(prefix, key), (Object[])args);
    }

    public static String translationKey(String prefix, String key) {
        return prefix + ".mffs." + key;
    }

    public static double distance(BlockPos first, BlockPos second) {
        double d0 = second.m_123341_() - first.m_123341_();
        double d1 = second.m_123342_() - first.m_123342_();
        double d2 = second.m_123343_() - first.m_123343_();
        return Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
    }

    public static boolean isLiquidBlock(Block block) {
        return block instanceof LiquidBlock || block instanceof IFluidBlock;
    }

    public static boolean isCard(ItemStack stack) {
        return stack.getCapability(ModCapabilities.FREQUENCY_CARD).isPresent();
    }

    public static boolean isIdentificationCard(ItemStack stack) {
        return stack.getCapability(ModCapabilities.IDENTIFICATION_CARD).isPresent();
    }

    public static boolean isModule(ItemStack stack) {
        return stack.getCapability(ModCapabilities.MODULE_TYPE).isPresent();
    }

    public static boolean isModule(ItemStack stack, Module.Category category) {
        return stack.getCapability(ModCapabilities.MODULE_TYPE).map(module -> module.getCategories().contains((Object)category)).orElse(false);
    }

    public static boolean isModule(ItemStack stack, ModuleType<?> module) {
        return stack.getCapability(ModCapabilities.MODULE_TYPE).filter(mod -> mod == module).isPresent();
    }

    public static boolean isProjectorMode(ItemStack stack) {
        return stack.getCapability(ModCapabilities.PROJECTOR_MODE).isPresent();
    }

    @Nullable
    public static <T extends Enum<T>> T getEnumConstantSafely(Class<T> clazz, String name) {
        try {
            return Enum.valueOf(clazz, name);
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        if (from.m_122434_() == Direction.Axis.Y || to.m_122434_() == Direction.Axis.Y) {
            throw new IllegalArgumentException("Invalid Direction!");
        }
        if (from == to) {
            return shape;
        }
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public static void shockEntity(Entity entity, int damage) {
        entity.m_6469_(entity.m_9236_().m_269111_().m_269079_(ModObjects.FIELD_SHOCK_TYPE), (float)damage);
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            ((DamageSourceTrigger)((Object)ModObjects.DAMAGE_TRIGGER.get())).trigger(serverPlayer, ModObjects.FIELD_SHOCK_TYPE);
        }
    }

    public static void onSetBlock(Level level, BlockPos pos, BlockState state) {
        SetBlockEvent event = new SetBlockEvent((LevelAccessor)level, pos, state);
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    private ModUtil() {
    }
}

