/*
 * Decompiled with CFR 0.152.
 */
package dev.su5ed.mffs.util.loot;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.su5ed.mffs.setup.ModObjects;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Set;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class MenuInventoryTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    private final ResourceLocation id;

    public MenuInventoryTrigger(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation m_7295_() {
        return this.id;
    }

    @NotNull
    public TriggerInstance createInstance(JsonObject json, ContextAwarePredicate predicate, DeserializationContext context) {
        String name = GsonHelper.m_13906_((JsonObject)json, (String)"menu_type");
        MenuType menuType = (MenuType)ForgeRegistries.MENU_TYPES.getValue(new ResourceLocation(name));
        boolean active = GsonHelper.m_13912_((JsonObject)json, (String)"active");
        if (menuType == null) {
            throw new IllegalArgumentException("Unknown MenuType " + name);
        }
        ItemPredicate[] predicates = ItemPredicate.m_45055_((JsonElement)json.get("items"));
        return new TriggerInstance(predicate, menuType, active, predicates);
    }

    public void trigger(ServerPlayer player, boolean active, IItemHandler itemHandler) {
        this.m_66234_(player, instance -> {
            if (instance.active != active) {
                return false;
            }
            ObjectArrayList list = new ObjectArrayList((Object[])instance.items);
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack stackInSlot = itemHandler.getStackInSlot(i);
                list.removeIf(predicate -> predicate.m_45049_(stackInSlot));
            }
            return list.isEmpty();
        });
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final MenuType<?> menuType;
        private final boolean active;
        private final ItemPredicate[] items;

        public TriggerInstance(ContextAwarePredicate predicate, MenuType<?> menuType, boolean active, ItemPredicate[] items) {
            super(((MenuInventoryTrigger)((Object)ModObjects.MENU_INVENTORY_TRIGGER.get())).m_7295_(), predicate);
            this.menuType = menuType;
            this.items = items;
            this.active = active;
        }

        public JsonObject m_7683_(SerializationContext context) {
            JsonObject json = super.m_7683_(context);
            json.addProperty("menu_type", ForgeRegistries.MENU_TYPES.getKey(this.menuType).toString());
            json.addProperty("active", Boolean.valueOf(this.active));
            if (this.items.length > 0) {
                JsonArray predicatesJson = new JsonArray();
                for (ItemPredicate predicate : this.items) {
                    predicatesJson.add(predicate.m_45048_());
                }
                json.add("items", (JsonElement)predicatesJson);
            }
            return json;
        }

        public static TriggerInstance create(MenuType<?> menuType, boolean active, ItemLike ... items) {
            ItemPredicate[] predicates = new ItemPredicate[items.length];
            for (int i = 0; i < items.length; ++i) {
                predicates[i] = new ItemPredicate(null, (Set)ImmutableSet.of((Object)items[i].m_5456_()), MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, EnchantmentPredicate.f_30465_, EnchantmentPredicate.f_30465_, null, NbtPredicate.f_57471_);
            }
            return new TriggerInstance(ContextAwarePredicate.f_285567_, menuType, active, predicates);
        }
    }
}

