/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.common;

import dev.xkmc.l2library.util.math.MathHelper;
import dev.xkmc.l2serial.network.SimplePacketBase;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.l2serial.serialization.codec.PacketCodec;
import dev.xkmc.l2serial.serialization.codec.TagCodec;
import dev.xkmc.l2serial.util.Wrappers;
import dev.xkmc.mob_weapon_api.api.ai.ItemWrapper;
import dev.xkmc.modulargolems.content.capability.GolemConfigEntry;
import dev.xkmc.modulargolems.content.capability.GolemConfigStorage;
import dev.xkmc.modulargolems.content.capability.GolemTracker;
import dev.xkmc.modulargolems.content.capability.PathConfig;
import dev.xkmc.modulargolems.content.config.GolemMaterial;
import dev.xkmc.modulargolems.content.config.GolemMaterialConfig;
import dev.xkmc.modulargolems.content.core.GolemType;
import dev.xkmc.modulargolems.content.core.IGolemPart;
import dev.xkmc.modulargolems.content.entity.common.GolemFlags;
import dev.xkmc.modulargolems.content.entity.common.GuardedEntity;
import dev.xkmc.modulargolems.content.entity.common.ReforgeUpdatePacket;
import dev.xkmc.modulargolems.content.entity.common.SyncedData;
import dev.xkmc.modulargolems.content.entity.goals.FollowOwnerGoal;
import dev.xkmc.modulargolems.content.entity.goals.GolemFloatGoal;
import dev.xkmc.modulargolems.content.entity.goals.GolemMeleeGoal;
import dev.xkmc.modulargolems.content.entity.goals.GolemRandomStrollGoal;
import dev.xkmc.modulargolems.content.entity.goals.GolemSwimMoveControl;
import dev.xkmc.modulargolems.content.entity.goals.TeleportToOwnerGoal;
import dev.xkmc.modulargolems.content.entity.hostile.HostileFaction;
import dev.xkmc.modulargolems.content.entity.hostile.HostileGolemRegistry;
import dev.xkmc.modulargolems.content.entity.metalgolem.MetalGolemEntity;
import dev.xkmc.modulargolems.content.entity.mode.GolemMode;
import dev.xkmc.modulargolems.content.entity.mode.GolemModes;
import dev.xkmc.modulargolems.content.entity.targeting.Golem3DTargetGoal;
import dev.xkmc.modulargolems.content.entity.targeting.TargetManager;
import dev.xkmc.modulargolems.content.item.card.PathRecordCard;
import dev.xkmc.modulargolems.content.item.equipments.CustomDropGolemWeapon;
import dev.xkmc.modulargolems.content.item.equipments.GolemEquipmentItem;
import dev.xkmc.modulargolems.content.item.equipments.TickEquipmentItem;
import dev.xkmc.modulargolems.content.item.golem.GolemHolder;
import dev.xkmc.modulargolems.content.item.upgrade.IUpgradeItem;
import dev.xkmc.modulargolems.content.modifier.base.GolemModifier;
import dev.xkmc.modulargolems.events.event.GolemToOwnerEvent;
import dev.xkmc.modulargolems.init.ModularGolems;
import dev.xkmc.modulargolems.init.advancement.GolemTriggers;
import dev.xkmc.modulargolems.init.data.MGConfig;
import dev.xkmc.modulargolems.init.data.MGLangData;
import dev.xkmc.modulargolems.init.data.MGTagGen;
import dev.xkmc.modulargolems.init.registrate.GolemTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkHooks;

@SerialClass
public class AbstractGolemEntity<T extends AbstractGolemEntity<T, P>, P extends IGolemPart<P>>
extends GuardedEntity
implements IEntityAdditionalSpawnData,
NeutralMob,
OwnableEntity,
PowerableMob {
    private static final SyncedData GOLEM_DATA = new SyncedData(AbstractGolemEntity::defineId);
    private static final EntityDataAccessor<Optional<UUID>> OWNER_ID = GOLEM_DATA.define(SyncedData.UUID, Optional.empty(), null);
    @SerialClass.SerialField(toClient=true)
    private ArrayList<GolemMaterial> materials = new ArrayList();
    @SerialClass.SerialField(toClient=true)
    private ArrayList<Item> upgrades = new ArrayList();
    @SerialClass.SerialField(toClient=true)
    @Nullable
    private UUID owner;
    @SerialClass.SerialField(toClient=true)
    @Nullable
    private UUID leader;
    @SerialClass.SerialField(toClient=true)
    private HashMap<GolemModifier, Integer> modifiers = new LinkedHashMap<GolemModifier, Integer>();
    @SerialClass.SerialField(toClient=true)
    private final HashSet<GolemFlags> golemFlags = new HashSet();
    @SerialClass.SerialField
    private Vec3 recordedPosition = Vec3.f_82478_;
    @SerialClass.SerialField
    private BlockPos recordedGuardPos = BlockPos.f_121853_;
    public int inventoryTick = 0;
    public int specialAttackCoolDown = 0;
    protected final PathNavigation waterNavigation;
    protected final GroundPathNavigation groundNavigation;
    public final Set<MobEffect> effectImmunity = new HashSet<MobEffect>();
    private final List<Goal> modifierGoals = new ArrayList<Goal>();
    private double lastSize = 0.0;
    private boolean sizeDirty = false;
    public static final UUID REFORGE_ID = MathHelper.getUUIDFromString((String)"GolemReforge");
    private static final EntityDataAccessor<Integer> DATA_MODE = GOLEM_DATA.define(SyncedData.INT, 0, "follow_mode");
    private static final EntityDataAccessor<BlockPos> GUARD_POS = GOLEM_DATA.define(SyncedData.BLOCK_POS, BlockPos.f_121853_, "guard_pos");
    private static final EntityDataAccessor<Optional<UUID>> CONFIG_ID = GOLEM_DATA.define(SyncedData.UUID, Optional.empty(), "config_owner");
    private static final EntityDataAccessor<Integer> CONFIG_COLOR = GOLEM_DATA.define(SyncedData.INT, 0, "config_color");
    private static final EntityDataAccessor<Integer> PATROL_STAGE = GOLEM_DATA.define(SyncedData.INT, 0, "patrol_stage");
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = GOLEM_DATA.define(SyncedData.INT, 0, null);
    @Nullable
    private UUID persistentAngerTarget;
    private static final EntityDataAccessor<Boolean> IS_IN_RANGE_ATTACK = SynchedEntityData.m_135353_(AbstractGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    private static <T> EntityDataAccessor<T> defineId(EntityDataSerializer<T> ser) {
        return SynchedEntityData.m_135353_(AbstractGolemEntity.class, ser);
    }

    protected AbstractGolemEntity(EntityType<T> type, Level level) {
        super(type, level);
        this.waterNavigation = new AmphibiousPathNavigation((Mob)this, level);
        this.groundNavigation = new GroundPathNavigation((Mob)this, level);
    }

    public void onCreate(ArrayList<GolemMaterial> materials, ArrayList<IUpgradeItem> upgrades, @Nullable UUID owner) {
        this.updateAttributes(materials, upgrades, owner);
        this.m_21153_(this.m_21233_());
    }

    public void updateAttributes(ArrayList<GolemMaterial> materials, ArrayList<IUpgradeItem> upgrades, @Nullable UUID owner) {
        this.materials = materials;
        this.upgrades = (ArrayList)Wrappers.cast(upgrades);
        this.setOwnerUUID(owner);
        this.modifiers = GolemMaterial.collectModifiers(materials, upgrades);
        this.golemFlags.clear();
        this.m_274367_(1.0f);
        this.getModifiers().forEach((m, i) -> m.onRegisterFlag(this.golemFlags::add));
        if (this.canSwim()) {
            this.f_21342_ = new GolemSwimMoveControl(this);
            this.f_21344_ = this.waterNavigation;
            this.m_21441_(BlockPathTypes.WATER, 0.0f);
            this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        }
        if (!this.m_9236_().m_5776_()) {
            this.modifierGoals.forEach(arg_0 -> ((GoalSelector)this.f_21345_).m_25363_(arg_0));
            this.modifierGoals.clear();
            this.getModifiers().forEach((m, i) -> m.onRegisterGoals(this, (int)i, (priority, goal) -> {
                this.modifierGoals.add((Goal)goal);
                this.f_21345_.m_25352_(priority.intValue(), goal);
            }));
        }
        GolemMaterial.addAttributes(materials, upgrades, this.getThis());
        this.m_6210_();
    }

    public EntityType<T> m_6095_() {
        return (EntityType)Wrappers.cast((Object)super.m_6095_());
    }

    public ArrayList<GolemMaterial> getMaterials() {
        return this.materials;
    }

    public ArrayList<Item> getUpgrades() {
        return this.upgrades;
    }

    public HashMap<GolemModifier, Integer> getModifiers() {
        return this.modifiers;
    }

    public boolean hasFlag(GolemFlags flag) {
        if (this.golemFlags == null) {
            return false;
        }
        return this.golemFlags.contains((Object)flag);
    }

    protected final InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (player.m_21120_(hand).m_204117_(MGTagGen.GOLEM_INTERACT)) {
            return InteractionResult.PASS;
        }
        for (Map.Entry<GolemModifier, Integer> ent : this.modifiers.entrySet()) {
            InteractionResult result = ent.getKey().interact(player, this, hand, ent.getValue());
            if (result == InteractionResult.PASS) continue;
            return result;
        }
        return this.mobInteractImpl(player, hand);
    }

    protected InteractionResult mobInteractImpl(Player player, InteractionHand hand) {
        GolemEquipmentItem item;
        if (!((Boolean)MGConfig.COMMON.barehandRetrieve.get()).booleanValue() || !this.canModify(player)) {
            return InteractionResult.FAIL;
        }
        if (player.m_21205_().m_41619_()) {
            if (!this.m_9236_().m_5776_()) {
                this.m_19877_();
                player.m_8061_(EquipmentSlot.MAINHAND, this.toItem((LivingEntity)player));
            }
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.m_21120_(hand);
        Item item2 = stack.m_41720_();
        if (item2 instanceof GolemEquipmentItem && (item = (GolemEquipmentItem)item2).isFor(this.m_6095_()) && this.m_6844_(item.getSlot()).m_41619_()) {
            if (!this.m_9236_().m_5776_()) {
                this.m_8061_(item.getSlot(), stack.m_41620_(1));
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public void untrack(GolemTracker.Status type, @Nullable Entity cause) {
        UUID id = this.m_21805_();
        if (id == null || id.equals(Util.f_137441_) || this.isHostile()) {
            return;
        }
        if (this.getOwner() instanceof FakePlayer) {
            return;
        }
        GolemTracker tracker = GolemConfigStorage.get(this.m_9236_()).getTracker(id);
        tracker.untrack(this, type, cause);
    }

    public ItemStack toItem(LivingEntity player) {
        this.recordedPosition = this.m_20182_();
        this.recordedGuardPos = this.getGuardPos();
        this.leader = null;
        this.untrack(player == this.getOwner() ? GolemTracker.Status.RETRIEVED : GolemTracker.Status.OTHER_RETRIEVED, (Entity)player);
        ItemStack ans = GolemHolder.setEntity(this.getThis());
        this.m_9236_().m_7605_((Entity)this, (byte)60);
        this.m_146870_();
        return ans;
    }

    public boolean m_5825_() {
        return this.hasFlag(GolemFlags.FIRE_IMMUNE);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_9236_().m_5776_()) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268724_) && source.m_7639_() == null && this.m_20186_() < (double)(this.m_9236_().m_141937_() - 64)) {
            this.m_19877_();
            if (this.hasFlag(GolemFlags.RECYCLE)) {
                this.untrack(GolemTracker.Status.DEATH_RECYCLE, null);
                this.returnToInventory();
            } else {
                this.untrack(GolemTracker.Status.DEATH, null);
            }
            this.m_146870_();
            return true;
        }
        return super.m_6469_(source, amount);
    }

    @Override
    protected void postHurt(DamageSource source) {
        if (this.m_21223_() <= 0.0f && this.hasFlag(GolemFlags.RECYCLE)) {
            this.m_19877_();
            this.untrack(GolemTracker.Status.DEATH_RECYCLE, source.m_7639_());
            this.returnToInventory();
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_146870_();
        }
    }

    protected void m_7472_(DamageSource source, int i, boolean b) {
        MetalGolemEntity golem;
        boolean skip = false;
        Entity entity = source.m_7640_();
        if (entity instanceof MetalGolemEntity && (entity = (golem = (MetalGolemEntity)entity).m_21205_().m_41720_()) instanceof CustomDropGolemWeapon) {
            CustomDropGolemWeapon item = (CustomDropGolemWeapon)entity;
            skip = item.dropCustomDeathLoot(this, golem, golem.m_21205_(), source);
        }
        if (!skip) {
            HashMap<Item, Integer> drop = new HashMap<Item, Integer>();
            for (GolemMaterial mat : this.getMaterials()) {
                Item item = GolemMaterialConfig.get().getCraftIngredient(mat.id()).m_43908_()[0].m_41720_();
                drop.compute(item, (e, old) -> (old == null ? 0 : old) + 1);
            }
            drop.forEach((k, v) -> this.m_19983_(new ItemStack((ItemLike)k, v.intValue())));
        }
        if (!this.isHostile()) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                this.dropSlot(slot, true);
            }
        }
        super.m_7472_(source, i, b);
    }

    protected void dropSlot(EquipmentSlot slot, boolean isDeath) {
        ItemStack itemstack = this.m_6844_(slot);
        if (itemstack.m_41619_()) {
            return;
        }
        if (!isDeath && EnchantmentHelper.m_44920_((ItemStack)itemstack)) {
            return;
        }
        if (isDeath && EnchantmentHelper.m_44924_((ItemStack)itemstack)) {
            return;
        }
        this.m_19983_(itemstack);
        this.m_8061_(slot, ItemStack.f_41583_);
    }

    private double getScaleImpl() {
        int reforge = this.getReforgeBase();
        double rate = Math.pow(1.0 * (double)(reforge - this.getReforgeCount()) / (double)reforge, 0.3333333333333333);
        return this.m_21133_((Attribute)GolemTypes.GOLEM_SIZE.get()) * rate;
    }

    public void checkSize() {
        if (!this.sizeDirty && this.f_19797_ > 5 && this.f_19797_ % 10 != 0) {
            return;
        }
        this.sizeDirty = false;
        double cur = this.getScaleImpl();
        if (this.lastSize != cur) {
            this.m_6210_();
        }
    }

    public void m_6210_() {
        this.lastSize = this.getScaleImpl();
        super.m_6210_();
    }

    public float m_274421_() {
        return super.m_274421_() * this.m_6134_();
    }

    public float m_6134_() {
        if (this.materials == null || this.materials.isEmpty() || this.m_9236_().m_5776_() && !this.isAddedToWorld() || this.m_19880_().contains("ClientOnly")) {
            return 1.0f;
        }
        double def = DefaultAttributes.m_22297_(this.m_6095_()).m_22245_((Attribute)GolemTypes.GOLEM_SIZE.get());
        return (float)(this.getScaleImpl() / def);
    }

    public void m_267651_(boolean hasY) {
        float f = (float)Mth.m_184648_((double)(this.m_20185_() - this.f_19854_), (double)(hasY ? this.m_20186_() - this.f_19855_ : 0.0), (double)(this.m_20189_() - this.f_19856_));
        this.m_267689_(f / this.m_6134_());
    }

    public boolean canSwim() {
        return this.hasFlag(GolemFlags.SWIM);
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (!this.getMode().isMovable()) {
            pTravelVector = Vec3.f_82478_;
        }
        if ((this.m_6109_() || this.m_21515_()) && this.m_20069_() && this.canSwim()) {
            this.m_19920_(0.08f, pTravelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_6109_()) {
                super.m_7023_(pTravelVector);
            }
        } else {
            super.m_7023_(pTravelVector);
        }
    }

    public void m_5844_() {
        if (!this.m_9236_().f_46443_) {
            this.m_20282_(this.m_21515_() && this.m_20069_() && this.canSwim());
        }
    }

    public boolean m_6094_() {
        return this.getMode().isMovable();
    }

    @Deprecated
    public boolean m_6063_() {
        return !this.m_6069_() && this.getMode().isMovable();
    }

    public void setOwnerUUID(@Nullable UUID id) {
        this.owner = id;
        this.f_19804_.m_135381_(OWNER_ID, Optional.ofNullable(this.owner));
    }

    @Nullable
    public final UUID m_21805_() {
        if (this.m_9236_().m_5776_()) {
            return ((Optional)this.f_19804_.m_135370_(OWNER_ID)).orElse(null);
        }
        return this.owner;
    }

    @Nullable
    public Player getOwner() {
        try {
            UUID uuid = this.m_21805_();
            return uuid == null ? null : this.m_9236_().m_46003_(uuid);
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    @Nullable
    public LivingEntity getLeader() {
        try {
            UUID uuid = this.getLeaderUUID();
            if (uuid == null) {
                return null;
            }
            Level level = this.m_9236_();
            if (!(level instanceof ServerLevel)) {
                return null;
            }
            ServerLevel sl = (ServerLevel)level;
            Entity e = sl.m_8791_(uuid);
            if (!(e instanceof LivingEntity)) {
                return null;
            }
            LivingEntity le = (LivingEntity)e;
            return le;
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    @Nullable
    public UUID getLeaderUUID() {
        return this.leader;
    }

    public void setLeader(LivingEntity le) {
        this.leader = le.m_20148_();
    }

    public final boolean isHostile() {
        return HostileGolemRegistry.isHostile(this.m_21805_());
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        this.m_21678_(tag);
        tag.m_128365_("auto-serial", (Tag)Objects.requireNonNull(TagCodec.toTag((CompoundTag)new CompoundTag(), (Object)((Object)this))));
        GOLEM_DATA.write(tag, this.f_19804_);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.m_147285_(this.m_9236_(), tag);
        if (tag.m_128441_("auto-serial")) {
            Wrappers.run(() -> TagCodec.fromTag((CompoundTag)tag.m_128469_("auto-serial"), ((Object)((Object)this)).getClass(), (Object)((Object)this), f -> true));
        }
        this.updateAttributes(this.materials, (ArrayList)Wrappers.cast(this.getUpgrades()), this.owner);
        GOLEM_DATA.read(tag, this.f_19804_);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        PacketCodec.to((FriendlyByteBuf)buffer, (Object)((Object)this));
        buffer.writeInt(this.getReforgeCount());
    }

    public void readSpawnData(FriendlyByteBuf data) {
        PacketCodec.from((FriendlyByteBuf)data, (Class)((Class)Wrappers.cast(((Object)((Object)this)).getClass())), this.getThis());
        this.updateAttributes(this.materials, (ArrayList)Wrappers.cast(this.upgrades), this.owner);
        int reforge = data.readInt();
        if (reforge > 0) {
            this.updateReforge(reforge);
        }
    }

    public T getThis() {
        return (T)((Object)((AbstractGolemEntity)((Object)Wrappers.cast((Object)((Object)this)))));
    }

    public boolean m_142582_(Entity target) {
        if (target.m_9236_() == this.m_9236_() && this.hasFlag(GolemFlags.SEE_THROUGH)) {
            Vec3 self = new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_());
            Vec3 tarp = new Vec3(target.m_20185_(), target.m_20188_(), target.m_20189_());
            double dist = tarp.m_82554_(self);
            if (dist <= 128.0) {
                if (target.m_9236_().m_45527_(target.m_20183_())) {
                    return true;
                }
                if (dist < 5.0) {
                    return true;
                }
                if (self.m_7098_() < tarp.m_7098_()) {
                    return true;
                }
            }
        }
        return super.m_142582_(target);
    }

    public boolean m_142079_() {
        return !this.hasFlag(GolemFlags.FREEZE_IMMUNE);
    }

    public boolean m_142066_() {
        return !this.hasFlag(GolemFlags.PASSIVE) && super.m_142066_();
    }

    public void m_6710_(@Nullable LivingEntity target) {
        if (target != null && !this.m_6779_(target)) {
            return;
        }
        super.m_6710_(target);
        if (target != null) {
            TargetManager.get(this).onSetTarget(this, target);
        }
        if (target instanceof Mob) {
            Mob mob = (Mob)target;
            if (mob.m_5448_() == null && mob.m_6779_((LivingEntity)this)) {
                mob.m_6710_((LivingEntity)this);
            }
            for (Map.Entry<GolemModifier, Integer> entry : this.getModifiers().entrySet()) {
                entry.getKey().onSetTarget(this, mob, entry.getValue());
            }
        }
    }

    public boolean m_6549_(EntityType<?> type) {
        return !this.hasFlag(GolemFlags.PASSIVE);
    }

    public boolean m_6779_(LivingEntity target) {
        Optional<HostileFaction> faction;
        OwnableEntity own;
        LivingEntity parent;
        Player owner = this.getOwner();
        LivingEntity leader = this.getLeader();
        if (target == owner || target == leader) {
            return false;
        }
        if (target instanceof OwnableEntity && (parent = (own = (OwnableEntity)target).m_269323_()) != null && (owner == parent || leader == parent)) {
            return false;
        }
        if (!target.m_142066_()) {
            return false;
        }
        if (!target.m_6084_()) {
            return false;
        }
        if (target instanceof AbstractGolemEntity) {
            AbstractGolemEntity other = (AbstractGolemEntity)target;
            if (this.isHostile() != other.isHostile()) {
                return true;
            }
            if (this.isHostile() && other.isHostile() && this.m_21805_() == other.m_21805_()) {
                return false;
            }
        }
        if ((faction = HostileGolemRegistry.tryGetFaction(this)).isPresent() && faction.get().hostileGolemAttacks(this, target)) {
            return true;
        }
        GolemConfigEntry config = this.getConfigEntry(null);
        if (config == null ? target.m_6095_().m_204039_(MGTagGen.GOLEM_FRIENDLY) : config.targetFilter.friendlyToward(target)) {
            return false;
        }
        return !this.m_7307_((Entity)target) && this.m_6549_(target.m_6095_()) && super.m_6779_(target);
    }

    protected float getAttackDamage() {
        return (float)this.m_21133_(Attributes.f_22281_);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.inventoryTick > 0) {
            --this.inventoryTick;
        }
        if (this.specialAttackCoolDown > 0) {
            --this.specialAttackCoolDown;
        }
        this.checkSize();
        if (this.m_9236_().f_46443_) {
            for (Map.Entry entry : this.getModifiers().entrySet()) {
                ((GolemModifier)((Object)entry.getKey())).onClientTick(this, (Integer)entry.getValue());
            }
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack = this.m_6844_(slot);
            Item item = stack.m_41720_();
            if (!(item instanceof TickEquipmentItem)) continue;
            TickEquipmentItem tickItem = (TickEquipmentItem)item;
            tickItem.tick(stack, this.m_9236_(), (Entity)this);
        }
        UUID id = this.m_21805_();
        if (this.getOwner() instanceof FakePlayer) {
            return;
        }
        if (id == null || id.equals(Util.f_137441_) || this.isHostile()) {
            return;
        }
        GolemTracker golemTracker = GolemConfigStorage.get(this.m_9236_()).getTracker(id);
        golemTracker.track(this);
    }

    public void repair(float amount) {
        this.m_21153_(Math.min(this.m_21233_(), this.m_21223_() + amount));
    }

    protected int getMaxReforge() {
        return GolemType.getGolemType(this.m_6095_()).getBodyPart().toItem().count - 1;
    }

    protected int getReforgeBase() {
        int total = 0;
        for (IGolemPart e : GolemType.getGolemType(this.m_6095_()).values()) {
            total += e.toItem().count;
        }
        return total;
    }

    public void updateReforge(int reforge) {
        this.getPersistentData().m_128405_("GolemReforge", reforge);
        if (!this.m_9236_().m_5776_()) {
            AttributeInstance ins = this.m_21051_(Attributes.f_22276_);
            assert (ins != null);
            ins.m_22120_(REFORGE_ID);
            ins.m_22125_(new AttributeModifier(REFORGE_ID, "Golem Reforge " + reforge, -1.0 * (double)reforge / (double)this.getReforgeBase(), AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        this.sizeDirty = true;
        this.checkSize();
        if (!this.m_9236_().m_5776_()) {
            ModularGolems.HANDLER.toTrackingPlayers((SimplePacketBase)ReforgeUpdatePacket.of(this, reforge), (Entity)this);
        }
    }

    public void checkReforge() {
        int reforge;
        if (this.m_21223_() <= this.m_21233_() / 2.0f && (reforge = this.getPersistentData().m_128451_("GolemReforge")) < this.getMaxReforge()) {
            this.updateReforge(++reforge);
            this.repair(this.m_21233_() / 4.0f);
        }
    }

    public boolean isReforged() {
        return this.getPersistentData().m_128451_("GolemReforge") > 0;
    }

    public int getReforgeCount() {
        return this.getPersistentData().m_128451_("GolemReforge");
    }

    public void repairWithItem() {
        int reforge = this.getPersistentData().m_128451_("GolemReforge");
        if ((double)this.m_21223_() > 0.75 * (double)this.m_21233_() && reforge > 0) {
            this.updateReforge(reforge - 1);
        } else {
            this.repair(this.m_21233_() / 4.0f);
        }
    }

    public void m_8107_() {
        this.m_21203_();
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            if (this.f_19797_ % 20 == 0) {
                double heal = this.m_21133_((Attribute)GolemTypes.GOLEM_REGEN.get());
                for (Map.Entry<GolemModifier, Integer> entry : this.getModifiers().entrySet()) {
                    heal = entry.getKey().onHealTick(heal, this, entry.getValue());
                }
                if (heal > 0.0) {
                    this.m_5634_((float)heal);
                }
                if (this.hasFlag(GolemFlags.REFORGE)) {
                    this.checkReforge();
                }
            }
            for (Map.Entry<GolemModifier, Integer> entry : this.getModifiers().entrySet()) {
                entry.getKey().onAiStep(this, entry.getValue());
            }
            this.m_21666_((ServerLevel)this.m_9236_(), true);
            LivingEntity target = this.m_5448_();
            if (target != null && target.m_6084_()) {
                TargetManager.get(this).tickTarget(this, target);
            }
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack = this.m_6844_(slot);
            if (stack.m_41619_()) continue;
            try {
                stack.m_41666_(this.m_9236_(), (Entity)this, slot.ordinal(), slot == EquipmentSlot.MAINHAND);
            }
            catch (Exception e) {
                ModularGolems.LOGGER.warn("Golem cannot use item " + stack, (Throwable)e);
                this.m_19983_(stack);
                this.m_8061_(slot, ItemStack.f_41583_);
            }
        }
    }

    protected int m_7302_(int air) {
        return air;
    }

    public boolean m_214076_(ServerLevel level, LivingEntity target) {
        Player player = this.getOwner();
        if (player != null) {
            GolemTriggers.KILL.trigger((ServerPlayer)player, (Entity)target);
        }
        return super.m_214076_(level, target);
    }

    public void m_7822_(byte event) {
        for (Map.Entry<GolemModifier, Integer> e : this.modifiers.entrySet()) {
            e.getKey().handleEvent(this, e.getValue(), event);
        }
        super.m_7822_(event);
    }

    public GolemMode getMode() {
        return GolemModes.get((Integer)this.f_19804_.m_135370_(DATA_MODE));
    }

    public BlockPos getGuardPos() {
        return (BlockPos)this.f_19804_.m_135370_(GUARD_POS);
    }

    public void setMode(int mode, BlockPos pos) {
        this.f_19804_.m_135381_(DATA_MODE, (Object)mode);
        this.f_19804_.m_135381_(GUARD_POS, (Object)pos);
    }

    public boolean initMode(@Nullable Player player) {
        boolean succeed;
        GolemConfigEntry config = this.getConfigEntry(null);
        int mode = config == null ? 0 : config.defaultMode;
        boolean far = config != null && config.summonToPosition && mode != 0 && this.recordedPosition.m_82556_() > 0.0;
        BlockPos guard = far && !this.recordedGuardPos.equals((Object)BlockPos.f_121853_) ? this.recordedGuardPos : this.m_20183_();
        Vec3 pos = far ? this.recordedPosition : this.m_20182_();
        boolean bl = succeed = this.m_9236_().m_46749_(BlockPos.m_274446_((Position)pos)) && pos.m_82554_(this.m_20182_()) < (double)((Integer)MGConfig.COMMON.summonDistance.get()).intValue();
        if (!succeed) {
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                sp.m_213846_((Component)MGLangData.SUMMON_FAILED.get(this.m_5446_()));
            }
            return false;
        }
        if (far && player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            sp.m_213846_((Component)MGLangData.SUMMON_FAR.get(this.m_5446_(), (int)pos.m_7096_(), (int)pos.m_7098_(), (int)pos.m_7094_()));
        }
        this.setMode(mode, mode == 0 ? BlockPos.f_121853_ : guard);
        this.m_20219_(pos);
        this.m_6710_(null);
        this.m_6925_(null);
        return true;
    }

    public boolean m_6072_() {
        return this.getMode().canChangeDimensions() && super.m_6072_();
    }

    public int getConfigColor() {
        return (Integer)this.f_19804_.m_135370_(CONFIG_COLOR);
    }

    @Nullable
    public GolemConfigEntry getConfigEntry(@Nullable Component dummy) {
        int configColor = this.getConfigColor();
        Optional<HostileFaction> opt = HostileGolemRegistry.tryGetFaction(this);
        if (opt.isPresent()) {
            return opt.get().getConfig(this, configColor);
        }
        UUID configOwner = ((Optional)this.f_19804_.m_135370_(CONFIG_ID)).orElse(null);
        if (configColor < 0 || configOwner == null) {
            return null;
        }
        GolemConfigStorage storage = GolemConfigStorage.get(this.m_9236_());
        if (dummy == null) {
            return storage.getStorage(configOwner, configColor);
        }
        return storage.getOrCreateStorage(configOwner, configColor, dummy);
    }

    public void setConfigCard(@Nullable UUID owner, int color) {
        this.f_19804_.m_135381_(CONFIG_ID, Optional.ofNullable(owner));
        this.f_19804_.m_135381_(CONFIG_COLOR, (Object)color);
    }

    public void setPatrolStage(int stage) {
        this.f_19804_.m_135381_(PATROL_STAGE, (Object)stage);
    }

    public int getPatrolStage() {
        return (Integer)this.f_19804_.m_135370_(PATROL_STAGE);
    }

    public void advancePatrolStage() {
        List<PathRecordCard.Pos> list = PathConfig.getPath(this);
        if (list == null) {
            return;
        }
        int stage = this.getPatrolStage();
        if (++stage >= list.size()) {
            stage = 0;
        }
        this.setPatrolStage(stage);
    }

    public List<PathRecordCard.Pos> getPatrolList() {
        List<PathRecordCard.Pos> list = PathConfig.getPath(this);
        if (list == null) {
            return List.of();
        }
        int stage = this.getPatrolStage();
        if (stage > 0 && stage < list.size()) {
            List<PathRecordCard.Pos> first = list.subList(stage, list.size());
            List<PathRecordCard.Pos> second = list.subList(0, stage);
            ArrayList<PathRecordCard.Pos> ans = new ArrayList<PathRecordCard.Pos>(first);
            ans.addAll(second);
            return ans;
        }
        return list;
    }

    protected void m_8097_() {
        super.m_8097_();
        GOLEM_DATA.register(this.f_19804_);
        this.f_19804_.m_135372_(IS_IN_RANGE_ATTACK, (Object)false);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    public void m_7870_(int pTime) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)pTime);
    }

    public void m_6925_(@Nullable UUID target) {
        this.persistentAngerTarget = target;
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    @Nullable
    public Team m_5647_() {
        Player owner = this.getOwner();
        if (owner != null) {
            return owner.m_5647_();
        }
        return super.m_5647_();
    }

    public boolean canModify(Player player) {
        GolemConfigEntry entry = this.getConfigEntry(null);
        if (entry != null && entry.locked) {
            return false;
        }
        Player owner = this.getOwner();
        if (player == owner) {
            return true;
        }
        if (player.m_150110_().f_35937_ || this.m_21805_() == null && !this.predicateTarget((LivingEntity)player)) {
            return true;
        }
        if (((Boolean)MGConfig.COMMON.ownerPickupOnly.get()).booleanValue()) {
            return false;
        }
        return this.m_7307_((Entity)player);
    }

    public boolean m_7307_(Entity other) {
        if (other == this) {
            return true;
        }
        Player owner = this.getOwner();
        if (other == owner) {
            return true;
        }
        if (owner != null) {
            return owner.m_7307_(other) || other.m_7307_((Entity)owner);
        }
        Optional<HostileFaction> opt = HostileGolemRegistry.tryGetFaction(this);
        if (opt.isPresent() && opt.get().isAlliedTo(this, other)) {
            return true;
        }
        return super.m_7307_(other);
    }

    public boolean m_7327_(Entity target) {
        if (target instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)target;
            le.m_6598_(this.getOwner());
        }
        return super.m_7327_(target);
    }

    public int aiHurtTarget(Entity target) {
        boolean ans = this.m_7327_(target);
        return ans ? -1 : 0;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new GolemFloatGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new TeleportToOwnerGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new FollowOwnerGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new GolemRandomStrollGoal(this));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new Golem3DTargetGoal(this, 5));
        this.f_21346_.m_25352_(6, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public boolean predicateTarget(LivingEntity e) {
        return TargetManager.predicateTarget(this, e) != null;
    }

    public boolean isInSittingPose() {
        return false;
    }

    @Nullable
    public LivingEntity getFollowTarget() {
        if (this.getMode() == GolemModes.SQUAD) {
            return this.getCaptain();
        }
        LivingEntity leader = this.getLeader();
        if (leader != null) {
            return leader;
        }
        return this.getOwner();
    }

    @Nullable
    public LivingEntity getCaptain() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            GolemConfigEntry config = this.getConfigEntry(null);
            if (config == null) {
                return null;
            }
            UUID uuid = config.squadConfig.getCaptainId();
            if (uuid == null) {
                return null;
            }
            Entity captain = sl.m_8791_(uuid);
            if (captain == null) {
                return null;
            }
            if (!captain.m_6084_() || captain.m_9236_() != sl) {
                return null;
            }
            if (captain instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)captain;
                return le;
            }
            return null;
        }
        return null;
    }

    public Vec3 getTargetPos() {
        if (this.getMode() == GolemModes.ROUTE) {
            List<PathRecordCard.Pos> list = PathConfig.getPath(this);
            if (list != null) {
                int target = this.getPatrolStage();
                if (!list.isEmpty()) {
                    return list.get(Math.min(target, list.size() - 1)).pos().m_252807_();
                }
            }
            return this.m_20182_();
        }
        if (this.getMode().hasPos()) {
            BlockPos pos = this.getGuardPos();
            return new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        }
        LivingEntity owner = this.getFollowTarget();
        if (owner == null) {
            return this.m_20318_(1.0f);
        }
        return owner.m_20318_(1.0f);
    }

    public boolean m_7090_() {
        return true;
    }

    public boolean m_20147_() {
        return this.hasFlag(GolemFlags.IMMUNITY);
    }

    public double m_262793_(LivingEntity target) {
        return GolemMeleeGoal.calculateDistSqr(this, target);
    }

    public void checkRide(LivingEntity target) {
    }

    public void resetTarget(@Nullable LivingEntity le) {
        for (WrappedGoal e : this.f_21346_.m_148105_()) {
            Goal goal = e.m_26015_();
            if (!(goal instanceof TargetGoal)) continue;
            TargetGoal t = (TargetGoal)goal;
            t.m_8041_();
        }
        if (le != null) {
            this.m_6703_(le);
        }
    }

    public ItemWrapper getWrapperOfHand(EquipmentSlot slot) {
        return ItemWrapper.simple(() -> this.m_6844_(slot), e -> super.m_8061_(slot, e));
    }

    @Nullable
    public Entity changeDimension(ServerLevel level, ITeleporter teleporter) {
        if (!((Boolean)MGConfig.COMMON.allowDimensionChange.get()).booleanValue()) {
            return null;
        }
        return super.changeDimension(level, teleporter);
    }

    public boolean isInRangedMode() {
        return this.getMode() == GolemModes.STAND || (Boolean)this.m_20088_().m_135370_(IS_IN_RANGE_ATTACK) != false;
    }

    public void setInRangeAttack(boolean flag) {
        this.m_20088_().m_135381_(IS_IN_RANGE_ATTACK, (Object)flag);
    }

    public boolean canSweep() {
        return false;
    }

    public boolean m_7301_(MobEffectInstance ins) {
        if (this.effectImmunity.contains(ins.m_19544_())) {
            return false;
        }
        return super.m_7301_(ins);
    }

    @Override
    protected boolean isEffectImmune() {
        return this.hasFlag(GolemFlags.EFFECT_IMMUNE);
    }

    public void m_7601_(BlockState state, Vec3 vec) {
        if (this.hasFlag(GolemFlags.FREE_MOVE)) {
            return;
        }
        super.m_7601_(state, vec);
    }

    @Override
    public void onRemove(Entity.RemovalReason reason) {
        if (reason.m_146965_()) {
            this.untrackRemoved(null);
        }
    }

    @Override
    public boolean specialDeath(DamageSource source) {
        if (this.untrackRemoved(source)) {
            this.f_20890_ = true;
            this.m_146870_();
            return true;
        }
        return false;
    }

    protected void m_6153_() {
        if (this.untrackRemoved(null)) {
            this.m_146870_();
        }
        super.m_6153_();
    }

    private boolean untrackRemoved(@Nullable DamageSource source) {
        if (this.m_9236_().m_5776_()) {
            return false;
        }
        UUID id = this.m_21805_();
        if (id == null || id.equals(Util.f_137441_) || this.isHostile()) {
            return false;
        }
        if (this.getOwner() instanceof FakePlayer) {
            return false;
        }
        GolemTracker tracker = GolemConfigStorage.get(this.m_9236_()).getTracker(id);
        if (tracker.isUntracked(this)) {
            return false;
        }
        Player owner = this.getOwner();
        Entity cause = null;
        boolean sendMessages = (Boolean)MGConfig.COMMON.sendForceRemovalMessage.get();
        if (source != null) {
            ModularGolems.LOGGER.info("Golem {} died, message: '{}'", (Object)this, (Object)source.m_6157_((LivingEntity)this).getString());
            if (owner != null && sendMessages) {
                owner.m_213846_(source.m_6157_((LivingEntity)this));
            }
            cause = source.m_7639_();
        } else {
            ModularGolems.LOGGER.info("Golem {} is forcefully removed ", (Object)this);
            if (owner != null && sendMessages) {
                owner.m_213846_((Component)Component.m_237113_((String)("Golem " + this + " is forcefully removed")));
            }
            if (this.m_21213_() == this.f_19797_) {
                cause = this.m_21188_();
            }
        }
        if (this.m_21223_() <= 0.0f && this.hasFlag(GolemFlags.RECYCLE)) {
            tracker.untrack(this, GolemTracker.Status.DEATH_RECYCLE, cause);
            this.returnToInventory();
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            return true;
        }
        tracker.untrack(this, GolemTracker.Status.DEATH, cause);
        return false;
    }

    public void speedUpUseItem(int tick) {
        if (this.f_20936_ > 0) {
            this.f_20936_ -= tick;
        }
    }

    public void m_20343_(double x, double y, double z) {
        this.trackPos(x, y, z);
        super.m_20343_(x, y, z);
    }

    public void trackPos(double x, double y, double z) {
        if (this.m_9236_().m_5776_() || !this.isAddedToWorld()) {
            return;
        }
        UUID id = this.m_21805_();
        if (id == null || id.equals(Util.f_137441_) || this.isHostile()) {
            return;
        }
        if (this.getOwner() instanceof FakePlayer) {
            return;
        }
        GolemTracker tracker = GolemConfigStorage.get(this.m_9236_()).getTracker(id);
        tracker.trackPos(this.m_20148_(), x, y, z);
    }

    public void returnToInventory() {
        LivingEntity leader = this.getLeader();
        ItemStack stack = GolemHolder.setEntity(this.getThis());
        if (leader != null && leader.m_6084_() && MinecraftForge.EVENT_BUS.post((Event)new GolemToOwnerEvent(leader, stack))) {
            return;
        }
        Player player = this.getOwner();
        if (player != null && player.m_6084_()) {
            if (MinecraftForge.EVENT_BUS.post((Event)new GolemToOwnerEvent((LivingEntity)player, stack))) {
                return;
            }
            player.m_150109_().m_150079_(stack);
        } else {
            this.m_19983_(stack);
        }
    }
}

