/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.item.golem;

import dev.xkmc.l2library.util.Proxy;
import dev.xkmc.l2library.util.nbt.ItemCompoundTag;
import dev.xkmc.l2serial.util.Wrappers;
import dev.xkmc.modulargolems.content.core.IGolemPart;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.item.golem.GolemEquipUtil;
import dev.xkmc.modulargolems.content.item.golem.GolemHolder;
import dev.xkmc.modulargolems.init.ModularGolems;
import io.netty.util.collection.IntObjectHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="modulargolems", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientHolderManager {
    private static final int LIFE = 200;
    private static final IntObjectHashMap<TimedCache> CACHE = new IntObjectHashMap();

    @SubscribeEvent
    public static void tickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (CACHE.size() > 100) {
            ModularGolems.LOGGER.error("Golem cache overflow. Clearing...");
            CACHE.clear();
        } else {
            CACHE.entrySet().removeIf(e -> ((TimedCache)e.getValue()).life-- <= 0);
        }
    }

    @Nullable
    public static <T extends AbstractGolemEntity<T, P>, P extends IGolemPart<P>> T getEntityForDisplay(GolemHolder<T, P> holder, ItemStack stack) {
        CompoundTag root = stack.m_41783_();
        if (root == null) {
            return null;
        }
        if (!root.m_128441_("golem_entity") && !root.m_128441_("golem_icon")) {
            return null;
        }
        int hash = stack.hashCode();
        if (CACHE.containsKey(hash)) {
            AbstractGolemEntity<?, ?> ans = ((TimedCache)ClientHolderManager.CACHE.get((int)stack.hashCode())).entity;
            return (T)((Object)(ans == null ? null : (AbstractGolemEntity)((Object)Wrappers.cast(ans))));
        }
        T golem = ClientHolderManager.getEntityForDisplayInternal(holder, stack);
        TimedCache cache = new TimedCache(200, (AbstractGolemEntity<?, ?>)((Object)golem));
        CACHE.put(hash, (Object)cache);
        return golem;
    }

    @Nullable
    private static <T extends AbstractGolemEntity<T, P>, P extends IGolemPart<P>> T getEntityForDisplayInternal(GolemHolder<T, P> holder, ItemStack stack) {
        CompoundTag root = stack.m_41783_();
        if (root == null) {
            return null;
        }
        AbstractGolemEntity ans = null;
        if (root.m_128441_("golem_entity")) {
            CompoundTag entity = root.m_128469_("golem_entity");
            ans = (AbstractGolemEntity)((Object)holder.getEntityType().createForDisplay(entity));
            if (ans != null) {
                ans.onCreate(GolemHolder.getMaterial(stack), GolemHolder.getUpgrades(stack), null);
            }
        } else if (root.m_128441_("golem_icon")) {
            T golem = holder.getEntityType().create((Level)Proxy.getClientWorld());
            golem.m_20049_("ClientOnly");
            ((AbstractGolemEntity)((Object)golem)).onCreate(GolemHolder.getMaterial(stack), GolemHolder.getUpgrades(stack), null);
            ItemCompoundTag tag = ItemCompoundTag.of((ItemStack)stack);
            GolemEquipUtil.addItemsToGolem(golem, root, false);
            ListTag list = tag.getSubList("golem_icon", 10).getOrCreate();
            for (int i = 0; i < list.size(); ++i) {
                ItemStack e = ItemStack.m_41712_((CompoundTag)list.m_128728_(i));
                golem.m_255207_(e);
            }
            ans = (AbstractGolemEntity)((Object)Wrappers.cast(golem));
        }
        if (ans == null) {
            return null;
        }
        ans.f_20916_ = 0;
        return (T)((Object)ans);
    }

    static final class TimedCache {
        @Nullable
        private final AbstractGolemEntity<?, ?> entity;
        private int life;

        TimedCache(int life, @Nullable AbstractGolemEntity<?, ?> entity) {
            this.life = life;
            this.entity = entity;
        }
    }
}

