/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.plate_blocks;

import commoble.morered.plate_blocks.InputSide;
import commoble.morered.plate_blocks.InputState;
import commoble.morered.plate_blocks.LogicFunction;
import commoble.morered.plate_blocks.PlateBlockStateProperties;
import commoble.morered.plate_blocks.RedstonePlateBlock;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class LogicFunctionPlateBlock
extends RedstonePlateBlock {
    public static final DirectionProperty ATTACHMENT_DIRECTION = PlateBlockStateProperties.ATTACHMENT_DIRECTION;
    public static final IntegerProperty ROTATION = PlateBlockStateProperties.ROTATION;
    public static final int OUTPUT_STRENGTH = 15;
    public static final int TICK_DELAY = 1;
    public static final LogicFunctionPlateBlockFactory THREE_INPUTS = LogicFunctionPlateBlock.getBlockFactory(InputSide.A, InputSide.B, InputSide.C);
    public static final LogicFunctionPlateBlockFactory T_INPUTS = LogicFunctionPlateBlock.getBlockFactory(InputSide.A, InputSide.C);
    public static final LogicFunctionPlateBlockFactory LINEAR_INPUT = LogicFunctionPlateBlock.getBlockFactory(InputSide.B);
    private final LogicFunction function;

    public static LogicFunctionPlateBlockFactory getBlockFactory(final InputSide ... inputs) {
        return (properties, function) -> new LogicFunctionPlateBlock(function, properties){

            @Override
            public InputSide[] getInputSides() {
                return inputs;
            }
        };
    }

    public LogicFunctionPlateBlock(BlockBehaviour.Properties properties, LogicFunction function) {
        super(properties);
        this.function = function;
        BlockState baseState = this.m_49966_();
        for (InputSide side : this.getInputSides()) {
            baseState = (BlockState)baseState.m_61124_((Property)side.property, (Comparable)Boolean.valueOf(false));
        }
        this.m_49959_(baseState);
    }

    @Override
    public abstract InputSide[] getInputSides();

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        for (InputSide side : this.getInputSides()) {
            builder.m_61104_(new Property[]{side.property});
        }
    }

    @Deprecated
    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction sideOfAdjacentBlock) {
        if (InputState.getInput(blockState).applyLogic(this.function) && PlateBlockStateProperties.getOutputDirection(blockState) == sideOfAdjacentBlock.m_122424_()) {
            return 15;
        }
        return 0;
    }

    public void m_213897_(BlockState oldBlockState, ServerLevel world, BlockPos pos, RandomSource rand) {
        BlockState newBlockState = InputState.getUpdatedBlockState((Level)world, oldBlockState, pos);
        if (newBlockState != oldBlockState) {
            world.m_7731_(pos, newBlockState, 2);
        }
    }

    @Override
    public EnumSet<Direction> getOutputSides(Level level, BlockPos pos, BlockState state) {
        return EnumSet.of(PlateBlockStateProperties.getOutputDirection(state));
    }

    @FunctionalInterface
    public static interface LogicFunctionPlateBlockFactory {
        public LogicFunctionPlateBlock makeBlock(LogicFunction var1, BlockBehaviour.Properties var2);
    }
}

