/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.nyfsspiders.datagen;

import com.google.common.collect.ImmutableMap;
import com.nyfaria.nyfsspiders.init.BlockInit;
import com.nyfaria.nyfsspiders.init.EntityInit;
import com.nyfaria.nyfsspiders.init.ItemInit;
import com.nyfaria.nyfsspiders.registration.RegistryObject;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.data.PackOutput;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;
import org.apache.commons.lang3.StringUtils;

public class ModLangProvider
extends LanguageProvider {
    protected static final Map<String, String> REPLACE_LIST = ImmutableMap.of((Object)"tnt", (Object)"TNT", (Object)"sus", (Object)"");

    public ModLangProvider(PackOutput gen) {
        super(gen, "nyfsspiders", "en_us");
    }

    protected void addTranslations() {
        ItemInit.ITEMS.getEntries().forEach(this::itemLang);
        EntityInit.ENTITIES.getEntries().forEach(this::entityLang);
        BlockInit.BLOCKS.getEntries().forEach(this::blockLang);
    }

    protected void itemLang(RegistryObject<Item> entry) {
        if (!(entry.get() instanceof BlockItem) || entry.get() instanceof ItemNameBlockItem) {
            this.addItem(entry, this.checkReplace(entry));
        }
    }

    protected void blockLang(RegistryObject<Block> entry) {
        this.addBlock(entry, this.checkReplace(entry));
    }

    protected void entityLang(RegistryObject<EntityType<?>> entry) {
        this.addEntityType(entry, this.checkReplace(entry));
    }

    protected String checkReplace(RegistryObject<?> registryObject) {
        return Arrays.stream(registryObject.getId().m_135815_().split("_")).map(this::checkReplace).filter(s -> !s.isBlank()).collect(Collectors.joining(" ")).trim();
    }

    protected String checkReplace(String string) {
        return REPLACE_LIST.containsKey(string) ? REPLACE_LIST.get(string) : StringUtils.capitalize((String)string);
    }
}

