/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.blocks;

import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.base.TileBlockBase;
import com.wuest.prefab.blocks.entities.LightSwitchBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BlockLightSwitch
extends TileBlockBase<LightSwitchBlockEntity> {
    protected static final VoxelShape NORTH_AABB;
    protected static final VoxelShape SOUTH_AABB;
    protected static final VoxelShape WEST_AABB;
    protected static final VoxelShape EAST_AABB;
    protected static final VoxelShape UP_AABB;
    protected static final VoxelShape DOWN_AABB;
    public static final DirectionProperty FACING;
    public static final EnumProperty<AttachFace> FACE;
    public static final BooleanProperty POWERED;

    public static boolean canAttach(LevelReader levelReader, BlockPos blockPos, Direction direction) {
        BlockPos blockPos2 = blockPos.m_121945_(direction);
        return levelReader.m_8055_(blockPos2).m_60783_((BlockGetter)levelReader, blockPos2, direction.m_122424_());
    }

    protected static Direction getConnectedDirection(BlockState blockState) {
        switch ((AttachFace)blockState.m_61143_(FACE)) {
            case CEILING: {
                return Direction.DOWN;
            }
            case FLOOR: {
                return Direction.UP;
            }
        }
        return (Direction)blockState.m_61143_((Property)FACING);
    }

    public BlockLightSwitch() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283798_).m_278166_(PushReaction.DESTROY).m_60955_().m_60913_(1.5f, 10.0f).m_60910_().m_60978_(0.5f).m_60918_(SoundType.f_56736_));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(FACE, (Comparable)AttachFace.FLOOR)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockLightSwitch(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(FACE, (Comparable)AttachFace.FLOOR)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (!level.f_46443_ && blockState.m_60734_() != blockState2.m_60734_()) {
            ModRegistry.serverModRegistries.getLightSwitchRegistry().remove(level, blockPos);
        }
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (!level.f_46443_) {
            BlockState updatedBlockState = this.cycleSwitch(blockState, level, blockPos);
            float f = (Boolean)updatedBlockState.m_61143_((Property)POWERED) != false ? 0.6f : 0.5f;
            SoundEvent soundEvent = (Boolean)updatedBlockState.m_61143_((Property)POWERED) != false ? SoundEvents.f_12444_ : SoundEvents.f_12443_;
            level.m_5594_(null, blockPos, soundEvent, SoundSource.BLOCKS, 0.3f, f);
            level.m_142346_((Entity)player, (Boolean)updatedBlockState.m_61143_((Property)POWERED) != false ? GameEvent.f_223702_ : GameEvent.f_223703_, blockPos);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState cycleSwitch(BlockState blockState, Level level, BlockPos blockPos) {
        blockState = (BlockState)blockState.m_61122_((Property)POWERED);
        level.m_7731_(blockPos, blockState, 3);
        ModRegistry.serverModRegistries.getLightSwitchRegistry().flipSwitch(level, blockPos, (Boolean)blockState.m_61143_((Property)POWERED));
        return blockState;
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        switch ((AttachFace)blockState.m_61143_(FACE)) {
            case FLOOR: {
                return UP_AABB;
            }
            case WALL: {
                switch ((Direction)blockState.m_61143_((Property)FACING)) {
                    case EAST: {
                        return EAST_AABB;
                    }
                    case WEST: {
                        return WEST_AABB;
                    }
                    case SOUTH: {
                        return SOUTH_AABB;
                    }
                }
                return NORTH_AABB;
            }
        }
        return DOWN_AABB;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction[] directions;
        for (Direction direction : directions = ctx.m_6232_()) {
            BlockState blockState = direction.m_122434_() == Direction.Axis.Y ? (BlockState)((BlockState)this.m_49966_().m_61124_(FACE, (Comparable)(direction == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR))).m_61124_((Property)FACING, (Comparable)ctx.m_8125_()) : (BlockState)((BlockState)this.m_49966_().m_61124_(FACE, (Comparable)AttachFace.WALL)).m_61124_((Property)FACING, (Comparable)direction.m_122424_());
            if (!blockState.m_60710_((LevelReader)ctx.m_43725_(), ctx.m_8083_())) continue;
            return blockState;
        }
        return null;
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        if (!level.f_46443_) {
            ModRegistry.serverModRegistries.getLightSwitchRegistry().register(level, blockPos);
        }
    }

    public boolean m_7898_(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        return BlockLightSwitch.canAttach(levelReader, blockPos, BlockLightSwitch.getConnectedDirection(blockState).m_122424_());
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        return BlockLightSwitch.getConnectedDirection(blockState).m_122424_() == direction && !blockState.m_60710_((LevelReader)levelAccessor, blockPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING}).m_61104_(new Property[]{FACE}).m_61104_(new Property[]{POWERED});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new LightSwitchBlockEntity(blockPos, blockState);
    }

    static {
        FACING = HorizontalDirectionalBlock.f_54117_;
        FACE = EnumProperty.m_61587_((String)"face", AttachFace.class);
        POWERED = BooleanProperty.m_61465_((String)"powered");
        NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0);
        SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0);
        WEST_AABB = Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        EAST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0);
        UP_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
        DOWN_AABB = Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }
}

