/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.crafting;

import com.google.common.base.Strings;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Prefab;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;

public class ConditionedSmeltingRecipe
extends SmeltingRecipe {
    private final ResourceLocation resourceLocation;
    private final String configName;

    public ConditionedSmeltingRecipe(ResourceLocation resourceLocation, String group, CookingBookCategory cookingBookCategory, Ingredient input, ItemStack output, float experience, int cookTime, String configName) {
        super(resourceLocation, group, cookingBookCategory, input, output, experience, cookTime);
        this.resourceLocation = resourceLocation;
        this.configName = configName;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRegistry.ConditionedSmeltingRecipeSeriaizer.get();
    }

    public static class Serializer
    implements RecipeSerializer<ConditionedSmeltingRecipe> {
        public ConditionedSmeltingRecipe fromJson(ResourceLocation identifier, JsonObject jsonObject) {
            String string = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"group", (String)"");
            String configName = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"configName", (String)"");
            JsonArray jsonElement = GsonHelper.m_13885_((JsonObject)jsonObject, (String)"ingredient") ? GsonHelper.m_13933_((JsonObject)jsonObject, (String)"ingredient") : GsonHelper.m_13930_((JsonObject)jsonObject, (String)"ingredient");
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonElement);
            String string2 = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"result");
            ResourceLocation identifier2 = new ResourceLocation(string2);
            ItemStack itemStack = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_6612_(identifier2).orElseThrow(() -> new IllegalStateException("Item: " + string2 + " does not exist")));
            itemStack = Serializer.validateRecipeOutput(itemStack, configName);
            float experience = GsonHelper.m_13820_((JsonObject)jsonObject, (String)"experience", (float)0.0f);
            int cookingtime = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"cookingtime", (int)200);
            return new ConditionedSmeltingRecipe(identifier, string, CookingBookCategory.MISC, ingredient, itemStack, experience, cookingtime, configName);
        }

        public ConditionedSmeltingRecipe fromNetwork(ResourceLocation identifier, FriendlyByteBuf packetByteBuf) {
            String group = packetByteBuf.m_130277_();
            String configName = packetByteBuf.m_130277_();
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)packetByteBuf);
            ItemStack itemStack = Serializer.validateRecipeOutput(packetByteBuf.m_130267_(), configName);
            float experience = packetByteBuf.readFloat();
            int cookTime = packetByteBuf.m_130242_();
            return new ConditionedSmeltingRecipe(identifier, group, CookingBookCategory.MISC, ingredient, itemStack, experience, cookTime, configName);
        }

        public void toNetwork(FriendlyByteBuf packetByteBuf, ConditionedSmeltingRecipe abstractCookingRecipe) {
            packetByteBuf.m_130070_(abstractCookingRecipe.f_43728_);
            packetByteBuf.m_130070_(abstractCookingRecipe.configName);
            abstractCookingRecipe.f_43729_.m_43923_(packetByteBuf);
            packetByteBuf.m_130055_(abstractCookingRecipe.f_43730_);
            packetByteBuf.writeFloat(abstractCookingRecipe.f_43731_);
            packetByteBuf.m_130130_(abstractCookingRecipe.f_43732_);
        }

        public static ItemStack validateRecipeOutput(ItemStack originalOutput, String configName) {
            if (originalOutput == ItemStack.f_41583_) {
                return ItemStack.f_41583_;
            }
            if (!Strings.isNullOrEmpty((String)configName) && Prefab.proxy.getServerConfiguration().recipeConfiguration.containsKey(configName) && !Prefab.proxy.getServerConfiguration().recipeConfiguration.get(configName).booleanValue()) {
                return ItemStack.f_41583_;
            }
            return originalOutput;
        }
    }
}

