/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.gui.controls;

import java.awt.Color;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class GuiTextBox
extends AbstractWidget
implements Renderable,
GuiEventListener {
    private final Font font;
    public int backgroundColor = Color.WHITE.getRGB();
    public boolean drawsTextShadow;
    public String suggestion;
    private String value = "";
    private int maxLength = 32;
    private int frame;
    private boolean bordered = true;
    private boolean canLoseFocus = true;
    private boolean isEditable = true;
    private boolean shiftPressed;
    private int displayPos;
    private int cursorPos;
    private int highlightPos;
    private int textColor = 0xE0E0E0;
    private int textColorUneditable = 0x707070;
    private Consumer<String> responder;
    private Predicate<String> filter = Objects::nonNull;
    private BiFunction<String, Integer, FormattedCharSequence> formatter = (string, integer) -> FormattedCharSequence.m_13714_((String)string, (Style)Style.f_131099_);
    @Nullable
    private Component hint;
    private long focusedTime;

    public GuiTextBox(Font font, int x, int y, int width, int height, Component text) {
        this(font, x, y, width, height, null, text);
    }

    public GuiTextBox(Font textRenderer, int x, int y, int width, int height, GuiTextBox copyFrom, Component text) {
        super(x, y, width, height, text);
        this.font = textRenderer;
        if (copyFrom != null) {
            this.setValue(copyFrom.getValue());
        }
    }

    public void setResponder(Consumer<String> rssponder) {
        this.responder = rssponder;
    }

    public void setFormatter(BiFunction<String, Integer, FormattedCharSequence> textFormatter) {
        this.formatter = textFormatter;
    }

    protected MutableComponent m_5646_() {
        Component component = this.m_6035_();
        return Component.m_237110_((String)"gui.narrate.editBox", (Object[])new Object[]{component, this.value});
    }

    protected void m_87963_(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderTextBox(guiGraphics, i, j, f);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String text) {
        if (this.filter.test(text)) {
            this.value = text.length() > this.maxLength ? text.substring(0, this.maxLength) : text;
            this.moveCursorToEnd(false);
            this.setHighlightPos(this.cursorPos);
            this.onValueChange(text);
        }
    }

    public String getHighlighted() {
        int i = Math.min(this.cursorPos, this.highlightPos);
        int j = Math.max(this.cursorPos, this.highlightPos);
        return this.value.substring(i, j);
    }

    public void setFilter(Predicate<String> validator) {
        this.filter = validator;
    }

    public void insertText(String textToWrite) {
        int i = Math.min(this.cursorPos, this.highlightPos);
        int j = Math.max(this.cursorPos, this.highlightPos);
        int k = this.maxLength - this.value.length() - (i - j);
        if (k > 0) {
            String string3;
            String string2 = SharedConstants.m_136190_((String)textToWrite);
            int l = string2.length();
            if (k < l) {
                if (Character.isHighSurrogate(string2.charAt(k - 1))) {
                    --k;
                }
                string2 = string2.substring(0, k);
                l = k;
            }
            if (this.filter.test(string3 = new StringBuilder(this.value).replace(i, j, string2).toString())) {
                this.value = string3;
                this.setCursorPosition(i + l);
                this.setHighlightPos(this.cursorPos);
                this.onValueChange(this.value);
            }
        }
    }

    private void onValueChange(String newText) {
        if (this.responder != null) {
            this.responder.accept(newText);
        }
    }

    private void deleteText(int i) {
        if (Screen.m_96637_()) {
            this.deleteWords(i);
        } else {
            this.deleteChars(i);
        }
    }

    public void deleteWords(int num) {
        if (!this.value.isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.insertText("");
            } else {
                this.deleteCharsToPos(this.getWordPosition(num));
            }
        }
    }

    public void deleteChars(int i) {
        this.deleteCharsToPos(this.getCursorPos(i));
    }

    public void deleteCharsToPos(int i) {
        if (!this.value.isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.insertText("");
            } else {
                String string;
                int k;
                int j = Math.min(i, this.cursorPos);
                if (j != (k = Math.max(i, this.cursorPos)) && this.filter.test(string = new StringBuilder(this.value).delete(j, k).toString())) {
                    this.value = string;
                    this.moveCursorTo(j, false);
                }
            }
        }
    }

    public int getWordPosition(int numWords) {
        return this.getWordPosition(numWords, this.getCursorPosition());
    }

    private int getWordPosition(int n, int pos) {
        return this.getWordPosition(n, pos, true);
    }

    private int getWordPosition(int i, int j, boolean skipWs) {
        int k = j;
        boolean bl2 = i < 0;
        int l = Math.abs(i);
        for (int m = 0; m < l; ++m) {
            if (!bl2) {
                int n = this.value.length();
                if ((k = this.value.indexOf(32, k)) == -1) {
                    k = n;
                    continue;
                }
                while (skipWs && k < n && this.value.charAt(k) == ' ') {
                    ++k;
                }
                continue;
            }
            while (skipWs && k > 0 && this.value.charAt(k - 1) == ' ') {
                --k;
            }
            while (k > 0 && this.value.charAt(k - 1) != ' ') {
                --k;
            }
        }
        return k;
    }

    public void moveCursor(int i, boolean bl) {
        this.moveCursorTo(this.getCursorPos(i), bl);
    }

    private int getCursorPos(int i) {
        return Util.m_137479_((String)this.value, (int)this.cursorPos, (int)i);
    }

    public void moveCursorTo(int pos, boolean bl) {
        this.setCursorPosition(pos);
        if (!bl) {
            this.setHighlightPos(this.cursorPos);
        }
        this.onValueChange(this.value);
    }

    public void setCursorPosition(int i) {
        this.cursorPos = Mth.m_14045_((int)i, (int)0, (int)this.value.length());
        this.scrollTo(this.cursorPos);
    }

    public void moveCursorToStart(boolean bl) {
        this.moveCursorTo(0, bl);
    }

    public void moveCursorToEnd(boolean bl) {
        this.moveCursorTo(this.value.length(), bl);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.m_142518_() && this.m_93696_()) {
            switch (keyCode) {
                case 259: {
                    if (this.isEditable) {
                        this.deleteText(-1);
                    }
                    return true;
                }
                default: {
                    if (Screen.m_96634_((int)keyCode)) {
                        this.moveCursorToEnd(false);
                        this.setHighlightPos(0);
                        return true;
                    }
                    if (Screen.m_96632_((int)keyCode)) {
                        Minecraft.m_91087_().f_91068_.m_90911_(this.getHighlighted());
                        return true;
                    }
                    if (Screen.m_96630_((int)keyCode)) {
                        if (this.isEditable()) {
                            this.insertText(Minecraft.m_91087_().f_91068_.m_90876_());
                        }
                        return true;
                    }
                    if (Screen.m_96628_((int)keyCode)) {
                        Minecraft.m_91087_().f_91068_.m_90911_(this.getHighlighted());
                        if (this.isEditable()) {
                            this.insertText("");
                        }
                        return true;
                    }
                    return false;
                }
                case 261: {
                    if (this.isEditable) {
                        this.deleteText(1);
                    }
                    return true;
                }
                case 262: {
                    if (Screen.m_96637_()) {
                        this.moveCursorTo(this.getWordPosition(1), Screen.m_96638_());
                    } else {
                        this.moveCursor(1, Screen.m_96638_());
                    }
                    return true;
                }
                case 263: {
                    if (Screen.m_96637_()) {
                        this.moveCursorTo(this.getWordPosition(-1), Screen.m_96638_());
                    } else {
                        this.moveCursor(-1, Screen.m_96638_());
                    }
                    return true;
                }
                case 268: {
                    this.moveCursorToStart(Screen.m_96638_());
                    return true;
                }
                case 269: 
            }
            this.moveCursorToEnd(Screen.m_96638_());
            return true;
        }
        return false;
    }

    public boolean canConsumeInput() {
        return this.m_142518_() && this.m_93696_() && this.isEditable();
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (!this.canConsumeInput()) {
            return false;
        }
        if (SharedConstants.m_136188_((char)codePoint)) {
            if (this.isEditable) {
                this.insertText(Character.toString(codePoint));
            }
            return true;
        }
        return false;
    }

    public void m_5716_(double d, double e) {
        int i = Mth.m_14107_((double)d) - this.m_252754_();
        if (this.bordered) {
            i -= 4;
        }
        String string = this.font.m_92834_(this.value.substring(this.displayPos), this.getInnerWidth());
        this.moveCursorTo(this.font.m_92834_(string, i).length() + this.displayPos, Screen.m_96638_());
    }

    public void setFocus(boolean isFocused) {
        this.m_93692_(isFocused);
    }

    public void renderTextBox(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialFrames) {
        if (this.isVisible()) {
            int var10005;
            int var10004;
            int var10003;
            int innerTextColor;
            if (this.isBordered()) {
                innerTextColor = this.m_93696_() ? -1 : -6250336;
                guiGraphics.m_280509_(this.m_252754_() - 1, this.m_252907_() - 1, this.m_252754_() + this.f_93618_ + 1, this.m_252907_() + this.f_93619_ + 1, innerTextColor);
                guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, this.backgroundColor);
            }
            innerTextColor = this.isEditable ? this.textColor : this.textColorUneditable;
            int l = this.cursorPos - this.displayPos;
            String string = this.font.m_92834_(this.value.substring(this.displayPos), this.getInnerWidth());
            boolean bl = l >= 0 && l <= string.length();
            boolean bl2 = this.m_93696_() && (Util.m_137550_() - this.focusedTime) / 300L % 2L == 0L && bl;
            int m = this.bordered ? this.m_252754_() + 4 : this.m_252754_();
            int n = this.bordered ? this.m_252907_() + (this.f_93619_ - 8) / 2 : this.m_252907_();
            int o = m;
            int p = Mth.m_14045_((int)(this.highlightPos - this.displayPos), (int)0, (int)string.length());
            if (!string.isEmpty()) {
                String string2 = bl ? string.substring(0, l) : string;
                o = guiGraphics.m_280649_(this.font, this.formatter.apply(string2, this.displayPos), m, n, innerTextColor, this.drawsTextShadow);
            }
            boolean bl3 = this.cursorPos < this.value.length() || this.value.length() >= this.getMaxLength();
            int q = o;
            if (!bl) {
                q = l > 0 ? m + this.f_93618_ : m;
            } else if (bl3) {
                q = o - 1;
                --o;
            }
            if (!string.isEmpty() && bl && l < string.length()) {
                guiGraphics.m_280649_(this.font, this.formatter.apply(string.substring(l), this.cursorPos), o, n, innerTextColor, this.drawsTextShadow);
            }
            if (this.hint != null && string.isEmpty() && !this.m_93696_()) {
                guiGraphics.m_280614_(this.font, this.hint, o, n, innerTextColor, this.drawsTextShadow);
            }
            if (!bl3 && this.suggestion != null) {
                guiGraphics.m_280056_(this.font, this.suggestion, q - 1, n, -8355712, this.drawsTextShadow);
            }
            if (bl2) {
                if (bl3) {
                    RenderType var10001 = RenderType.m_286086_();
                    var10003 = n - 1;
                    var10004 = q + 1;
                    var10005 = n + 1;
                    Objects.requireNonNull(this.font);
                    guiGraphics.m_285944_(var10001, q, var10003, var10004, var10005 + 9, -3092272);
                } else {
                    guiGraphics.m_280056_(this.font, "_", q, n, innerTextColor, this.drawsTextShadow);
                }
            }
            if (p != l) {
                int r = m + this.font.m_92895_(string.substring(0, p));
                var10003 = n - 1;
                var10004 = r - 1;
                var10005 = n + 1;
                Objects.requireNonNull(this.font);
                this.renderHighlight(guiGraphics, q, var10003, var10004, var10005 + 9);
            }
        }
    }

    private void renderHighlight(GuiGraphics guiGraphics, int startX, int startY, int endX, int endY) {
        int j;
        if (startX < endX) {
            j = startX;
            startX = endX;
            endX = j;
        }
        if (startY < endY) {
            j = startY;
            startY = endY;
            endY = j;
        }
        if (endX > this.m_252754_() + this.f_93618_) {
            endX = this.m_252754_() + this.f_93618_;
        }
        if (startX > this.m_252754_() + this.f_93618_) {
            startX = this.m_252754_() + this.f_93618_;
        }
        guiGraphics.m_285944_(RenderType.m_285783_(), startX, startY, endX, endY, -16776961);
    }

    private int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int length) {
        this.maxLength = length;
        if (this.value.length() > length) {
            this.value = this.value.substring(0, length);
            this.onValueChange(this.value);
        }
    }

    public int getCursorPosition() {
        return this.cursorPos;
    }

    private boolean isBordered() {
        return this.bordered;
    }

    public void setBordered(boolean enableBackgroundDrawing) {
        this.bordered = enableBackgroundDrawing;
    }

    public void setTextColor(int color) {
        this.textColor = color;
    }

    public void setTextColorUneditable(int color) {
        this.textColorUneditable = color;
    }

    public void m_93692_(boolean focused) {
        if (this.canLoseFocus || focused) {
            super.m_93692_(focused);
            if (focused) {
                this.focusedTime = Util.m_137550_();
            }
        }
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return this.f_93624_ && mouseX >= (double)this.m_252754_() && mouseX < (double)(this.m_252754_() + this.f_93618_) && mouseY >= (double)this.m_252907_() && mouseY < (double)(this.m_252907_() + this.f_93619_);
    }

    protected void onFocusedChanged(boolean focused) {
        if (focused) {
            this.frame = 0;
        }
    }

    private boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean enabled) {
        this.isEditable = enabled;
    }

    public int getInnerWidth() {
        return this.isBordered() ? this.f_93618_ - 8 : this.f_93618_;
    }

    public void setHighlightPos(int position) {
        this.highlightPos = Mth.m_14045_((int)position, (int)0, (int)this.value.length());
        this.scrollTo(this.highlightPos);
    }

    private void scrollTo(int position) {
        if (this.font != null) {
            this.displayPos = Math.min(this.displayPos, this.value.length());
            int j = this.getInnerWidth();
            String string = this.font.m_92834_(this.value.substring(this.displayPos), j);
            int k = string.length() + this.displayPos;
            if (position == this.displayPos) {
                this.displayPos -= this.font.m_92837_(this.value, j, true).length();
            }
            if (position > k) {
                this.displayPos += position - k;
            } else if (position <= this.displayPos) {
                this.displayPos -= this.displayPos - position;
            }
            this.displayPos = Mth.m_14045_((int)this.displayPos, (int)0, (int)this.value.length());
        }
    }

    public void setCanLoseFocus(boolean canLoseFocus) {
        this.canLoseFocus = canLoseFocus;
    }

    public boolean isVisible() {
        return this.f_93624_;
    }

    public void setVisible(boolean isVisible) {
        this.f_93624_ = isVisible;
    }

    public void setSuggestion(String string) {
        this.suggestion = string;
    }

    public int getScreenX(int i) {
        return i > this.value.length() ? this.m_252754_() : this.m_252754_() + this.font.m_92895_(this.value.substring(0, i));
    }

    public void m_168797_(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)Component.m_237110_((String)"narration.edit_box", (Object[])new Object[]{this.getValue()}));
    }

    public void setHint(Component component) {
        this.hint = component;
    }
}

