/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.predefined;

import com.wuest.prefab.Prefab;
import com.wuest.prefab.structures.base.BuildBlock;
import com.wuest.prefab.structures.base.BuildClear;
import com.wuest.prefab.structures.base.BuildingMethods;
import com.wuest.prefab.structures.base.Structure;
import com.wuest.prefab.structures.config.BulldozerConfiguration;
import com.wuest.prefab.structures.config.StructureConfiguration;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;

public class StructureBulldozer
extends Structure {
    protected static DiggerItem diamondPickaxe;
    protected static DiggerItem diamondShovel;
    protected static DiggerItem diamondAxe;
    protected static ItemStack diamondPickaxeStack;
    protected static ItemStack diamondShovelStack;
    protected static ItemStack diamondAxeStack;

    public StructureBulldozer() {
        BuildClear clearedSpace = new BuildClear();
        clearedSpace.getShape().setDirection(Direction.SOUTH);
        clearedSpace.getShape().setHeight(15);
        clearedSpace.getShape().setLength(16);
        clearedSpace.getShape().setWidth(16);
        clearedSpace.getStartingPosition().setSouthOffset(1);
        clearedSpace.getStartingPosition().setEastOffset(8);
        clearedSpace.getStartingPosition().setHeightOffset(1);
        this.setClearSpace(clearedSpace);
        this.setBlocks(new ArrayList<BuildBlock>());
    }

    @Override
    protected Boolean BlockShouldBeClearedDuringConstruction(StructureConfiguration configuration, Level world, BlockPos originalPos, BlockPos blockPos) {
        BlockState state = world.m_8055_(blockPos);
        BulldozerConfiguration specificConfiguration = (BulldozerConfiguration)configuration;
        boolean pickAxeEffective = diamondPickaxe.isCorrectToolForDrops(diamondPickaxeStack, state);
        boolean axeEffective = diamondAxe.isCorrectToolForDrops(diamondAxeStack, state);
        boolean shovelEffective = diamondShovel.isCorrectToolForDrops(diamondShovelStack, state);
        float destroySpeed = state.m_60800_((BlockGetter)world, blockPos);
        if (!specificConfiguration.creativeMode && Prefab.proxy.getServerConfiguration().allowBulldozerToCreateDrops && (state.m_60834_() && pickAxeEffective || axeEffective || shovelEffective || !state.m_60834_()) && destroySpeed >= 0.0f) {
            Block.m_49950_((BlockState)state, (Level)world, (BlockPos)blockPos);
        }
        if (specificConfiguration.creativeMode && state.m_60734_() instanceof LiquidBlock) {
            BuildingMethods.ReplaceBlock(world, blockPos, Blocks.f_50069_);
        }
        return true;
    }

    @Override
    public void BeforeHangingEntityRemoved(HangingEntity hangingEntity) {
        if (Prefab.proxy.getServerConfiguration().allowBulldozerToCreateDrops) {
            hangingEntity.m_5553_(null);
        }
    }

    static {
        diamondAxe = (DiggerItem)Items.f_42391_;
        diamondPickaxe = (DiggerItem)Items.f_42390_;
        diamondShovel = (DiggerItem)Items.f_42389_;
        diamondPickaxeStack = new ItemStack((ItemLike)Items.f_42390_);
        diamondShovelStack = new ItemStack((ItemLike)Items.f_42389_);
        diamondAxeStack = new ItemStack((ItemLike)Items.f_42391_);
    }
}

